/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.rx.rm.runtime;

import com.sun.istack.NotNull;
import com.sun.istack.Nullable;
import com.sun.istack.logging.Logger;
import com.sun.xml.ws.rx.RxRuntimeException;
import com.sun.xml.ws.rx.rm.protocol.AcknowledgementData;
import com.sun.xml.ws.rx.rm.runtime.ApplicationMessage;
import com.sun.xml.ws.rx.rm.runtime.MessageHandler;
import com.sun.xml.ws.rx.rm.runtime.sequence.DuplicateMessageRegistrationException;
import com.sun.xml.ws.rx.rm.runtime.sequence.Sequence;
import com.sun.xml.ws.rx.rm.runtime.sequence.SequenceManager;
import com.sun.xml.ws.rx.rm.runtime.sequence.UnknownSequenceException;
import java.util.logging.Level;

class SourceMessageHandler
implements MessageHandler {
    private static final Logger LOGGER = Logger.getLogger(SourceMessageHandler.class);
    private volatile SequenceManager sequenceManager;

    SourceMessageHandler(@Nullable SequenceManager sequenceManager) {
        this.sequenceManager = sequenceManager;
    }

    void setSequenceManager(SequenceManager sequenceManager) {
        this.sequenceManager = sequenceManager;
    }

    public void registerMessage(@NotNull ApplicationMessage outMessage, @NotNull String outboundSequenceId, boolean storeMessage) throws DuplicateMessageRegistrationException, UnknownSequenceException {
        assert (this.sequenceManager != null);
        assert (outMessage != null);
        assert (outboundSequenceId != null);
        Sequence outboundSequence = this.sequenceManager.getOutboundSequence(outboundSequenceId);
        outboundSequence.registerMessage(outMessage, storeMessage);
    }

    public void attachAcknowledgementInfo(@NotNull ApplicationMessage outMessage) throws UnknownSequenceException {
        assert (this.sequenceManager != null);
        assert (outMessage != null);
        assert (outMessage.getSequenceId() != null);
        outMessage.setAcknowledgementData(this.getAcknowledgementData(outMessage.getSequenceId()));
    }

    public AcknowledgementData getAcknowledgementData(String outboundSequenceId) throws UnknownSequenceException {
        Sequence outboundSequence;
        assert (this.sequenceManager != null);
        AcknowledgementData.Builder ackDataBuilder = AcknowledgementData.getBuilder();
        Sequence inboundSequence = this.sequenceManager.getBoundSequence(outboundSequenceId);
        if (inboundSequence != null) {
            ackDataBuilder.acknowledgements(inboundSequence.getId(), inboundSequence.getAcknowledgedMessageNumbers(), inboundSequence.isClosed());
            inboundSequence.clearAckRequestedFlag();
        }
        if ((outboundSequence = this.sequenceManager.getOutboundSequence(outboundSequenceId)).hasUnacknowledgedMessages()) {
            ackDataBuilder.ackReqestedSequenceId(outboundSequenceId);
            outboundSequence.updateLastAcknowledgementRequestTime();
        }
        AcknowledgementData acknowledgementData = ackDataBuilder.build();
        return acknowledgementData;
    }

    @Override
    public void putToDeliveryQueue(ApplicationMessage message) throws RxRuntimeException {
        assert (this.sequenceManager != null);
        if (LOGGER.isLoggable(Level.FINER)) {
            LOGGER.finer(String.format("Putting a message with number [ %d ] to the delivery queue of a sequence [ %s ]", message.getMessageNumber(), message.getSequenceId()));
        }
        this.sequenceManager.getOutboundSequence(message.getSequenceId()).getDeliveryQueue().put(message);
    }
}

