/*
 * Decompiled with CFR 0.152.
 */
package com.sun.web.server;

import com.sun.enterprise.container.common.spi.util.InjectionManager;
import com.sun.enterprise.web.WebComponentInvocation;
import com.sun.enterprise.web.WebModule;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import javax.validation.ValidatorFactory;
import org.apache.catalina.ContainerEvent;
import org.apache.catalina.ContainerListener;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.NamedNamingObjectProxy;
import org.glassfish.web.LogFacade;

public final class WebContainerListener
implements ContainerListener {
    private static final Logger _logger = LogFacade.getLogger();
    private static final ResourceBundle rb = _logger.getResourceBundle();
    private static HashSet<String> beforeEvents = new HashSet();
    private static HashSet<String> afterEvents = new HashSet();
    private InvocationManager invocationMgr;
    private InjectionManager injectionMgr;
    private NamedNamingObjectProxy validationNamingProxy;

    public WebContainerListener(InvocationManager invocationMgr, InjectionManager injectionMgr, NamedNamingObjectProxy validationNamingProxy) {
        this.invocationMgr = invocationMgr;
        this.injectionMgr = injectionMgr;
        this.validationNamingProxy = validationNamingProxy;
    }

    public void containerEvent(ContainerEvent event) {
        block12: {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "AS-WEB-GLUE-00270", event.getType() + "," + event.getContainer() + "," + event.getData());
            }
            String type = event.getType();
            try {
                WebModule wm = (WebModule)event.getContainer();
                if (beforeEvents.contains(type)) {
                    this.preInvoke(wm);
                    if (!type.equals("beforeContextDestroyed")) break block12;
                    try {
                        Object validatorFactory;
                        if (this.validationNamingProxy != null && (validatorFactory = this.validationNamingProxy.handle("java:comp/ValidatorFactory")) != null) {
                            ((ValidatorFactory)validatorFactory).close();
                        }
                        break block12;
                    }
                    catch (NamingException exc) {
                        if (_logger.isLoggable(Level.WARNING)) {
                            _logger.log(Level.FINEST, "AS-WEB-GLUE-00285", exc);
                        }
                        break block12;
                    }
                }
                if (afterEvents.contains(type)) {
                    if (type.equals("afterFilterDestroyed") || type.equals("afterContextDestroyed")) {
                        this.preDestroy(event);
                    }
                    this.postInvoke(wm);
                } else if ("predestroy".equals(type)) {
                    this.preInvoke(wm);
                    this.preDestroy(event);
                    this.postInvoke(wm);
                }
            }
            catch (Throwable t) {
                String msg = rb.getString("AS-WEB-GLUE-00268");
                msg = MessageFormat.format(msg, type, event.getContainer());
                _logger.log(Level.SEVERE, msg, t);
            }
        }
    }

    private void preInvoke(WebModule ctx) {
        WebModule wm = ctx;
        WebComponentInvocation inv = new WebComponentInvocation(wm);
        this.invocationMgr.preInvoke((ComponentInvocation)inv);
    }

    private void postInvoke(WebModule ctx) {
        WebModule wm = ctx;
        WebComponentInvocation inv = new WebComponentInvocation(wm);
        this.invocationMgr.postInvoke((ComponentInvocation)inv);
    }

    private void preDestroy(ContainerEvent event) {
        try {
            this.injectionMgr.destroyManagedObject(event.getData(), false);
        }
        catch (Throwable t) {
            String msg = rb.getString("AS-WEB-GLUE-00271");
            msg = MessageFormat.format(msg, event.getData(), event.getContainer());
            _logger.log(Level.SEVERE, msg, t);
        }
    }

    static {
        beforeEvents.add("beforeContextInitializerOnStartup");
        beforeEvents.add("beforeContextInitialized");
        beforeEvents.add("beforeContextDestroyed");
        beforeEvents.add("beforeContextAttributeAdded");
        beforeEvents.add("beforeContextAttributeRemoved");
        beforeEvents.add("beforeContextAttributeReplaced");
        beforeEvents.add("beforeRequestInitialized");
        beforeEvents.add("beforeRequestDestroyed");
        beforeEvents.add("beforeSessionCreated");
        beforeEvents.add("beforeSessionDestroyed");
        beforeEvents.add("beforeSessionIdChanged");
        beforeEvents.add("beforeSessionAttributeAdded");
        beforeEvents.add("beforeSessionAttributeRemoved");
        beforeEvents.add("beforeSessionAttributeReplaced");
        beforeEvents.add("beforeSessionValueUnbound");
        beforeEvents.add("beforeFilterInitialized");
        beforeEvents.add("beforeFilterDestroyed");
        beforeEvents.add("beforeUpgradeHandlerInitialized");
        beforeEvents.add("beforeUpgradeHandlerDestroyed");
        beforeEvents.add("beforeReadListenerOnDataAvailable");
        beforeEvents.add("beforeReadListenerOnAllDataRead");
        beforeEvents.add("beforeReadListenerOnError");
        beforeEvents.add("beforeWriteListenerOnWritePossible");
        beforeEvents.add("beforeWriteListenerOnError");
        beforeEvents.add("beforeAuthentication");
        beforeEvents.add("beforePostAuthentication");
        beforeEvents.add("beforePostAuthentication");
        afterEvents.add("afterContextInitializerOnStartup");
        afterEvents.add("afterContextInitialized");
        afterEvents.add("afterContextDestroyed");
        afterEvents.add("afterContextAttributeAdded");
        afterEvents.add("afterContextAttributeRemoved");
        afterEvents.add("afterContextAttributeReplaced");
        afterEvents.add("afterRequestInitialized");
        afterEvents.add("afterRequestDestroyed");
        afterEvents.add("afterSessionCreated");
        afterEvents.add("afterSessionDestroyed");
        afterEvents.add("afterSessionIdChanged");
        afterEvents.add("afterSessionAttributeAdded");
        afterEvents.add("afterSessionAttributeRemoved");
        afterEvents.add("afterSessionAttributeReplaced");
        afterEvents.add("afterSessionValueUnbound");
        afterEvents.add("afterFilterInitialized");
        afterEvents.add("afterFilterDestroyed");
        afterEvents.add("afterUpgradeHandlerInitialized");
        afterEvents.add("afterUpgradeHandlerDestroyed");
        afterEvents.add("afterReadListenerOnDataAvailable");
        afterEvents.add("afterReadListenerOnAllDataRead");
        afterEvents.add("afterReadListenerOnError");
        afterEvents.add("afterWriteListenerOnWritePossible");
        afterEvents.add("afterWriteListenerOnError");
        afterEvents.add("afterAuthentication");
        afterEvents.add("afterPostAuthentication");
        afterEvents.add("afterPostAuthentication");
    }
}

