/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.v3.admin.adapter;

import com.sun.appserv.server.util.Version;
import com.sun.enterprise.config.serverbeans.AdminService;
import com.sun.enterprise.config.serverbeans.Application;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.SecureAdmin;
import com.sun.enterprise.v3.admin.AdminConsoleConfigUpgrade;
import com.sun.enterprise.v3.admin.adapter.AdapterState;
import com.sun.enterprise.v3.admin.adapter.AdminEndpointDecider;
import com.sun.enterprise.v3.admin.adapter.InstallerThread;
import com.sun.enterprise.v3.admin.adapter.Utils;
import java.beans.PropertyVetoException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.inject.Named;
import org.glassfish.api.container.Adapter;
import org.glassfish.api.event.EventListener;
import org.glassfish.api.event.Events;
import org.glassfish.api.event.RestrictTo;
import org.glassfish.grizzly.config.dom.NetworkListener;
import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.io.OutputBuffer;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.kernel.KernelLoggerInfo;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;
import org.jvnet.hk2.config.types.Property;

@Service
public final class AdminConsoleAdapter
extends HttpHandler
implements Adapter,
PostConstruct,
EventListener {
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    @Named(value="default-instance-name")
    AdminService adminService;
    private String contextRoot;
    private File warFile;
    private AdapterState stateMsg = AdapterState.UNINITIAZED;
    private boolean installing = false;
    private boolean isOK = false;
    private AdminConsoleConfigUpgrade adminConsoleConfigUpgrade = null;
    private final CountDownLatch latch = new CountDownLatch(1);
    @Inject
    ApplicationRegistry appRegistry;
    @Inject
    Domain domain;
    @Inject
    ServiceLocator habitat;
    @Inject
    Events events;
    @Inject
    @Named(value="default-instance-name")
    Config serverConfig;
    AdminEndpointDecider epd;
    private static final Logger logger = KernelLoggerInfo.getLogger();
    private String statusHtml;
    private String initHtml;
    private boolean isRegistered = false;
    private ResourceBundle bundle;
    private static final String MYURL_TOKEN = "%%%MYURL%%%";
    private static final String STATUS_TOKEN = "%%%STATUS%%%";
    private static final String REDIRECT_TOKEN = "%%%LOCATION%%%";
    private static final String RESOURCE_PACKAGE = "com/sun/enterprise/v3/admin/adapter";
    private static final String INSTALL_ROOT = "com.sun.aas.installRoot";
    static final String ADMIN_APP_NAME = "__admingui";
    private boolean isRestStarted = false;
    private boolean isRestBeingStarted = false;
    private Method[] allowedHttpMethods = new Method[]{Method.GET, Method.POST, Method.HEAD, Method.DELETE, Method.PUT};

    public AdminConsoleAdapter() throws IOException {
        this.initHtml = Utils.packageResource2String("downloadgui.html");
        this.statusHtml = Utils.packageResource2String("status.html");
    }

    public String getContextRoot() {
        return this.epd.getGuiContextRoot();
    }

    public final HttpHandler getHttpService() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Request req, Response res) {
        this.bundle = this.getResourceBundle(req.getLocale());
        Method method = req.getMethod();
        if (!this.checkHttpMethodAllowed(method)) {
            res.setStatus(405, method.getMethodString() + " " + this.bundle.getString("http.bad.method"));
            res.setHeader("Allow", this.getAllowedHttpMethodsAsString());
            return;
        }
        if (!this.env.isDas()) {
            this.sendStatusNotDAS(req, res);
            return;
        }
        if (this.adminConsoleConfigUpgrade == null) {
            this.adminConsoleConfigUpgrade = (AdminConsoleConfigUpgrade)this.habitat.getService(AdminConsoleConfigUpgrade.class, new Annotation[0]);
        }
        try {
            if (!this.latch.await(100L, TimeUnit.SECONDS)) {
                logger.log(Level.SEVERE, "NCLS-CORE-00007");
                return;
            }
        }
        catch (InterruptedException ex) {
            logger.log(Level.SEVERE, "NCLS-CORE-00008");
            return;
        }
        this.logRequest(req);
        if (this.isResourceRequest(req)) {
            block28: {
                try {
                    this.handleResourceRequest(req, res);
                }
                catch (IOException ioe) {
                    if (logger.isLoggable(Level.SEVERE)) {
                        logger.log(Level.SEVERE, "NCLS-CORE-00009", new Object[]{req.getRequestURI(), ioe.toString()});
                    }
                    if (!logger.isLoggable(Level.FINE)) break block28;
                    logger.log(Level.FINE, ioe.toString(), ioe);
                }
            }
            return;
        }
        res.setContentType("text/html; charset=UTF-8");
        String serverVersion = Version.getFullVersion();
        if ("/testifbackendisready.html".equals(req.getRequestURI())) {
            String status = this.getStateMsg().getI18NKey();
            try {
                status = this.bundle.getString(status);
            }
            catch (MissingResourceException ex) {
                status = this.getStateMsg().toString();
            }
            String wkey = AdapterState.WELCOME_TO.getI18NKey();
            try {
                serverVersion = this.bundle.getString(wkey) + " " + serverVersion + ".";
            }
            catch (MissingResourceException ex) {
                serverVersion = AdapterState.WELCOME_TO.toString() + " " + serverVersion + ".";
            }
            status = status + "\n" + serverVersion;
            try {
                OutputBuffer ob = this.getOutputBuffer(res);
                byte[] bytes = (":::" + status).getBytes("UTF-8");
                res.setContentLength(bytes.length);
                ob.write(bytes, 0, bytes.length);
                ob.flush();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "NCLS-CORE-00009", ex);
            }
            return;
        }
        if (this.isApplicationLoaded()) {
            this.handleLoadedState();
        } else {
            if ("/favicon.ico".equals(req.getRequestURI())) {
                return;
            }
            if (!this.isRestStarted) {
                this.forceRestModuleLoad(req);
            }
            AdminConsoleAdapter adminConsoleAdapter = this;
            synchronized (adminConsoleAdapter) {
                if (this.isInstalling()) {
                    this.sendStatusPage(req, res);
                } else if (this.isApplicationLoaded()) {
                    this.handleLoadedState();
                } else {
                    this.loadConsole();
                    this.sendStatusPage(req, res);
                }
            }
        }
    }

    void loadConsole() {
        try {
            this.setInstalling(true);
            this.startThread();
        }
        catch (Exception ex) {
            this.setInstalling(false);
            throw new RuntimeException("Unable to install Admin Console!", ex);
        }
    }

    private boolean isResourceRequest(Request req) {
        return this.getContentType(req.getRequestURI()) != null;
    }

    private void forceRestModuleLoad(Request req) {
        if (this.isRestBeingStarted) {
            return;
        }
        this.isRestBeingStarted = true;
        Thread thread = new Thread("Force REST Module Load Thread"){

            @Override
            public void run() {
                AdminConsoleAdapter.this.initRest();
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private String getContentType(String resource) {
        if (resource == null || resource.length() == 0) {
            return null;
        }
        if (resource.endsWith(".gif")) {
            return "image/gif";
        }
        if (resource.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Unhandled content-type: {0}", resource);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleResourceRequest(Request req, Response res) throws IOException {
        String resourcePath = RESOURCE_PACKAGE + req.getRequestURI();
        ClassLoader loader = AdminConsoleAdapter.class.getClassLoader();
        try (InputStream in = null;){
            in = loader.getResourceAsStream(resourcePath);
            if (in == null) {
                logger.log(Level.WARNING, "NCLS-CORE-00010", resourcePath);
                return;
            }
            byte[] buf = new byte[512];
            ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
            int i = in.read(buf);
            while (i != -1) {
                baos.write(buf, 0, i);
                i = in.read(buf);
            }
            String contentType = this.getContentType(resourcePath);
            if (contentType != null) {
                res.setContentType(contentType);
            }
            res.setContentLength(baos.size());
            OutputStream out = res.getOutputStream();
            baos.writeTo(out);
            out.flush();
        }
    }

    boolean isApplicationLoaded() {
        return this.stateMsg == AdapterState.APPLICATION_LOADED;
    }

    boolean isInstalling() {
        return this.installing;
    }

    void setInstalling(boolean flag) {
        this.installing = flag;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void setRegistered(boolean isRegistered) {
        this.isRegistered = isRegistered;
    }

    void setStateMsg(AdapterState msg) {
        this.stateMsg = msg;
        logger.log(Level.FINE, msg.toString());
    }

    AdapterState getStateMsg() {
        return this.stateMsg;
    }

    public void postConstruct() {
        this.events.register((EventListener)this);
        this.init();
    }

    public void event(@RestrictTo(value="server_ready") EventListener.Event event) {
        this.latch.countDown();
        if (logger != null) {
            logger.log(Level.FINE, "AdminConsoleAdapter is ready.");
        }
    }

    private void init() {
        Property locProp = this.adminService.getProperty("adminConsoleDownloadLocation");
        if (locProp == null || locProp.getValue() == null || locProp.getValue().equals("")) {
            String iRoot = System.getProperty(INSTALL_ROOT) + "/lib/install/applications/admingui.war";
            this.warFile = new File(iRoot.replace('/', File.separatorChar));
            this.writeAdminServiceProp("adminConsoleDownloadLocation", "${com.sun.aas.installRoot}/lib/install/applications/admingui.war");
        } else {
            String locValue = locProp.getValue();
            this.warFile = new File(locValue);
            if (!this.warFile.isAbsolute()) {
                File tmp = new File(System.getProperty(INSTALL_ROOT), "..");
                this.warFile = new File(tmp, locValue);
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Admin Console download location: {0}", this.warFile.getAbsolutePath());
        }
        this.initState();
        try {
            this.epd = new AdminEndpointDecider(this.serverConfig);
            this.contextRoot = this.epd.getGuiContextRoot();
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "NCLS-CORE-00011", ex);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initRest() {
        InputStream is = null;
        try {
            NetworkListener nl = this.domain.getServerNamed("server").getConfig().getNetworkConfig().getNetworkListener("admin-listener");
            SecureAdmin secureAdmin = (SecureAdmin)this.habitat.getService(SecureAdmin.class, new Annotation[0]);
            URL url = new URL(SecureAdmin.Util.isEnabled((SecureAdmin)secureAdmin) ? "https" : "http", nl.getAddress(), Integer.parseInt(nl.getPort()), "/management/domain");
            URLConnection conn = url.openConnection();
            is = conn.getInputStream();
            this.isRestStarted = true;
        }
        catch (Exception ex) {
            logger.log(Level.FINE, null, ex);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ex1) {
                    logger.log(Level.FINE, null, ex1);
                }
            }
        }
    }

    private void initState() {
        if (this.appExistsInConfig()) {
            this.isOK = true;
            this.setStateMsg(AdapterState.APPLICATION_INSTALLED_BUT_NOT_LOADED);
        } else if (new File(this.warFile.getParentFile(), ADMIN_APP_NAME).exists() || this.warFile.exists()) {
            if (logger.isLoggable(Level.FINE)) {
                this.setStateMsg(AdapterState.DOWNLOADED);
            }
            this.isOK = true;
        } else {
            this.setStateMsg(AdapterState.APPLICATION_NOT_INSTALLED);
        }
    }

    private boolean appExistsInConfig() {
        return this.getConfig() != null;
    }

    Application getConfig() {
        Application app = this.domain.getSystemApplicationReferencedFrom(this.env.getInstanceName(), ADMIN_APP_NAME);
        return app;
    }

    private void logRequest(Request req) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "AdminConsoleAdapter''s STATE IS: {0}", (Object)this.getStateMsg());
            logger.log(Level.FINE, "Current Thread: {0}", Thread.currentThread().getName());
            for (String name : req.getParameterNames()) {
                String values = Arrays.toString(req.getParameterValues(name));
                logger.log(Level.FINE, "Parameter name: {0} values: {1}", new Object[]{name, values});
            }
        }
    }

    private boolean hasPermission(InteractionResult ir) {
        if (ir == InteractionResult.OK) {
            this.isOK = true;
        }
        return this.isOK;
    }

    private void startThread() {
        new InstallerThread(this, this.habitat, this.domain, this.env, this.contextRoot, this.epd.getGuiHosts()).start();
    }

    private OutputBuffer getOutputBuffer(Response res) {
        res.setStatus(202);
        res.setContentType("text/html");
        res.setCharacterEncoding("UTF-8");
        return res.getOutputBuffer();
    }

    private void sendStatusPage(Request req, Response res) {
        try {
            OutputBuffer ob = this.getOutputBuffer(res);
            String localHtml = this.replaceTokens(this.statusHtml, this.bundle);
            String status = this.getStateMsg().getI18NKey();
            try {
                status = this.bundle.getString(status);
            }
            catch (MissingResourceException ex) {
                status = this.getStateMsg().toString();
            }
            String locationUrl = req.getScheme() + "://" + req.getServerName() + ':' + req.getServerPort() + "/login.jsf";
            localHtml = localHtml.replace(REDIRECT_TOKEN, locationUrl);
            byte[] bytes = localHtml.replace(STATUS_TOKEN, status).getBytes("UTF-8");
            res.setContentLength(bytes.length);
            ob.write(bytes, 0, bytes.length);
            ob.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private void sendStatusNotDAS(Request req, Response res) {
        try {
            String html = Utils.packageResource2String("statusNotDAS.html");
            OutputBuffer ob = this.getOutputBuffer(res);
            String localHtml = this.replaceTokens(html, this.bundle);
            byte[] bytes = localHtml.getBytes("UTF-8");
            res.setContentLength(bytes.length);
            ob.write(bytes, 0, bytes.length);
            ob.flush();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        return ResourceBundle.getBundle("com.sun.enterprise.v3.admin.adapter.LocalStrings", locale);
    }

    private String replaceTokens(String text, ResourceBundle bundle) {
        int start = 0;
        int end = 0;
        Object newString = null;
        StringBuilder buf = new StringBuilder("");
        while (start != -1) {
            start = text.indexOf("%%%", end);
            if (start == -1) continue;
            buf.append(text.substring(end, start));
            end = text.indexOf("%%%", start += 3);
            if (end != -1) {
                try {
                    buf.append(bundle.getString(text.substring(start, end)));
                }
                catch (MissingResourceException ex) {
                    buf.append("%%%").append(text.substring(start, end)).append("%%%");
                }
                end += 3;
                continue;
            }
            buf.append("%%%");
            end = start;
        }
        buf.append(text.substring(end));
        return buf.toString();
    }

    public AdminService getAdminService() {
        return this.adminService;
    }

    private void writeAdminServiceProp(final String propName, final String propValue) {
        try {
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<AdminService>(){

                public Object run(AdminService adminService) throws PropertyVetoException, TransactionFailure {
                    Property newProp = (Property)adminService.createChild(Property.class);
                    adminService.getProperty().add(newProp);
                    newProp.setName(propName);
                    newProp.setValue(propValue);
                    return newProp;
                }
            }, (ConfigBeanProxy)this.adminService);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "NCLS-CORE-00012", new Object[]{propName, propValue, ex});
        }
    }

    private void handleLoadedState() {
        this.statusHtml = null;
        this.initHtml = null;
    }

    public int getListenPort() {
        return this.epd.getListenPort();
    }

    public InetAddress getListenAddress() {
        return this.epd.getListenAddress();
    }

    public List<String> getVirtualServers() {
        return this.epd.getGuiHosts();
    }

    private boolean checkHttpMethodAllowed(Method method) {
        for (Method hh : this.allowedHttpMethods) {
            if (!hh.equals(method)) continue;
            return true;
        }
        return false;
    }

    private String getAllowedHttpMethodsAsString() {
        StringBuilder sb = new StringBuilder(this.allowedHttpMethods[0].getMethodString());
        for (int i = 1; i < this.allowedHttpMethods.length; ++i) {
            sb.append(", ").append(this.allowedHttpMethods[i].getMethodString());
        }
        return sb.toString();
    }

    static enum InteractionResult {
        OK,
        CANCEL,
        FIRST_TIMER;

    }
}

