/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.oxm.record.json;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.xml.namespace.QName;
import org.eclipse.persistence.exceptions.XMLMarshalException;
import org.eclipse.persistence.internal.oxm.CollectionGroupingElementNodeValue;
import org.eclipse.persistence.internal.oxm.Constants;
import org.eclipse.persistence.internal.oxm.ContainerValue;
import org.eclipse.persistence.internal.oxm.ConversionManager;
import org.eclipse.persistence.internal.oxm.MediaType;
import org.eclipse.persistence.internal.oxm.NamespaceResolver;
import org.eclipse.persistence.internal.oxm.NodeValue;
import org.eclipse.persistence.internal.oxm.Root;
import org.eclipse.persistence.internal.oxm.Unmarshaller;
import org.eclipse.persistence.internal.oxm.XPathFragment;
import org.eclipse.persistence.internal.oxm.XPathNode;
import org.eclipse.persistence.internal.oxm.mappings.Field;
import org.eclipse.persistence.internal.oxm.record.AbstractUnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.SAXUnmarshallerHandler;
import org.eclipse.persistence.internal.oxm.record.UnmarshalRecord;
import org.eclipse.persistence.internal.oxm.record.XMLReader;
import org.eclipse.persistence.internal.oxm.record.XMLReaderAdapter;
import org.eclipse.persistence.internal.oxm.record.deferred.DeferredContentHandler;
import org.eclipse.persistence.oxm.mappings.nullpolicy.AbstractNullPolicy;
import org.eclipse.persistence.oxm.record.XMLRootRecord;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class JsonStructureReader
extends XMLReaderAdapter {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    private String attributePrefix = null;
    private NamespaceResolver namespaces = null;
    private boolean includeRoot;
    private String textWrapper;
    private Class unmarshalClass;
    private boolean isInCollection;
    private JsonStructure jsonStructure;
    private JsonAttributes attributes = new JsonAttributes();
    private boolean jsonTypeCompatibility;

    public JsonStructureReader(Unmarshaller u) {
        this(u, null);
    }

    public JsonStructureReader(Unmarshaller u, Class clazz) {
        this.attributePrefix = u.getAttributePrefix();
        if ("".equals(this.attributePrefix)) {
            this.attributePrefix = null;
        }
        this.namespaces = u.getNamespaceResolver();
        this.setNamespaceAware(u.getNamespaceResolver() != null);
        this.setNamespaceSeparator(u.getNamespaceSeparator());
        this.includeRoot = u.isIncludeRoot();
        this.setErrorHandler(u.getErrorHandler());
        this.textWrapper = u.getValueWrapper();
        this.unmarshalClass = clazz;
        this.jsonTypeCompatibility = u.getJsonTypeConfiguration().useJsonTypeCompatibility();
    }

    public void setJsonStructure(JsonStructure jsonStructure) {
        this.jsonStructure = jsonStructure;
    }

    @Override
    public void parse(InputSource input) throws IOException, SAXException, JsonException {
        if (input == null) {
            if (this.jsonStructure != null) {
                this.parseRoot((JsonValue)this.jsonStructure);
            }
            return;
        }
        try {
            JsonReader jsonReader;
            InputStream inputStream = null;
            if (input.getByteStream() != null) {
                inputStream = input.getByteStream();
                jsonReader = Json.createReader((InputStream)inputStream);
            } else if (input.getCharacterStream() != null) {
                jsonReader = Json.createReader((Reader)input.getCharacterStream());
            } else {
                try {
                    URL url = new URL(input.getSystemId());
                    inputStream = url.openStream();
                }
                catch (MalformedURLException malformedURLException) {
                    try {
                        inputStream = new FileInputStream(input.getSystemId());
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                        throw malformedURLException;
                    }
                }
                jsonReader = Json.createReader((InputStream)inputStream);
            }
            if (jsonReader != null) {
                JsonStructure structure = jsonReader.read();
                this.parseRoot((JsonValue)structure);
            }
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (JsonException je) {
            throw XMLMarshalException.unmarshalException((Exception)((Object)je));
        }
    }

    @Override
    public void parse(String systemId) {
        try {
            this.parse(new InputSource(systemId));
        }
        catch (IOException | SAXException e) {
            throw XMLMarshalException.unmarshalException(e);
        }
    }

    public void parseRoot(JsonValue jsonValue) throws SAXException {
        if (this.namespaces != null) {
            Map<String, String> namespacePairs = this.namespaces.getPrefixesToNamespaces();
            for (Map.Entry<String, String> namespacePair : namespacePairs.entrySet()) {
                this.contentHandler.startPrefixMapping(namespacePair.getKey(), namespacePair.getValue());
            }
        }
        if (jsonValue.getValueType() == JsonValue.ValueType.OBJECT) {
            this.contentHandler.startDocument();
            JsonObject jsonObject = (JsonObject)jsonValue;
            Set children = jsonObject.entrySet();
            if (children.size() == 0 && this.unmarshalClass == null) {
                return;
            }
            Iterator iter = children.iterator();
            if (this.includeRoot) {
                if (children.size() > 0) {
                    Map.Entry nextEntry = (Map.Entry)iter.next();
                    this.parsePair((String)nextEntry.getKey(), (JsonValue)nextEntry.getValue());
                }
            } else {
                this.contentHandler.startElement("", "", null, this.attributes.setValue(jsonValue, this.attributePrefix, this.namespaces, this.getNamespaceSeparator(), this.isNamespaceAware()));
                while (iter.hasNext()) {
                    Map.Entry nextEntry = (Map.Entry)iter.next();
                    this.parsePair((String)nextEntry.getKey(), (JsonValue)nextEntry.getValue());
                }
                this.contentHandler.endElement("", "", null);
            }
            this.contentHandler.endDocument();
        } else if (jsonValue.getValueType() == JsonValue.ValueType.ARRAY) {
            SAXUnmarshallerHandler rootContentHandler = null;
            if (this.getContentHandler() instanceof SAXUnmarshallerHandler) {
                rootContentHandler = (SAXUnmarshallerHandler)this.getContentHandler();
            }
            JsonArray jsonArray = (JsonArray)jsonValue;
            ArrayList<Object> list = new ArrayList<Object>(jsonArray.size());
            for (JsonValue aJsonArray : jsonArray) {
                this.parseRoot(aJsonArray);
                if (this.getContentHandler() instanceof SAXUnmarshallerHandler) {
                    SAXUnmarshallerHandler saxUnmarshallerHandler = (SAXUnmarshallerHandler)this.contentHandler;
                    list.add(saxUnmarshallerHandler.getObject());
                    saxUnmarshallerHandler.setObject(null);
                    continue;
                }
                if (!(this.getContentHandler() instanceof UnmarshalRecord)) continue;
                UnmarshalRecord unmarshalRecord = (UnmarshalRecord)this.contentHandler;
                Object unmarshalledObject = unmarshalRecord.getCurrentObject();
                if (this.includeRoot && this.unmarshalClass != null && !(unmarshalledObject instanceof Root)) {
                    Root xmlRoot = unmarshalRecord.createRoot();
                    xmlRoot.setNamespaceURI(unmarshalRecord.getRootElementNamespaceUri());
                    xmlRoot.setLocalName(unmarshalRecord.getLocalName());
                    xmlRoot.setObject(unmarshalledObject);
                    unmarshalledObject = xmlRoot;
                }
                list.add(unmarshalledObject);
                unmarshalRecord.setCurrentObject(null);
                unmarshalRecord.setRootElementName(null);
                unmarshalRecord.setLocalName(null);
            }
            if (this.getContentHandler() instanceof SAXUnmarshallerHandler) {
                ((SAXUnmarshallerHandler)this.getContentHandler()).setObject(list);
            } else if (this.getContentHandler() instanceof UnmarshalRecord) {
                ((UnmarshalRecord)this.getContentHandler()).setCurrentObject(list);
                ((UnmarshalRecord)this.getContentHandler()).setRootElementName("");
                ((UnmarshalRecord)this.getContentHandler()).setLocalName("");
                if (rootContentHandler != null) {
                    rootContentHandler.setObject(list);
                }
            }
        } else {
            this.getContentHandler().startDocument();
            this.parseValue(jsonValue);
        }
    }

    private void parseValue(JsonValue jsonValue) throws SAXException {
        switch (jsonValue.getValueType()) {
            case STRING: {
                String string = ((JsonString)jsonValue).getString();
                this.contentHandler.characters(string);
                break;
            }
            case FALSE: {
                this.contentHandler.characters(FALSE);
                break;
            }
            case TRUE: {
                this.contentHandler.characters(TRUE);
                break;
            }
            case NUMBER: {
                JsonNumber number = (JsonNumber)jsonValue;
                this.contentHandler.characters(number.toString());
                break;
            }
            case OBJECT: {
                for (Map.Entry nextEntry : ((JsonObject)jsonValue).entrySet()) {
                    this.parsePair((String)nextEntry.getKey(), (JsonValue)nextEntry.getValue());
                }
                break;
            }
            case ARRAY: {
                for (JsonValue value : (JsonArray)jsonValue) {
                    this.parseValue(value);
                }
                break;
            }
            case NULL: {
                this.contentHandler.setNil(true);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled valueType: " + jsonValue.getValueType());
            }
        }
    }

    private void parsePair(String name, JsonValue jsonValue) throws SAXException {
        if (jsonValue == null) {
            return;
        }
        JsonValue.ValueType valueType = jsonValue.getValueType();
        if (valueType == JsonValue.ValueType.ARRAY) {
            UnmarshalRecord ur;
            XPathNode node;
            int arraySize;
            JsonArray jsonArray = (JsonArray)jsonValue;
            String parentLocalName = name;
            if (this.attributePrefix != null && parentLocalName.startsWith(this.attributePrefix)) {
                return;
            }
            String uri = "";
            if (this.isNamespaceAware() && this.namespaces != null) {
                if (parentLocalName.length() > 2) {
                    int nsIndex = parentLocalName.indexOf(this.getNamespaceSeparator(), 1);
                    if (nsIndex > -1) {
                        String prefix = parentLocalName.substring(0, nsIndex);
                        uri = this.namespaces.resolveNamespacePrefix(prefix);
                    }
                    if (uri == null || uri == "") {
                        uri = this.namespaces.getDefaultNamespaceURI();
                    } else {
                        parentLocalName = parentLocalName.substring(nsIndex + 1);
                    }
                } else {
                    uri = this.namespaces.getDefaultNamespaceURI();
                }
            }
            if ((arraySize = jsonArray.size()) == 0 && (this.contentHandler instanceof UnmarshalRecord || this.isUnmarshalRecordWithinAdapter()) && (node = (ur = this.contentHandler instanceof UnmarshalRecord ? (UnmarshalRecord)this.contentHandler : this.getUnmarshalRecordFromAdapter()).getNonAttributeXPathNode(uri, parentLocalName, parentLocalName, null)) != null) {
                NodeValue nv = node.getNodeValue();
                if (nv == null && node.getTextNode() != null) {
                    nv = node.getTextNode().getUnmarshalNodeValue();
                }
                if (nv != null && nv.isContainerValue()) {
                    ur.getContainerInstance((ContainerValue)((Object)nv));
                }
            }
            this.startCollection();
            XPathFragment groupingXPathFragment = null;
            XPathFragment itemXPathFragment = null;
            if (this.contentHandler instanceof UnmarshalRecord || this.isUnmarshalRecordWithinAdapter()) {
                XPathNode unmarshalRecordXPathNode;
                UnmarshalRecord contentHandler_ = this.contentHandler instanceof UnmarshalRecord ? (UnmarshalRecord)this.contentHandler : this.getUnmarshalRecordFromAdapter();
                boolean isTextValue = this.isTextValue(parentLocalName, contentHandler_);
                UnmarshalRecord unmarshalRecord = contentHandler_;
                if (((Unmarshaller)unmarshalRecord.getUnmarshaller()).isWrapperAsCollectionName() && (unmarshalRecordXPathNode = unmarshalRecord.getXPathNode()) != null) {
                    XPathFragment currentFragment = new XPathFragment();
                    currentFragment.setLocalName(parentLocalName);
                    currentFragment.setNamespaceURI(uri);
                    currentFragment.setNamespaceAware(this.isNamespaceAware());
                    XPathNode groupingXPathNode = unmarshalRecordXPathNode.getNonAttributeChildrenMap().get(currentFragment);
                    if (groupingXPathNode != null) {
                        XPathNode itemXPathNode;
                        if (groupingXPathNode.getUnmarshalNodeValue() instanceof CollectionGroupingElementNodeValue) {
                            groupingXPathFragment = groupingXPathNode.getXPathFragment();
                            contentHandler_.startElement(uri, parentLocalName, parentLocalName, new AttributesImpl());
                            itemXPathNode = groupingXPathNode.getNonAttributeChildren().get(0);
                            itemXPathFragment = itemXPathNode.getXPathFragment();
                        } else if (groupingXPathNode.getUnmarshalNodeValue() == null && (itemXPathNode = groupingXPathNode.getNonAttributeChildren().get(0)) != null && itemXPathNode.getUnmarshalNodeValue().isContainerValue()) {
                            groupingXPathFragment = groupingXPathNode.getXPathFragment();
                            contentHandler_.startElement(uri, parentLocalName, parentLocalName, new AttributesImpl());
                            itemXPathFragment = itemXPathNode.getXPathFragment();
                        }
                    }
                }
                for (JsonValue nextArrayValue : jsonArray) {
                    if (nextArrayValue.getValueType() == JsonValue.ValueType.NULL) {
                        this.contentHandler.setNil(true);
                    }
                    if (!isTextValue) {
                        if (itemXPathFragment != null) {
                            this.contentHandler.startElement(itemXPathFragment.getNamespaceURI(), itemXPathFragment.getLocalName(), itemXPathFragment.getLocalName(), this.attributes.setValue(nextArrayValue, this.attributePrefix, this.namespaces, this.getNamespaceSeparator(), this.isNamespaceAware()));
                        } else {
                            this.contentHandler.startElement(uri, parentLocalName, parentLocalName, this.attributes.setValue(nextArrayValue, this.attributePrefix, this.namespaces, this.getNamespaceSeparator(), this.isNamespaceAware()));
                        }
                    }
                    this.parseValue(nextArrayValue);
                    if (isTextValue) continue;
                    if (itemXPathFragment != null) {
                        this.contentHandler.endElement(itemXPathFragment.getNamespaceURI(), itemXPathFragment.getLocalName(), itemXPathFragment.getLocalName());
                        continue;
                    }
                    this.contentHandler.endElement(uri, parentLocalName, parentLocalName);
                }
            }
            if (groupingXPathFragment != null) {
                this.contentHandler.endElement(uri, groupingXPathFragment.getLocalName(), groupingXPathFragment.getLocalName());
            }
            this.endCollection();
        } else {
            if (this.attributePrefix != null && name.startsWith(this.attributePrefix)) {
                return;
            }
            String localName = name;
            String uri = "";
            if (this.isNamespaceAware() && this.namespaces != null) {
                if (localName.length() > 2) {
                    int nsIndex = localName.indexOf(this.getNamespaceSeparator(), 1);
                    String prefix = "";
                    if (nsIndex > -1) {
                        prefix = localName.substring(0, nsIndex);
                    }
                    if ((uri = this.namespaces.resolveNamespacePrefix(prefix)) == null || uri == "") {
                        uri = this.namespaces.getDefaultNamespaceURI();
                    } else {
                        localName = localName.substring(nsIndex + 1);
                    }
                    if (localName.equals("type") && uri != null && uri.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                        return;
                    }
                } else {
                    uri = this.namespaces.getDefaultNamespaceURI();
                }
            }
            if (this.contentHandler instanceof XMLRootRecord || this.contentHandler instanceof DeferredContentHandler) {
                if (this.jsonTypeCompatibility && !this.isNamespaceAware() && localName.equals("type")) {
                    return;
                }
                if (this.textWrapper != null && this.textWrapper.equals(localName)) {
                    this.parseValue(jsonValue);
                    return;
                }
            } else if (this.contentHandler instanceof UnmarshalRecord && ((UnmarshalRecord)this.contentHandler).getXPathNode() != null) {
                if (this.jsonTypeCompatibility && !this.isNamespaceAware() && localName.equals("type") && !((UnmarshalRecord)this.contentHandler).getXPathNode().hasTypeChild()) {
                    return;
                }
                boolean isTextValue = this.isTextValue(localName, (UnmarshalRecord)this.contentHandler);
                if (isTextValue) {
                    this.parseValue(jsonValue);
                    return;
                }
                NodeValue nv = ((UnmarshalRecord)this.contentHandler).getAttributeChildNodeValue(uri, localName);
                if (this.attributePrefix == null && nv != null) {
                    return;
                }
            } else if (this.isUnmarshalRecordWithinAdapter()) {
                UnmarshalRecord contentHandler_ = this.getUnmarshalRecordFromAdapter();
                if (this.jsonTypeCompatibility && !this.isNamespaceAware() && localName.equals("type") && !contentHandler_.getXPathNode().hasTypeChild()) {
                    return;
                }
                boolean isTextValue = this.isTextValue(localName, contentHandler_);
                if (isTextValue) {
                    this.parseValue(jsonValue);
                    return;
                }
                NodeValue nv = contentHandler_.getAttributeChildNodeValue(uri, localName);
                if (this.attributePrefix == null && nv != null) {
                    return;
                }
            }
            if (jsonValue.getValueType() == JsonValue.ValueType.NULL) {
                this.contentHandler.setNil(true);
            }
            this.contentHandler.startElement(uri, localName, localName, this.attributes.setValue(jsonValue, this.attributePrefix, this.namespaces, this.getNamespaceSeparator(), this.isNamespaceAware()));
            this.parseValue(jsonValue);
            this.contentHandler.endElement(uri, localName, localName);
        }
    }

    private UnmarshalRecord getUnmarshalRecordFromAdapter() {
        return (UnmarshalRecord)((XMLReader.ValidatingContentHandler)((XMLReaderAdapter.ExtendedContentHandlerAdapter)this.contentHandler).getContentHandler()).getContentHandler();
    }

    private boolean isUnmarshalRecordWithinAdapter() {
        return this.contentHandler instanceof XMLReaderAdapter.ExtendedContentHandlerAdapter && ((XMLReaderAdapter.ExtendedContentHandlerAdapter)this.contentHandler).getContentHandler() instanceof XMLReader.ValidatingContentHandler && ((XMLReader.ValidatingContentHandler)((XMLReaderAdapter.ExtendedContentHandlerAdapter)this.contentHandler).getContentHandler()).getContentHandler() instanceof UnmarshalRecord;
    }

    @Override
    public boolean isNullRepresentedByXsiNil(AbstractNullPolicy nullPolicy) {
        return true;
    }

    private void startCollection() {
        this.isInCollection = true;
    }

    private void endCollection() {
        this.isInCollection = false;
    }

    @Override
    public boolean isInCollection() {
        return this.isInCollection;
    }

    private boolean isTextValue(String localName, UnmarshalRecord contentHandler_) {
        XPathNode currentNode = contentHandler_.getXPathNode();
        if (currentNode == null) {
            return this.textWrapper != null && this.textWrapper.equals(localName);
        }
        return (currentNode.getNonAttributeChildrenMap() == null || currentNode.getNonAttributeChildrenMap().size() == 0 || currentNode.getNonAttributeChildrenMap().size() == 1 && currentNode.getTextNode() != null) && this.textWrapper != null && this.textWrapper.equals(localName);
    }

    @Override
    public Object convertValueBasedOnSchemaType(Field xmlField, Object value, ConversionManager conversionManager, AbstractUnmarshalRecord record) {
        if (xmlField.getSchemaType() != null) {
            if (Constants.QNAME_QNAME.equals(xmlField.getSchemaType())) {
                String localName;
                String uri;
                String stringValue = (String)value;
                int indexOpen = stringValue.indexOf(123);
                int indexClose = stringValue.indexOf(125);
                if (indexOpen > -1 && indexClose > -1) {
                    uri = stringValue.substring(indexOpen + 1, indexClose);
                    localName = stringValue.substring(indexClose + 1);
                } else {
                    QName obj = (QName)xmlField.convertValueBasedOnSchemaType(stringValue, conversionManager, record);
                    localName = obj.getLocalPart();
                    uri = obj.getNamespaceURI();
                }
                if (uri != null) {
                    return new QName(uri, localName);
                }
                return new QName(localName);
            }
            Class fieldType = xmlField.getType();
            if (fieldType == null) {
                fieldType = xmlField.getJavaClass(xmlField.getSchemaType(), conversionManager);
            }
            return conversionManager.convertObject(value, fieldType, xmlField.getSchemaType());
        }
        return value;
    }

    @Override
    public MediaType getMediaType() {
        return Constants.APPLICATION_JSON;
    }

    private static class JsonAttributes
    extends XMLReaderAdapter.IndexedAttributeList {
        private JsonValue value;
        private String attributePrefix;
        private char namespaceSeparator;
        private NamespaceResolver namespaces;
        private boolean namespaceAware;

        private JsonAttributes() {
        }

        public JsonAttributes setValue(JsonValue value, String attributePrefix, NamespaceResolver nr, char namespaceSeparator, boolean namespaceAware) {
            this.reset();
            this.value = value;
            this.attributePrefix = attributePrefix;
            this.namespaces = nr;
            this.namespaceSeparator = namespaceSeparator;
            this.namespaceAware = namespaceAware;
            return this;
        }

        private void addSimpleAttribute(List<XMLReaderAdapter.Attribute> attributes, String uri, String attributeLocalName, JsonValue childValue) {
            switch (childValue.getValueType()) {
                case STRING: {
                    String stringValue = ((JsonString)childValue).getString();
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, stringValue));
                    break;
                }
                case NUMBER: {
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, childValue.toString()));
                    break;
                }
                case FALSE: {
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, JsonStructureReader.FALSE));
                    break;
                }
                case TRUE: {
                    attributes.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, JsonStructureReader.TRUE));
                    break;
                }
                case ARRAY: 
                case OBJECT: 
                case NULL: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unhandled valueType: " + childValue.getValueType());
                }
            }
        }

        @Override
        public int getIndex(String uri, String localName) {
            if (localName == null) {
                return -1;
            }
            int index = 0;
            XMLReaderAdapter.Attribute[] attributeArray = this.attributes();
            int n = attributeArray.length;
            int n2 = 0;
            while (n2 < n) {
                XMLReaderAdapter.Attribute attribute = attributeArray[n2];
                if (this.namespaceAware ? localName.equals(attribute.getLocalName()) && uri.equals(attribute.getUri()) : attribute.getName().equals(localName)) {
                    return index;
                }
                ++index;
                ++n2;
            }
            return -1;
        }

        @Override
        protected XMLReaderAdapter.Attribute[] attributes() {
            if (this.attributes == null) {
                switch (this.value.getValueType()) {
                    case NULL: {
                        return NO_ATTRIBUTES;
                    }
                    case OBJECT: {
                        JsonObject jsonObject = (JsonObject)this.value;
                        ArrayList<XMLReaderAdapter.Attribute> attributesList = new ArrayList<XMLReaderAdapter.Attribute>(jsonObject.values().size());
                        for (Map.Entry nextEntry : jsonObject.entrySet()) {
                            JsonValue nextValue;
                            String attributeLocalName = (String)nextEntry.getKey();
                            if (this.attributePrefix != null) {
                                if (!attributeLocalName.startsWith(this.attributePrefix)) break;
                                attributeLocalName = attributeLocalName.substring(this.attributePrefix.length());
                            }
                            String uri = "";
                            if (this.namespaceAware && this.namespaces != null) {
                                if (attributeLocalName.length() > 2) {
                                    String prefix = "";
                                    int nsIndex = attributeLocalName.indexOf(this.namespaceSeparator, 1);
                                    if (nsIndex > -1) {
                                        prefix = attributeLocalName.substring(0, nsIndex);
                                    }
                                    if ((uri = this.namespaces.resolveNamespacePrefix(prefix)) == null) {
                                        uri = this.namespaces.getDefaultNamespaceURI();
                                    } else {
                                        attributeLocalName = attributeLocalName.substring(nsIndex + 1);
                                    }
                                } else {
                                    uri = this.namespaces.getDefaultNamespaceURI();
                                }
                            }
                            if ((nextValue = (JsonValue)nextEntry.getValue()).getValueType() == JsonValue.ValueType.ARRAY) {
                                JsonArray jsonArray = (JsonArray)nextValue;
                                if (jsonArray.size() == 0) {
                                    attributesList.add(new XMLReaderAdapter.Attribute(uri, attributeLocalName, attributeLocalName, ""));
                                }
                                for (JsonValue nextChildValue : jsonArray) {
                                    this.addSimpleAttribute(attributesList, uri, attributeLocalName, nextChildValue);
                                }
                                continue;
                            }
                            this.addSimpleAttribute(attributesList, uri, attributeLocalName, nextValue);
                        }
                        this.attributes = attributesList.toArray(new XMLReaderAdapter.Attribute[attributesList.size()]);
                        break;
                    }
                    default: {
                        this.attributes = NO_ATTRIBUTES;
                    }
                }
            }
            return this.attributes;
        }
    }
}

