/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.yasson.internal.serializer;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.Optional;
import javax.json.bind.serializer.SerializationContext;
import javax.json.stream.JsonGenerator;
import org.eclipse.yasson.internal.ReflectionUtils;
import org.eclipse.yasson.internal.serializer.AbstractContainerSerializer;
import org.eclipse.yasson.internal.serializer.EmbeddedItem;
import org.eclipse.yasson.internal.serializer.SerializerBuilder;

public class MapSerializer<T extends Map<?, ?>>
extends AbstractContainerSerializer<T>
implements EmbeddedItem {
    protected MapSerializer(SerializerBuilder builder) {
        super(builder);
    }

    @Override
    protected void serializeInternal(T obj, JsonGenerator generator, SerializationContext ctx) {
        for (Map.Entry entry : obj.entrySet()) {
            String keysString = String.valueOf(entry.getKey());
            Object value = entry.getValue();
            if (value == null) {
                generator.writeNull(keysString);
                continue;
            }
            generator.writeKey(keysString);
            this.serializeItem(value, generator, ctx);
        }
    }

    @Override
    protected void writeStart(JsonGenerator generator) {
        generator.writeStartObject();
    }

    @Override
    protected void writeStart(String key, JsonGenerator generator) {
        generator.writeStartObject(key);
    }

    @Override
    protected Type getValueType(Type valueType) {
        if (valueType instanceof ParameterizedType) {
            Optional<Type> runtimeTypeOptional = ReflectionUtils.resolveOptionalType(this, ((ParameterizedType)valueType).getActualTypeArguments()[1]);
            return (Type)((Object)runtimeTypeOptional.orElse((Type)((Object)Object.class)));
        }
        return Object.class;
    }
}

