/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.digester;

import java.util.logging.Level;
import org.apache.tomcat.util.digester.Digester;
import org.apache.tomcat.util.digester.Rule;
import org.glassfish.web.util.IntrospectionUtils;

public class SetTopRule
extends Rule {
    protected String methodName = null;
    protected String paramType = null;
    protected boolean useExactMatch = false;

    public SetTopRule(Digester digester, String methodName) {
        this(methodName);
    }

    public SetTopRule(Digester digester, String methodName, String paramType) {
        this(methodName, paramType);
    }

    public SetTopRule(String methodName) {
        this(methodName, null);
    }

    public SetTopRule(String methodName, String paramType) {
        this.methodName = methodName;
        this.paramType = paramType;
    }

    public boolean isExactMatch() {
        return this.useExactMatch;
    }

    public void setExactMatch(boolean useExactMatch) {
        this.useExactMatch = useExactMatch;
    }

    @Override
    public void end() throws Exception {
        Object child = this.digester.peek(0);
        Object parent = this.digester.peek(1);
        if (this.digester.log.isLoggable(Level.FINE)) {
            if (child == null) {
                this.digester.log.log(Level.FINE, "[SetTopRule]{" + this.digester.match + "} Call [NULL CHILD]." + this.methodName + "(" + parent + ")");
            } else {
                this.digester.log.log(Level.FINE, "[SetTopRule]{" + this.digester.match + "} Call " + child.getClass().getName() + "." + this.methodName + "(" + parent + ")");
            }
        }
        IntrospectionUtils.callMethod1((Object)child, (String)this.methodName, (Object)parent, (String)this.paramType, (ClassLoader)this.digester.getClassLoader());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SetTopRule[");
        sb.append("methodName=");
        sb.append(this.methodName);
        sb.append(", paramType=");
        sb.append(this.paramType);
        sb.append("]");
        return sb.toString();
    }
}

