/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.util;

import org.glassfish.admin.amx.util.AMXDebug;
import org.glassfish.admin.amx.util.Output;
import org.glassfish.admin.amx.util.StringUtil;

public final class AMXDebugHelper {
    private final Output mOutput;
    private final String mName;
    volatile boolean mEchoToStdOut;

    public AMXDebugHelper(String name) {
        this.mOutput = AMXDebug.getInstance().getOutput(name);
        this.mName = name;
        this.mEchoToStdOut = false;
    }

    public AMXDebugHelper() {
        this("debug");
    }

    public boolean getEchoToStdOut(boolean echo) {
        return this.mEchoToStdOut;
    }

    public void setEchoToStdOut(boolean echo) {
        this.mEchoToStdOut = echo;
    }

    public boolean getDebug() {
        return AMXDebug.getInstance().getDebug(this.mName);
    }

    public void setDebug(boolean debug) {
        AMXDebug.getInstance().setDebug(this.mName, debug);
    }

    private void printlnWithTime(String s) {
        long now = System.currentTimeMillis();
        String msg = now + ": " + s;
        this.mOutput.println(msg);
        if (this.mEchoToStdOut) {
            System.out.println(msg);
        }
    }

    public void println(Object o) {
        if (this.getDebug()) {
            this.printlnWithTime("" + StringUtil.toString(o));
        }
    }

    public void println() {
        this.println((Object)"");
    }

    public void println(Object ... items) {
        if (this.getDebug() && items != null) {
            String msg = null;
            msg = items.length == 1 ? StringUtil.toString(items[0]) : StringUtil.toString("", items);
            this.printlnWithTime(msg);
        }
    }

    public void dumpStack(String msg) {
        if (this.getDebug()) {
            this.println();
            this.println((Object)("STACK DUMP FOLLOWS: " + msg));
            this.println((Object)StringUtil.toString(new Exception("not a real exception")));
            this.println();
        }
    }
}

