/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jdo.spi.persistence.support.sqlstore.query.util.type;

import com.sun.jdo.api.persistence.model.jdo.PersistenceFieldElement;
import com.sun.jdo.api.persistence.model.jdo.RelationshipElement;
import com.sun.jdo.api.persistence.support.JDOFatalInternalException;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.ClassType;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.Type;
import com.sun.jdo.spi.persistence.support.sqlstore.query.util.type.TypeTable;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ResourceBundle;
import org.glassfish.persistence.common.I18NHelper;

public class FieldInfo {
    protected String name;
    protected ClassType classType;
    protected Field field;
    protected PersistenceFieldElement pfe;
    protected static final ResourceBundle messages = I18NHelper.loadBundle((String)"com.sun.jdo.spi.persistence.support.sqlstore.query.Bundle", (ClassLoader)FieldInfo.class.getClassLoader());

    public FieldInfo(Field field, ClassType classType) {
        this.name = field.getName();
        this.classType = classType;
        this.field = field;
        this.pfe = classType.pce != null ? classType.pce.getField(this.name) : null;
    }

    public boolean isPersistent() {
        if (this.pfe != null) {
            return this.pfe.getPersistenceType() == 0;
        }
        return false;
    }

    public boolean isPublic() {
        return this.field != null && Modifier.isPublic(this.field.getModifiers());
    }

    public boolean isStatic() {
        return this.field != null && Modifier.isStatic(this.field.getModifiers());
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        if (this.field == null) {
            TypeTable cfr_ignored_0 = this.classType.typetab;
            return TypeTable.errorType;
        }
        Type ret = this.classType.typetab.checkType(this.field.getType());
        if (ret == null) {
            TypeTable cfr_ignored_1 = this.classType.typetab;
            ret = TypeTable.errorType;
        }
        return ret;
    }

    public int getFieldNumber() {
        if (this.pfe != null) {
            int index = this.pfe.getFieldNumber();
            if (index < 0) {
                throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"query.util.type.fieldinfo.getfieldnumber.invalidfieldno", (String)String.valueOf(index), (String)this.name));
            }
            return index;
        }
        throw new JDOFatalInternalException(I18NHelper.getMessage((ResourceBundle)messages, (String)"query.util.type.fieldinfo.getfieldnumber.missingfieldelement", (String)this.name));
    }

    public boolean isRelationship() {
        return this.pfe != null && this.pfe instanceof RelationshipElement;
    }

    public Type getAssociatedClass() {
        Type associatedClass = null;
        if (this.pfe != null && this.pfe instanceof RelationshipElement) {
            String className = ((RelationshipElement)this.pfe).getElementClass();
            associatedClass = this.classType.typetab.checkType(className);
        }
        return associatedClass;
    }
}

