/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dbschema.nodes;

import org.netbeans.modules.dbschema.ColumnElement;
import org.netbeans.modules.dbschema.ColumnPairElement;
import org.netbeans.modules.dbschema.nodes.DBElementNode;
import org.netbeans.modules.dbschema.nodes.DBMemberElementNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;

public class ColumnPairElementNode
extends DBMemberElementNode {
    public ColumnPairElementNode(ColumnPairElement element, boolean writeable) {
        super(element, Children.LEAF, writeable);
    }

    @Override
    protected String resolveIconBase() {
        return "org/netbeans/modules/dbschema/resources/column";
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = sheet.get("properties");
        ps.put(this.createNameProperty(this.writeable));
        ps.put(this.createLocalColumnProperty(this.writeable));
        ps.put(this.createReferencedColumnProperty(this.writeable));
        return sheet;
    }

    @Override
    protected Node.Property createNameProperty(boolean canW) {
        return new DBElementNode.ElementProp("name", String.class, canW){

            @Override
            public Object getValue() {
                return ColumnPairElementNode.this.localColumnName() + ";" + ColumnPairElementNode.this.referencedColumnName();
            }
        };
    }

    protected Node.Property createLocalColumnProperty(boolean canW) {
        return new DBElementNode.ElementProp("localColumn", String.class, canW){

            @Override
            public Object getValue() {
                return ColumnPairElementNode.this.localColumnName();
            }
        };
    }

    protected Node.Property createReferencedColumnProperty(boolean canW) {
        return new DBElementNode.ElementProp("referencedColumn", String.class, canW){

            @Override
            public Object getValue() {
                return ColumnPairElementNode.this.referencedColumnName();
            }
        };
    }

    private String localColumnName() {
        ColumnElement elm = ((ColumnPairElement)this.element).getLocalColumn();
        return elm.getDeclaringTable().getName().getName() + "." + elm.getName().getName();
    }

    private String referencedColumnName() {
        ColumnElement elm = ((ColumnPairElement)this.element).getReferencedColumn();
        return elm.getDeclaringTable().getName().getName() + "." + elm.getName().getName();
    }
}

