/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.server.internal.routing;

import java.util.Iterator;
import java.util.List;
import java.util.regex.MatchResult;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.message.internal.TracingLogger;
import org.glassfish.jersey.server.internal.ServerTraceEvent;
import org.glassfish.jersey.server.internal.process.RequestProcessingContext;
import org.glassfish.jersey.server.internal.routing.Route;
import org.glassfish.jersey.server.internal.routing.Router;
import org.glassfish.jersey.server.internal.routing.RoutingContext;
import org.glassfish.jersey.uri.PathPattern;

final class PathMatchingRouter
implements Router {
    private final List<Route> acceptedRoutes;

    PathMatchingRouter(List<Route> routes) {
        this.acceptedRoutes = routes;
    }

    @Override
    public Router.Continuation apply(RequestProcessingContext context) {
        RoutingContext rc = context.routingContext();
        String path = rc.getFinalMatchingGroup();
        TracingLogger tracingLogger = TracingLogger.getInstance((PropertiesDelegate)context.request());
        tracingLogger.log((TracingLogger.Event)ServerTraceEvent.MATCH_PATH_FIND, new Object[]{path});
        Router.Continuation result = null;
        Iterator<Route> iterator = this.acceptedRoutes.iterator();
        while (iterator.hasNext()) {
            Route acceptedRoute = iterator.next();
            PathPattern routePattern = acceptedRoute.routingPattern();
            MatchResult m = routePattern.match((CharSequence)path);
            if (m != null) {
                rc.pushMatchResult(m);
                result = Router.Continuation.of(context, acceptedRoute.next());
                tracingLogger.log((TracingLogger.Event)ServerTraceEvent.MATCH_PATH_SELECTED, new Object[]{routePattern.getRegex()});
                break;
            }
            tracingLogger.log((TracingLogger.Event)ServerTraceEvent.MATCH_PATH_NOT_MATCHED, new Object[]{routePattern.getRegex()});
        }
        if (tracingLogger.isLogEnabled((TracingLogger.Event)ServerTraceEvent.MATCH_PATH_SKIPPED)) {
            while (iterator.hasNext()) {
                tracingLogger.log((TracingLogger.Event)ServerTraceEvent.MATCH_PATH_SKIPPED, new Object[]{iterator.next().routingPattern().getRegex()});
            }
        }
        if (result == null) {
            return Router.Continuation.of(context);
        }
        return result;
    }
}

