/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.deployment.common;

import com.sun.enterprise.deploy.shared.FileArchive;
import com.sun.enterprise.util.i18n.StringManager;
import com.sun.enterprise.util.io.FileUtils;
import com.sun.enterprise.util.zip.ZipFile;
import com.sun.enterprise.util.zip.ZipFileException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Logger;
import org.glassfish.api.deployment.archive.Archive;
import org.glassfish.deployment.common.DeploymentContextImpl;
import org.glassfish.deployment.common.DeploymentException;
import org.glassfish.logging.annotation.LogMessageInfo;

public class ModuleExploder {
    public static final Logger deplLogger = DeploymentContextImpl.deplLogger;
    @LogMessageInfo(message="Could not expand entry {0} into destination {1}", cause="An exception was caught when the entry was expanded", action="See the exception to determine how to fix the error", level="SEVERE")
    private static final String COULD_NOT_EXPAND_ENTRY = "NCLS-DEPLOYMENT-00005";
    protected static final StringManager localStrings = StringManager.getManager(ModuleExploder.class);
    protected static final String PRESERVED_MANIFEST_NAME = "META-INF/MANIFEST.MF.preserved";
    protected static final String WEB_INF_PREFIX = "WEB-INF/";

    public static void explodeJar(File source, File destination) throws IOException {
        String fileSystemName = null;
        try (JarFile jarFile = null;){
            jarFile = new JarFile(source);
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                fileSystemName = entry.getName().replace('/', File.separatorChar);
                File out = new File(destination, fileSystemName);
                if (entry.isDirectory()) {
                    if (out.exists() || out.mkdirs()) continue;
                    throw new IOException("Unable to create directories " + out.getAbsolutePath());
                }
                if (!out.getParentFile().exists()) {
                    out.getParentFile().mkdirs();
                }
                BufferedInputStream is = new BufferedInputStream(jarFile.getInputStream(entry));
                FileOutputStream fos = FileUtils.openFileOutputStream((File)out);
                FileUtils.copy((InputStream)is, (FileOutputStream)fos, (long)entry.getSize());
            }
        }
    }

    public static void explodeModule(Archive source, File directory, boolean preserveManifest) throws IOException, DeploymentException {
        File explodedManifest = null;
        File preservedManifestFromArchive = null;
        FileArchive target = new FileArchive();
        target.create(directory.toURI());
        ModuleExploder.explodeJar(new File(source.getURI()), directory);
        if (preserveManifest && (explodedManifest = new File(directory, "META-INF/MANIFEST.MF")).exists() && !explodedManifest.renameTo(preservedManifestFromArchive = new File(directory, PRESERVED_MANIFEST_NAME))) {
            throw new RuntimeException(localStrings.getString("enterprise.deployment.backend.error_saving_manifest", new Object[]{explodedManifest.getAbsolutePath(), preservedManifestFromArchive.getAbsolutePath()}));
        }
        Enumeration itr = source.entries();
        while (itr.hasMoreElements()) {
            String fileName = (String)itr.nextElement();
            if (!fileName.toLowerCase(Locale.US).endsWith(".jar") || fileName.replace('\\', '/').toUpperCase(Locale.getDefault()).startsWith(WEB_INF_PREFIX)) continue;
            try {
                File f = new File(directory, fileName);
                ZipFile zip = new ZipFile(f, directory);
                zip.explode();
            }
            catch (ZipFileException e) {
                IOException ioe = new IOException(e.getMessage());
                ioe.initCause(e);
                throw ioe;
            }
        }
        if (preservedManifestFromArchive != null) {
            if (explodedManifest.exists() && !explodedManifest.delete()) {
                throw new RuntimeException(localStrings.getString("enterprise.deployment.backend.error_deleting_manifest", new Object[]{explodedManifest.getAbsolutePath(), preservedManifestFromArchive.getAbsolutePath()}));
            }
            if (!preservedManifestFromArchive.renameTo(explodedManifest)) {
                throw new RuntimeException(localStrings.getString("enterprise.deployment.backend.error_restoring_manifest", new Object[]{preservedManifestFromArchive.getAbsolutePath(), explodedManifest.getAbsolutePath()}));
            }
        }
        source.close();
        target.close();
    }
}

