/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.resourcebase.resources.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Proxy;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.glassfish.hk2.api.ActiveDescriptor;
import org.glassfish.hk2.api.ServiceHandle;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.api.ResourceDeployerInfo;
import org.jvnet.hk2.annotations.Service;

@Singleton
@Service
public class ResourceManagerFactory {
    public static final String METADATA_KEY = "ResourceImpl";
    @Inject
    private ServiceLocator locator;

    public ResourceDeployer getResourceDeployer(Object resource) {
        Object deployer;
        ServiceHandle deployerHandle = null;
        for (ServiceHandle handle : this.locator.getAllServiceHandles(ResourceDeployerInfo.class, new Annotation[0])) {
            List resourceImpls;
            ActiveDescriptor desc = handle.getActiveDescriptor();
            if (desc == null || (resourceImpls = (List)desc.getMetadata().get(METADATA_KEY)) == null || resourceImpls.isEmpty()) continue;
            String resourceImpl = (String)resourceImpls.get(0);
            if (Proxy.isProxyClass(resource.getClass())) {
                for (Class<?> clz : resource.getClass().getInterfaces()) {
                    if (!resourceImpl.equals(clz.getName())) continue;
                    deployerHandle = handle;
                    break;
                }
                if (deployerHandle != null) break;
            }
            if (resourceImpl.equals(resource.getClass().getName())) {
                deployerHandle = handle;
                break;
            }
            for (Class<?> clz : resource.getClass().getInterfaces()) {
                if (!resourceImpl.equals(clz.getName())) continue;
                deployerHandle = handle;
                break;
            }
            if (deployerHandle == null) continue;
            break;
        }
        if (deployerHandle != null && (deployer = deployerHandle.getService()) != null && deployer instanceof ResourceDeployer) {
            return (ResourceDeployer)deployer;
        }
        return null;
    }
}

