package org.apache.jsp;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import java.io.IOException;
import javax.servlet.jsp.el.ELException;
import java.io.PrintWriter;

public final class ELExceptionTest_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


    public void elExceptionDefaultCtorTest(HttpServletRequest req,
                                            HttpServletResponse res,
                                            JspWriter out)
    throws ServletException, IOException {
        ELException ee = new ELException();
        if (ee != null) {
            out.println("Test PASSED");
        } else {
            out.println("Test FAILED.  No Exception created.");
        }
    }


    public void elExceptionMessageCtorTest(HttpServletRequest req,
                                            HttpServletResponse res,
                                            JspWriter out)
    throws ServletException, IOException {
        ELException ee = new ELException("Exception Message");
        if (ee != null) {
            String message = ee.getMessage();
            if (message != null && message.equals("Exception Message")) {
                out.println("Test PASSED");
            } else {
                out.println("Test FAILED.  Expected a message of 'Exception Message'");
                out.println("Received: " + message);
            }
        } else {
            out.println("Test FAILED.  No Exception created.");
        }
    }


    public void elExceptionCauseCtorTest(HttpServletRequest req,
                                          HttpServletResponse res,
                                          JspWriter out)
    throws ServletException, IOException {
        ELException ee = new ELException(new NullPointerException());
        if (ee != null) {
            Throwable t = ee.getRootCause();
            if (t != null && t instanceof NullPointerException) {
                out.println("Test PASSED");
            } else {
                out.println("Test FAILED.  Expected a Throwable of type NullPointerException");
                out.println("Received: " + t);
            }
        } else {
            out.println("Test FAILED.  No Exception created.");
        }
    }


    public void elExceptionCauseMessageCtorTest(HttpServletRequest req,
                                                 HttpServletResponse res,
                                                 JspWriter out)
    throws ServletException, IOException {
        ELException ee = new ELException("Exception Message",
                                                      new ServletException());
        if (ee != null) {
            String message = ee.getMessage();
            if (message != null && message.equals("Exception Message")) {
                Throwable t = ee.getRootCause();
                if (t != null && t instanceof ServletException) {
                    out.println("Test PASSED");
                } else {
                    out.println("Test FAILED.  Expected a Throwable of type ServletException");
                    out.println("Received: " + t);
                }
            } else {
                out.println("Test FAILED.  Expected a message of 'Exception Message'");
                out.println("Received: " + message);
            }
        } else {
            out.println("Test FAILED.  No Exception created.");
        }
    }


    public void elExceptionGetRootCauseTest(HttpServletRequest req,
                                             HttpServletResponse res,
                                             JspWriter out)
    throws ServletException, IOException {
        ELException ee = new ELException(new ServletException());
        ELException ee1 = new ELException("exception", new NullPointerException());

        Throwable t = ee.getRootCause();
        Throwable t1 = ee1.getRootCause();
        if (t != null) {
            if (t instanceof ServletException) {
                if (t1 != null) {
                    if (t1 instanceof NullPointerException) {
                        out.println("Test PASSED");
                    } else {
                        out.println("Test FAILED.  ELException.getRootCause returned unexpected" +
                            " exception: " + t.getClass().getName());
                        out.println("Expected: NullPointerException");
                    }
                } else {
                    out.println("Test FAILED.  ELException.getRootCause returned null.");
                }
            } else {
                out.println("Test FAILED.  ELException.getRootCause returned unexpected" +
                    " exception: " + t.getClass().getName());
                out.println("Expected: ServletException");
            }
        } else {
            out.println("Test FAILED.  ELException.getRootCause returned null.");
        }
    }


    public void elExceptionToStringTest(HttpServletRequest req,
                                        HttpServletResponse res,
                                        JspWriter out)
    throws ServletException, IOException {
        ELException ee = new ELException();
        String str = ee.toString();
        if (str != null) {
            out.println("Test PASSED");
        } else {
            out.println("Test FAILED.  Result of ELException.toString() was null.");
        }
    }

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List<String> _jspx_dependants;

  private org.glassfish.jsp.api.ResourceInjector _jspx_resourceInjector;

  public java.util.List<String> getDependants() {
    return _jspx_dependants;
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;

    try {
      response.setContentType("text/plain");
      response.setHeader("X-Powered-By", "JSP/2.3");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;
      _jspx_resourceInjector = (org.glassfish.jsp.api.ResourceInjector) application.getAttribute("com.sun.appserv.jsp.resource.injector");

      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
 JspTestUtil.invokeTest(this, request, response, out); 
      out.write('\n');
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          out.clearBuffer();
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
