package org.apache.jsp;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import java.io.IOException;
import javax.servlet.jsp.tagext.TagSupport;
import javax.servlet.jsp.tagext.Tag;
import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import java.util.Enumeration;

public final class TagSupportApiTest_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


    public void doStartTagTest(HttpServletRequest req,
                               HttpServletResponse res,
                               JspWriter out)
    throws ServletException, IOException {
        TagSupport support = new TagSupport();
        int retValue = 0;
        try {
            retValue = support.doStartTag();
        } catch (JspException je) {
            throw new ServletException("Unexpected Exception!", je);
        }
        if (retValue == Tag.SKIP_BODY) {
            out.println("Test PASSED");
        } else {
            out.println("Test FAILED.  Expected the default return value" +
                " of TagSupport.doStartTag() to be Tag.SKIP_BODY.  Received:" +
                "  " + JspTestUtil.getTagStatusAsString("doStartTag", "Tag",
                    retValue));
        }
    }


    public void doEndTagTest(HttpServletRequest req,
                             HttpServletResponse res,
                             JspWriter out)
    throws ServletException, IOException {
        TagSupport support = new TagSupport();
        int retValue = 0;
        try {
            retValue = support.doEndTag();
        } catch (JspException je) {
            throw new ServletException("Unexpected Exception!", je);
        }
        if (retValue == Tag.EVAL_PAGE) {
            out.println("Test PASSED");
        } else {
            out.println("Test FAILED.  Expected the default return value" +
                " of TagSupport.doEndTag() to be Tag.EVAL_PAGE.  Received:" +
                "  " + JspTestUtil.getTagStatusAsString("doEndTag", "Tag",
                    retValue));
        }
    }


    public void doAfterBodyTest(HttpServletRequest req,
                                HttpServletResponse res,
                                JspWriter out)
    throws ServletException, IOException {
        TagSupport support = new TagSupport();
        int retValue = 0;
        try {
            retValue = support.doAfterBody();
        } catch (JspException je) {
            throw new ServletException("Unexpected Exception!", je);
        }
        if (retValue == Tag.SKIP_BODY) {
            out.println("Test PASSED");
        } else {
            out.println("Test FAILED.  Expected the default return value" +
                " of TagSupport.doAfterBody() to be Tag.SKIP_BODY.  Received:" +
                "  " + JspTestUtil.getTagStatusAsString("doAfterBody", "IterationTag",
                    retValue));
        }
    }


    public void setGetValue(HttpServletRequest req,
                            HttpServletResponse res,
                            JspWriter out)
    throws ServletException, IOException {
        TagSupport support = new TagSupport();
        support.setValue("key1", "value1");
        String retValue = (String) support.getValue("key1");
        if (retValue.equals("value1")) {
            out.println("Test PASSED");
        } else {
            out.println("Test FAILED.  Expected TagSupport.getValue() to return" +
                "'value1' for key 'key1'.  The actual value received was: " +
                retValue);
        }
    }


    public void getValues(HttpServletRequest req,
                          HttpServletResponse res,
                          JspWriter out)
    throws ServletException, IOException {
        TagSupport support = new TagSupport();
        support.setValue("key1", "value1");
        support.setValue("key3", "value3");
        support.setValue("key2", "value2");
        Enumeration e = support.getValues();
        if (JspTestUtil.checkEnumeration(e,
            new String[] { "key1", "key2", "key3" })) {
            out.println("Test PASSED");
        } else {
            out.println("Test FAILED.  Expected the following values to be found" +
                " in the Enumeration returned by getValues(): [ key1, key2, key3 ]" +
                ".  Values in the Enumeration: " +
                JspTestUtil.getAsString(support.getValues()));
        }
    }


    public void removeValue(HttpServletRequest req,
                            HttpServletResponse res,
                            JspWriter out)
    throws ServletException, IOException {
        TagSupport support = new TagSupport();
        support.setValue("key1", "value1");
        support.setValue("key2", "value2");
        support.removeValue("key1");
        if (support.getValue("key1") == null) {
            if (support.getValue("key2") != null) {
                out.println("Test PASSED");
            } else {
                out.println("Test FAILED.  Passed 'key1' to TagSupport.remove" +
                    "Value(), but 'key2' was removed as well.");
            }
        } else {
            out.println("Test FAILED.  Passed 'key1' to TagSupport.remove" +
                "Value(), but 'key1' was not removed.");
        }
    }

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List<String> _jspx_dependants;

  private org.glassfish.jsp.api.ResourceInjector _jspx_resourceInjector;

  public java.util.List<String> getDependants() {
    return _jspx_dependants;
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;

    try {
      response.setContentType("text/plain");
      response.setHeader("X-Powered-By", "JSP/2.3");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;
      _jspx_resourceInjector = (org.glassfish.jsp.api.ResourceInjector) application.getAttribute("com.sun.appserv.jsp.resource.injector");

      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');

    JspTestUtil.invokeTest(this, request, response, out);

      out.write('\n');
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          out.clearBuffer();
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
