package org.apache.jsp;

import javax.servlet.*;
import javax.servlet.http.*;
import javax.servlet.jsp.*;
import com.sun.ts.tests.jsp.common.util.JspTestUtil;
import java.io.IOException;
import javax.servlet.jsp.tagext.VariableInfo;

public final class VariableInfoTest_jsp extends org.apache.jasper.runtime.HttpJspBase
    implements org.apache.jasper.runtime.JspSourceDependent {


    public void variableInfoCtorTest(HttpServletRequest req,
                                     HttpServletResponse res,
                                     JspWriter out)
    throws ServletException, IOException {
        VariableInfo infoBegin = new VariableInfo("beginVar",
            "com.sun.ts.tests.jsp.api.MyVar", true, VariableInfo.AT_BEGIN);
        VariableInfo infoNested = new VariableInfo("nestedVar",
            "com.sun.ts.tests.jsp.api.MyVar", false, VariableInfo.NESTED);
        VariableInfo infoEnd = new VariableInfo("endVar",
            "com.sun.ts.tests.jsp.api.MyVar", true, VariableInfo.AT_END);
        if (infoBegin != null) {
            if (infoNested != null) {
                if (infoEnd != null) {
                    out.println("Test PASSED");
                } else {
                    out.println("Test FAILED.  Unable to create instance of VariableInfo.");
                }
            } else {
                out.println("Test FAILED.  Unable to create instance of VariableInfo.");
            }
        } else {
            out.println("Test FAILED.  Unable to create instance of VariableInfo.");
        }
    }


    public void variableInfoGetVarNameTest(HttpServletRequest req,
                                           HttpServletResponse res,
                                           JspWriter out)
    throws ServletException, IOException {
        VariableInfo info = new VariableInfo("myVar",
            "com.sun.ts.tests.jsp.api.MyVar", true, VariableInfo.NESTED);
        if (info != null) {
            String varName = info.getVarName();
            if (varName != null) {
                if (varName.equals("myVar")) {
                    out.println("Test PASSED");
                } else {
                    out.println("Test FAILED.  Expected 'myVar' to be returned" +
                        " from VariableInfo.getVarName().");
                    out.println("Received: " + varName);
                }
            } else {
                out.println("Test FAILED.  VariableInfo.getVarName() returned null.");
            }
        } else {
            out.println("Test FAILED.  Unable to create instance of VariableInfo.");
        }
    }


    public void variableInfoGetClassNameTest(HttpServletRequest req,
                                             HttpServletResponse res,
                                             JspWriter out)
    throws ServletException, IOException {
        VariableInfo info = new VariableInfo("myVar",
            "com.sun.ts.tests.jsp.api.MyVar", true, VariableInfo.AT_END);
        if (info != null) {
            String className = info.getClassName();
            if (className != null) {
                if (className.equals("com.sun.ts.tests.jsp.api.MyVar")) {
                    out.println("Test PASSED");
                } else {
                    out.println("Test FAILED.  Expected 'com.sun.ts.tests.jsp.api.MyVar'" +
                        " to be retuned from VariableInfo.getClassName()");
                    out.println("Received: " + className);
                }
            } else {
                out.println("Test FAILED.  VariableInfo.getClassName() returned null.");
            }
        } else {
            out.println("Test FAILED.  Unable to create instance of VariableInfo.");
        }
    }


    public void variableInfoGetDeclareTest(HttpServletRequest req,
                                           HttpServletResponse res,
                                           JspWriter out)
    throws ServletException, IOException {
        VariableInfo info = new VariableInfo("myVar",
            "com.sun.ts.tests.jsp.api.MyVar", true, VariableInfo.AT_END);
        if (info != null) {
            boolean declare = info.getDeclare();
            if (declare == true) {
                out.println("Test PASSED");
            } else {
                out.println("Test FAILED.  Expected 'true'" +
                   " to be retuned from VariableInfo.getDeclare()");
                out.println("Received: false");
            }
        } else {
            out.println("Test FAILED.  Unable to create instance of VariableInfo.");
        }
    }


    public void variableInfoGetScopeTest(HttpServletRequest req,
                                         HttpServletResponse res,
                                         JspWriter out)
    throws ServletException, IOException {
        VariableInfo info = new VariableInfo("myVar",
                "com.sun.ts.tests.jsp.api.MyVar", false, VariableInfo.NESTED);
        if (info != null) {
            int scope = info.getScope();
            if (scope == VariableInfo.NESTED) {
                out.println("Test PASSED");
            } else {
                out.println("Test FAILED.  VariableInto.getScope() did not return" +
                    "the expected value, VariableInto.NESTED.");
            }
        } else {
            out.println("Test FAILED.  Unable to create instance of VariableInfo.");
        }
    }

  private static final JspFactory _jspxFactory = JspFactory.getDefaultFactory();

  private static java.util.List<String> _jspx_dependants;

  private org.glassfish.jsp.api.ResourceInjector _jspx_resourceInjector;

  public java.util.List<String> getDependants() {
    return _jspx_dependants;
  }

  public void _jspService(HttpServletRequest request, HttpServletResponse response)
        throws java.io.IOException, ServletException {

    PageContext pageContext = null;
    HttpSession session = null;
    ServletContext application = null;
    ServletConfig config = null;
    JspWriter out = null;
    Object page = this;
    JspWriter _jspx_out = null;
    PageContext _jspx_page_context = null;

    try {
      response.setContentType("text/plain");
      response.setHeader("X-Powered-By", "JSP/2.3");
      pageContext = _jspxFactory.getPageContext(this, request, response,
      			null, true, 8192, true);
      _jspx_page_context = pageContext;
      application = pageContext.getServletContext();
      config = pageContext.getServletConfig();
      session = pageContext.getSession();
      out = pageContext.getOut();
      _jspx_out = out;
      _jspx_resourceInjector = (org.glassfish.jsp.api.ResourceInjector) application.getAttribute("com.sun.appserv.jsp.resource.injector");

      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write("\n");
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
      out.write('\n');
 JspTestUtil.invokeTest(this, request, response, out); 
      out.write('\n');
    } catch (Throwable t) {
      if (!(t instanceof SkipPageException)){
        out = _jspx_out;
        if (out != null && out.getBufferSize() != 0)
          out.clearBuffer();
        if (_jspx_page_context != null) _jspx_page_context.handlePageException(t);
        else throw new ServletException(t);
      }
    } finally {
      _jspxFactory.releasePageContext(_jspx_page_context);
    }
  }
}
