/*
 * Copyright (c) 2013, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.ts.tests.jpa.core.annotations.ordercolumn;

import javax.persistence.*;
import java.util.List;

@Entity
public class Course implements java.io.Serializable {
  @Id
  int id;

  String courseName;

  @JoinTable(name = "COURSE_STUDENT", joinColumns = @JoinColumn(name = "COURSE_ID"), inverseJoinColumns = @JoinColumn(name = "STUDENT_ID"))
  @OrderColumn(name = "STUDENTS_ORDER", nullable = true, updatable = true, insertable = true)
  @ManyToMany(cascade = CascadeType.ALL)
  List<Student> students;

  public Course() {
  }

  public Course(int id, String name) {
    this.id = id;
    this.courseName = name;
  }

  public String getCourseName() {
    return courseName;
  }

  public void setCourseName(String courseName) {
    this.courseName = courseName;
  }

  public List<Student> getStudents() {
    return students;
  }

  public void setStudents(List<Student> students) {
    this.students = students;
  }

  public int hashCode() {

    return this.id;
  }

  public boolean equals(Object obj) {
    boolean result = false;

    if ((obj != null) && (obj instanceof Course)) {
      Course course = (Course) obj;
      result = (course.id == this.id);
    }
    return result;
  }

  public int getId() {
    return id;
  }

  public void setId(int id) {
    this.id = id;
  }

}
