/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.collectortests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.TreeSet;
import java.util.stream.Collector;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.stream.JsonCollectors;

public class Collectors {
    private static final JsonArray[] ARRAY_VALUES = new JsonArray[]{SimpleValues.createSimpleStringArray5(), SimpleValues.createSimpleIntArray5(), SimpleValues.createSimpleBoolArray5(), SimpleValues.createSimpleObjectArray5()};
    private static final JsonObject[] OBJ_VALUES = new JsonObject[]{SimpleValues.createSimpleObjectWithStr(), SimpleValues.createSimpleObjectWithInt(), SimpleValues.createSimpleObjectWithBool(), SimpleValues.createCompoundObject()};
    private static final JsonArray OBJ_ARRAY_GROUP = Json.createArrayBuilder().add(Json.createObjectBuilder().add("name", "Peter").add("office", "Green")).add(Json.createObjectBuilder().add("name", "John").add("office", "Red")).add(Json.createObjectBuilder().add("name", "Bob").add("office", "Blue")).add(Json.createObjectBuilder().add("name", "Sarah").add("office", "Red")).add(Json.createObjectBuilder().add("name", "Tom").add("office", "Blue")).add(Json.createObjectBuilder().add("name", "Jane").add("office", "Blue")).add(Json.createObjectBuilder().add("name", "Peggy").add("office", "Green")).add(Json.createObjectBuilder().add("name", "Rick").add("office", "Red")).build();

    Collectors() {
    }

    TestResult test() {
        TestResult result = new TestResult("JsonCollectors class implementation");
        TestUtil.logMsg((String)"JsonCollectors class implementation");
        this.testToJsonArrayCollector(result);
        this.testToJsonObjectCollector(result);
        this.testSimpleGroupingByCollector(result);
        this.testSortingGroupingByCollector(result);
        return result;
    }

    private void testToJsonArrayCollector(TestResult result) {
        TestUtil.logMsg((String)" - Collector returned by toJsonArray()");
        for (JsonArray in : ARRAY_VALUES) {
            TestUtil.logMsg((String)("   - Input: " + JsonAssert.valueToString((JsonValue)in)));
            Collector col = JsonCollectors.toJsonArray();
            JsonArray out = (JsonArray)in.getValuesAs(JsonObject.class).stream().collect(col);
            if (!this.operationFailed((JsonValue)in, (JsonValue)out)) continue;
            result.fail("toJsonArray()", "Output Stream value " + JsonAssert.valueToString((JsonValue)out) + " shall be " + JsonAssert.valueToString((JsonValue)in));
        }
    }

    private void testToJsonObjectCollector(TestResult result) {
        TestUtil.logMsg((String)" - Collector returned by toJsonObject(Function,Function)");
        JsonArray in = Json.createArrayBuilder().add(Json.createObjectBuilder().add("key", "address").add("value", "In a galaxy far far away")).add(Json.createObjectBuilder().add("key", "age").add("value", 42)).add(Json.createObjectBuilder().add("key", "married").add("value", true)).add(Json.createObjectBuilder().add("key", "wife").add("value", (JsonValue)SimpleValues.OBJ_VALUE)).build();
        JsonObject check = Json.createObjectBuilder().add("address", "In a galaxy far far away").add("age", 42).add("married", true).add("wife", (JsonValue)SimpleValues.OBJ_VALUE).build();
        TestUtil.logMsg((String)("     Input: " + JsonAssert.valueToString((JsonValue)in)));
        Collector col = JsonCollectors.toJsonObject(v -> {
            if (v.getValueType() == JsonValue.ValueType.OBJECT) {
                return v.asJsonObject().getString("key");
            }
            throw new IllegalStateException("Value must be JsonObject");
        }, v -> {
            if (v.getValueType() == JsonValue.ValueType.OBJECT) {
                return (JsonValue)v.asJsonObject().get((Object)"value");
            }
            throw new IllegalStateException("Value must be JsonObject");
        });
        JsonObject out = (JsonObject)in.getValuesAs(JsonObject.class).stream().collect(col);
        if (this.operationFailed((JsonValue)out, (JsonValue)check)) {
            result.fail("toJsonObject(Function,Function)", "Output Stream value " + JsonAssert.valueToString((JsonValue)out) + " shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    private void testSimpleGroupingByCollector(TestResult result) {
        TestUtil.logMsg((String)" - Collector returned by groupingBy(Function)");
        JsonObject check = Json.createObjectBuilder().add("Red", (JsonValue)Json.createArrayBuilder().add(Json.createObjectBuilder().add("name", "John").add("office", "Red")).add(Json.createObjectBuilder().add("name", "Sarah").add("office", "Red")).add(Json.createObjectBuilder().add("name", "Rick").add("office", "Red")).build()).add("Blue", (JsonValue)Json.createArrayBuilder().add(Json.createObjectBuilder().add("name", "Bob").add("office", "Blue")).add(Json.createObjectBuilder().add("name", "Tom").add("office", "Blue")).add(Json.createObjectBuilder().add("name", "Jane").add("office", "Blue")).build()).add("Green", (JsonValue)Json.createArrayBuilder().add(Json.createObjectBuilder().add("name", "Peter").add("office", "Green")).add(Json.createObjectBuilder().add("name", "Peggy").add("office", "Green")).build()).build();
        TestUtil.logMsg((String)("     Input: " + JsonAssert.valueToString((JsonValue)OBJ_ARRAY_GROUP)));
        Collector col = JsonCollectors.groupingBy(v -> {
            if (v.getValueType() == JsonValue.ValueType.OBJECT) {
                return v.asJsonObject().getString("office");
            }
            throw new IllegalStateException("Value must be JsonObject");
        });
        JsonObject out = (JsonObject)OBJ_ARRAY_GROUP.getValuesAs(JsonObject.class).stream().collect(col);
        if (this.operationFailed((JsonValue)out, (JsonValue)check)) {
            result.fail("groupingBy(Function)", "Output Stream value " + JsonAssert.valueToString((JsonValue)out) + " shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    private void testSortingGroupingByCollector(TestResult result) {
        TestUtil.logMsg((String)" - Collector returned by groupingBy(Function,Collector)");
        JsonObject check = Json.createObjectBuilder().add("Red", (JsonValue)Json.createArrayBuilder().add(Json.createObjectBuilder().add("name", "John").add("office", "Red")).add(Json.createObjectBuilder().add("name", "Rick").add("office", "Red")).add(Json.createObjectBuilder().add("name", "Sarah").add("office", "Red")).build()).add("Blue", (JsonValue)Json.createArrayBuilder().add(Json.createObjectBuilder().add("name", "Bob").add("office", "Blue")).add(Json.createObjectBuilder().add("name", "Jane").add("office", "Blue")).add(Json.createObjectBuilder().add("name", "Tom").add("office", "Blue")).build()).add("Green", (JsonValue)Json.createArrayBuilder().add(Json.createObjectBuilder().add("name", "Peggy").add("office", "Green")).add(Json.createObjectBuilder().add("name", "Peter").add("office", "Green")).build()).build();
        Collector<JsonValue, JsonArrayBuilder, JsonArray> toArray = Collector.of(() -> new ValueBuilder(), JsonArrayBuilder::add, JsonArrayBuilder::addAll, JsonArrayBuilder::build, new Collector.Characteristics[0]);
        TestUtil.logMsg((String)("     Input: " + JsonAssert.valueToString((JsonValue)OBJ_ARRAY_GROUP)));
        Collector col = JsonCollectors.groupingBy(v -> {
            if (v.getValueType() == JsonValue.ValueType.OBJECT) {
                return v.asJsonObject().getString("office");
            }
            throw new IllegalStateException("Value must be JsonObject");
        }, toArray);
        JsonObject out = (JsonObject)OBJ_ARRAY_GROUP.getValuesAs(JsonObject.class).stream().collect(col);
        if (this.operationFailed((JsonValue)out, (JsonValue)check)) {
            result.fail("groupingBy(Function,Collector)", "Output Stream value " + JsonAssert.valueToString((JsonValue)out) + " shall be " + JsonAssert.valueToString((JsonValue)check));
        }
    }

    protected boolean operationFailed(JsonValue check, JsonValue out) {
        TestUtil.logMsg((String)("     Checking " + JsonAssert.valueToString(out)));
        return out == null || !JsonAssert.assertEquals(check, out);
    }

    private class ValueBuilder
    implements JsonArrayBuilder {
        private final TreeSet<JsonValue> values = new TreeSet((v1, v2) -> {
            if (v1.getValueType() == JsonValue.ValueType.OBJECT && v1.getValueType() == JsonValue.ValueType.OBJECT) {
                return v1.asJsonObject().getString("name").compareTo(v2.asJsonObject().getString("name"));
            }
            throw new IllegalStateException("Values must be JsonObject");
        });

        private ValueBuilder() {
        }

        public JsonArrayBuilder add(JsonValue value) {
            this.values.add(value);
            return this;
        }

        public ValueBuilder addAll(ValueBuilder builder) {
            this.values.addAll(builder.values);
            return this;
        }

        public JsonArray build() {
            JsonArrayBuilder builder = Json.createArrayBuilder();
            for (JsonValue value : this.values) {
                builder.add(value);
            }
            return builder.build();
        }

        public JsonArrayBuilder add(String value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public JsonArrayBuilder add(BigDecimal value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public JsonArrayBuilder add(BigInteger value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public JsonArrayBuilder add(int value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public JsonArrayBuilder add(long value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public JsonArrayBuilder add(double value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public JsonArrayBuilder add(boolean value) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public JsonArrayBuilder addNull() {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public JsonArrayBuilder add(JsonObjectBuilder builder) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        public JsonArrayBuilder add(JsonArrayBuilder builder) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

