/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.j2eetools.mgmt.api.mejb1;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import java.rmi.RemoteException;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanInfo;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.j2ee.Management;
import javax.management.j2ee.ManagementHome;

public class mejbClient1
extends ServiceEETest {
    private static final String mejbLookup = "java:comp/env/ejb/MEJB";
    private ManagementHome mejbHome = null;
    private TSNamingContext ctx = null;
    private Management mejb = null;

    public static void main(String[] args) {
        mejbClient1 theTests = new mejbClient1();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.ctx = new TSNamingContext();
            TestUtil.logTrace((String)"Got TSNamingContext");
            this.mejbHome = (ManagementHome)this.ctx.lookup(mejbLookup, ManagementHome.class);
            TestUtil.logTrace((String)"Got MEJB Home interface");
            this.mejb = this.mejbHome.create();
            TestUtil.logMsg((String)"Created MEJB instance");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Here is the SETUP ERROR: ", (Throwable)e);
            TestUtil.logMsg((String)("Exception during setup: " + e.getMessage()));
        }
    }

    public void testQueryNamesSet1() throws EETest.Fault {
        Set mos = null;
        TestUtil.logMsg((String)"Starting testQueryNameSet1");
        try {
            mos = this.mejb.queryNames(null, null);
        }
        catch (RemoteException e) {
            throw new EETest.Fault("FAILED: RemoteException on test: " + e.getMessage(), e);
        }
    }

    public void testQueryNamesSet2() throws EETest.Fault {
        Set mos = null;
        ObjectName search = null;
        TestUtil.logMsg((String)"Starting testQueryNameSet2");
        try {
            search = new ObjectName(":*");
        }
        catch (MalformedObjectNameException e) {
            throw new EETest.Fault("FAILED: Couldn't create ObjectName: " + e.getMessage(), e);
        }
        try {
            mos = this.mejb.queryNames(search, null);
        }
        catch (RemoteException e) {
            throw new EETest.Fault("FAILED: RemoteException on test: " + e.getMessage(), e);
        }
    }

    public void testIsRegistered() throws EETest.Fault {
        TestUtil.logMsg((String)"Starting testQueryNameSet2");
        Set mos = null;
        ObjectName search = null;
        Iterator moi = null;
        boolean notregistered = false;
        boolean b = false;
        try {
            search = new ObjectName(":*");
        }
        catch (MalformedObjectNameException e) {
            throw new EETest.Fault("FAILED: Couldn't create ObjectName: " + e.getMessage(), e);
        }
        try {
            mos = this.mejb.queryNames(search, null);
        }
        catch (RemoteException e) {
            throw new EETest.Fault("FAILED: RemoteException on test: " + e.getMessage(), e);
        }
        TestUtil.logMsg((String)"Scanning objects for isRegistered...");
        for (ObjectName on : mos) {
            try {
                b = this.mejb.isRegistered(on);
            }
            catch (RemoteException re) {
                throw new EETest.Fault("Caught exception calling getMBeanCount", re);
            }
            TestUtil.logMsg((String)("Object: " + on.toString() + ": " + b));
            if (b) continue;
            notregistered = true;
        }
        if (notregistered) {
            throw new EETest.Fault("Some objects returned by queryNames are not registered");
        }
    }

    public void testGetMBeanCount() throws EETest.Fault {
        Set mos = null;
        ObjectName search = null;
        Integer mbcount = null;
        TestUtil.logMsg((String)"Starting testQueryNameSet2");
        try {
            search = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException e) {
            throw new EETest.Fault("FAILED: Couldn't create ObjectName: " + e.getMessage(), e);
        }
        try {
            mos = this.mejb.queryNames(search, null);
        }
        catch (RemoteException e) {
            throw new EETest.Fault("FAILED: RemoteException on test: " + e.getMessage(), e);
        }
        try {
            mbcount = this.mejb.getMBeanCount();
        }
        catch (RemoteException re) {
            throw new EETest.Fault("Caught exception calling getMBeanCount", re);
        }
        if (!mbcount.equals(new Integer(mos.size()))) {
            throw new EETest.Fault("Sizes are not equal!");
        }
        TestUtil.logMsg((String)("Count is equal: " + mos.size()));
    }

    public void testGetMBeanInfo1() throws EETest.Fault {
        Set mos = null;
        ObjectName search = null;
        MBeanInfo mbi = null;
        TestUtil.logMsg((String)"Starting testQueryNameSet2");
        try {
            search = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException e) {
            throw new EETest.Fault("FAILED: Couldn't create ObjectName: " + e.getMessage(), e);
        }
        try {
            mos = this.mejb.queryNames(search, null);
        }
        catch (RemoteException e) {
            throw new EETest.Fault("FAILED: RemoteException on test: " + e.getMessage(), e);
        }
        try {
            Iterator i = mos.iterator();
            ObjectName on = (ObjectName)i.next();
            mbi = this.mejb.getMBeanInfo(on);
        }
        catch (Exception e) {
            throw new EETest.Fault("Caught exception calling getMBeanCount", e);
        }
    }

    public void testGetMBeanInfo2() throws EETest.Fault {
        Object mos = null;
        ObjectName search = null;
        MBeanInfo mbi = null;
        boolean gotexception = false;
        TestUtil.logMsg((String)"Starting testQueryNameSet2");
        try {
            search = new ObjectName("*:j2eeType=J2EEDomain,name=ThisDomainDoesNotExist");
        }
        catch (MalformedObjectNameException e) {
            throw new EETest.Fault("FAILED: Couldn't create ObjectName: " + e.getMessage(), e);
        }
        try {
            mbi = this.mejb.getMBeanInfo(search);
        }
        catch (InstanceNotFoundException ie) {
            TestUtil.logMsg((String)("Got expected exception: " + ie.getMessage()));
            gotexception = true;
        }
        catch (Exception e) {
            throw new EETest.Fault("Caught unexpected exception: ", e);
        }
        if (!gotexception) {
            throw new EETest.Fault("Did not catch expected exception");
        }
    }

    public void testGetAttribute1() throws EETest.Fault {
        Set mos = null;
        ObjectName search = null;
        Object mbi = null;
        boolean gotexception = false;
        TestUtil.logMsg((String)"Starting testQueryNameSet2");
        try {
            search = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException e) {
            throw new EETest.Fault("FAILED: Couldn't create ObjectName: " + e.getMessage());
        }
        try {
            mos = this.mejb.queryNames(search, null);
        }
        catch (RemoteException e) {
            throw new EETest.Fault("FAILED: RemoteException on test: " + e.getMessage());
        }
        try {
            Iterator i = mos.iterator();
            ObjectName on = (ObjectName)i.next();
            Object object = this.mejb.getAttribute(on, "NonExistentAttribute");
        }
        catch (AttributeNotFoundException anfe) {
            TestUtil.logMsg((String)("Received expected exception: " + anfe.getMessage()));
            gotexception = true;
        }
        catch (Exception e) {
            throw new EETest.Fault("Caught exception calling getAttribute", e);
        }
        if (!gotexception) {
            throw new EETest.Fault("Did not catch expected exception");
        }
    }

    public void testGetAttribute2() throws EETest.Fault {
        Set mos = null;
        ObjectName search = null;
        Object mbi = null;
        boolean gotexception = false;
        TestUtil.logMsg((String)"Starting testQueryNameSet2");
        try {
            search = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException e) {
            throw new EETest.Fault("FAILED: Couldn't create ObjectName: " + e.getMessage(), e);
        }
        try {
            mos = this.mejb.queryNames(search, null);
        }
        catch (RemoteException e) {
            throw new EETest.Fault("FAILED: RemoteException on test: " + e.getMessage(), e);
        }
        try {
            Iterator i = mos.iterator();
            ObjectName on = (ObjectName)i.next();
            Object object = this.mejb.getAttribute(on, "NonExistentAttribute");
        }
        catch (AttributeNotFoundException anfe) {
            TestUtil.logMsg((String)("Received expected exception: " + anfe.getMessage()));
            gotexception = true;
        }
        catch (Exception e) {
            throw new EETest.Fault("Caught exception calling getAttribute", e);
        }
        if (!gotexception) {
            throw new EETest.Fault("Did not catch expected exception");
        }
    }

    public void testGetAttributes1() throws EETest.Fault {
        Set mos = null;
        ObjectName search = null;
        Object mbi = null;
        boolean gotexception = false;
        TestUtil.logMsg((String)"Starting testQueryNameSet2");
        try {
            search = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException e) {
            throw new EETest.Fault("FAILED: Couldn't create ObjectName: " + e.getMessage());
        }
        try {
            mos = this.mejb.queryNames(search, null);
        }
        catch (RemoteException e) {
            throw new EETest.Fault("FAILED: RemoteException on test: " + e.getMessage());
        }
        try {
            Iterator i = mos.iterator();
            ObjectName on = (ObjectName)i.next();
            Object object = this.mejb.getAttribute(on, "NonExistentAttribute");
        }
        catch (AttributeNotFoundException anfe) {
            TestUtil.logMsg((String)("Received expected exception: " + anfe.getMessage()));
            gotexception = true;
        }
        catch (Exception e) {
            throw new EETest.Fault("Caught exception calling getAttribute", e);
        }
        if (!gotexception) {
            throw new EETest.Fault("Did not catch expected exception");
        }
    }

    public void testGetAttributes2() throws EETest.Fault {
        Set mos = null;
        ObjectName search = null;
        Object mbi = null;
        boolean gotexception = false;
        TestUtil.logMsg((String)"Starting testQueryNameSet2");
        try {
            search = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException e) {
            throw new EETest.Fault("FAILED: Couldn't create ObjectName: " + e.getMessage(), e);
        }
        try {
            mos = this.mejb.queryNames(search, null);
        }
        catch (RemoteException e) {
            throw new EETest.Fault("FAILED: RemoteException on test: " + e.getMessage(), e);
        }
        try {
            Iterator i = mos.iterator();
            ObjectName on = (ObjectName)i.next();
            Object object = this.mejb.getAttribute(on, "NonExistentAttribute");
        }
        catch (AttributeNotFoundException anfe) {
            TestUtil.logMsg((String)("Received expected exception: " + anfe.getMessage()));
            gotexception = true;
        }
        catch (Exception e) {
            throw new EETest.Fault("Caught exception calling getAttribute", e);
        }
        if (!gotexception) {
            throw new EETest.Fault("Did not catch expected exception");
        }
    }

    public void testGetDefaultDomain() throws EETest.Fault {
        Set mos = null;
        ObjectName search = null;
        Object mbi = null;
        boolean gotexception = false;
        TestUtil.logMsg((String)"Starting testQueryNameSet2");
        try {
            search = new ObjectName("*:*");
        }
        catch (MalformedObjectNameException e) {
            throw new EETest.Fault("FAILED: Couldn't create ObjectName: " + e.getMessage());
        }
        try {
            mos = this.mejb.queryNames(search, null);
        }
        catch (RemoteException e) {
            throw new EETest.Fault("FAILED: RemoteException on test: " + e.getMessage());
        }
        try {
            Iterator i = mos.iterator();
            ObjectName on = (ObjectName)i.next();
            Object object = this.mejb.getAttribute(on, "NonExistentAttribute");
        }
        catch (AttributeNotFoundException anfe) {
            TestUtil.logMsg((String)("Received expected exception: " + anfe.getMessage()));
            gotexception = true;
        }
        catch (Exception e) {
            throw new EETest.Fault("Caught exception calling getAttribute", e);
        }
        if (!gotexception) {
            throw new EETest.Fault("Did not catch expected exception");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"cleanup() invoked");
        try {
            this.mejb.remove();
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Error removing MEJB reference: " + e.getMessage()), (Throwable)e);
        }
    }
}

