/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices.wsdlImport.file.nested2;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.webservices.wsdlImport.file.nested2.GetLastTradePrice;
import com.sun.ts.tests.webservices.wsdlImport.file.nested2.StockQuotePortType;
import com.sun.ts.tests.webservices.wsdlImport.file.nested2.TradePrice;
import java.util.Properties;
import javax.naming.InitialContext;
import javax.xml.rpc.Service;

public class Client
extends ServiceEETest {
    StockQuotePortType port = null;

    private void getStub() throws Exception {
        TestUtil.logMsg((String)"JNDI lookup for Service1");
        InitialContext ctx = new InitialContext();
        Service svc = (Service)ctx.lookup("java:comp/env/service/nested2");
        TestUtil.logMsg((String)"Get port from Service1");
        this.port = (StockQuotePortType)svc.getPort(StockQuotePortType.class);
        TestUtil.logMsg((String)"Port obtained");
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            this.getStub();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void invokeNestedImportWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"invokeNestedImportWsdl");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Invoke getLastTradePrice(\"GTE\") and expect 24.25");
            GetLastTradePrice glt = new GetLastTradePrice();
            glt.setTickerSymbol("GTE");
            TradePrice response = this.port.getLastTradePrice(glt);
            if (response.getPrice() != 24.25f) {
                TestUtil.logErr((String)("RPC failed - expected: \"24.25\", received: " + response.getPrice()));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
            TestUtil.logMsg((String)"Invoke getLastTradePrice(\"GE\") and expect 45.5");
            glt.setTickerSymbol("GE");
            response = this.port.getLastTradePrice(glt);
            if (response.getPrice() != 45.5f) {
                TestUtil.logErr((String)("RPC failed - expected: \"45.5\", received: " + response.getPrice()));
                pass = false;
            } else {
                TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("invokeNestedImportWsdl");
        }
        if (!pass) {
            throw new EETest.Fault("invokeNestedImportWsdl failed");
        }
    }
}

