/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices.deploy.ServicePW;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Data;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import com.sun.ts.tests.webservices.deploy.ServicePW.Tests;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private final String NAMESPACEURI = "http://testsservicepw.org/wsdl";
    private QName SERVICE_QNAME;
    private QName PORT_QNAME;
    private QName BAD_PORT_QNAME;
    private QName QNAME_TYPE_STRING;
    private String SERVICE_NAME_WITH_PARTIAL_WSDL = "service";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private static final String ENDPOINT_URL = "servicepw.endpoint.1";
    private String url = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get JAXRPC porting instance");
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        this.SERVICE_QNAME = new QName("http://testsservicepw.org/wsdl", "TestsServicePW");
        this.PORT_QNAME = new QName("http://testsservicepw.org/wsdl", "TestsPort");
        this.BAD_PORT_QNAME = new QName("http://testsservicepw.org/wsdl", "BadPort");
        this.QNAME_TYPE_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string");
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                pass = false;
            }
            this.getTestURLs();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void CreateCallConstructor1Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor1Test1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with partial WSDL");
            Service service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_PARTIAL_WSDL);
            TestUtil.logMsg((String)"Create Call object via Service.createCall()");
            Call call = service.createCall();
            if (call == null) {
                TestUtil.logErr((String)"createCall() returned null");
                pass = false;
            } else if (!(call instanceof Call)) {
                TestUtil.logErr((String)"createCall() did not return instance of Call object");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Call object successfully created");
                TestUtil.logMsg((String)"Fillin rest of Call object and invoke RPC method");
                call = JAXRPC_Util.setCallProperties(call, " ");
                call.setTargetEndpointAddress(this.url);
                TestUtil.logMsg((String)"Set operation name to InvokeTest2");
                call.setOperationName(new QName("http://testsservicepw.org/wsdl", "invokeTest2"));
                boolean b = call.isParameterAndReturnSpecRequired(new QName("http://testsservicepw.org/wsdl", "invokeTest2"));
                if (b) {
                    call.setReturnType(this.QNAME_TYPE_STRING);
                    call.addParameter("BigInteger_1", new QName("http://www.w3.org/2001/XMLSchema", "integer"), ParameterMode.IN);
                    call.addParameter("BigDecimal_2", new QName("http://www.w3.org/2001/XMLSchema", "decimal"), ParameterMode.IN);
                    call.addParameter("QName_3", new QName("http://www.w3.org/2001/XMLSchema", "QName"), ParameterMode.IN);
                    call.addParameter("String_4", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
                }
                Object[] params = new Object[]{JAXRPC_Data.BigInteger_data[0], JAXRPC_Data.BigDecimal_data[0], JAXRPC_Data.QName_data[0], JAXRPC_Data.String_data[0]};
                TestUtil.logMsg((String)"Attempt to invoke RPC method Tests(\"InvokeTest2\")");
                String expected = "passed";
                String response = (String)call.invoke(params);
                if (!response.equals(expected)) {
                    TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor1Test1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor1Test1 failed");
        }
    }

    public void GetPortConstructor2PosTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor2PosTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test getPort (valid SEI class/WSDL access) - positive test 1");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with partial WSDL");
            Service service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_PARTIAL_WSDL);
            TestUtil.logMsg((String)"Call Service.getPort(Class)");
            TestUtil.logMsg((String)"Should find port");
            Tests tests = (Tests)service.getPort(Tests.class);
            if (tests == null) {
                TestUtil.logErr((String)"getPort(Class) returned null");
                pass = false;
            } else if (!(tests instanceof Tests)) {
                TestUtil.logErr((String)"getPort(Class) did not return instance of Tests");
                pass = false;
            }
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught ServiceException");
            pass = false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor2PosTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor2PosTest1 failed");
        }
    }

    public void GetPortConstructor2NegTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor2NegTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test getPort (invalid SEI class/WSDL access) - negative test 1");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with partial WSDL");
            Service service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_PARTIAL_WSDL);
            TestUtil.logMsg((String)"Call Service.getPort(Class)");
            TestUtil.logMsg((String)"Should not find port (expect ServiceException)");
            Tests tests = (Tests)service.getPort(Pattern.class);
            TestUtil.logErr((String)"Did not throw expected ServiceException");
            pass = false;
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught expected ServiceException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor2NegTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor2NegTest1 failed");
        }
    }

    public void GetPortsTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortsTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test getPorts with (WSDL access) - positive test 1");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with partial WSDL");
            Service service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_PARTIAL_WSDL);
            TestUtil.logMsg((String)"Call Service.getPorts()");
            Iterator i = service.getPorts();
            if (!i.hasNext()) {
                TestUtil.logErr((String)"getPorts() returned empty iterator (unexpected)");
                pass = false;
            } else {
                int count = 0;
                while (i.hasNext()) {
                    i.next();
                    ++count;
                }
                if (count != 1) {
                    TestUtil.logErr((String)("getPorts() returned wrong iterator count, got " + count + ", expected 1"));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortsTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortsTest1 failed");
        }
    }

    public void GetServiceNameTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetServiceNameTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with partial WSDL");
            Service service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_PARTIAL_WSDL);
            TestUtil.logMsg((String)"Create Call object via Service.createCall()");
            Call call = service.createCall();
            TestUtil.logMsg((String)"Get service name via Service.getServiceName()");
            TestUtil.logMsg((String)"Expect an (UnsupportedOperationException)");
            QName sname = service.getServiceName();
            TestUtil.logMsg((String)("ServiceName = " + this.SERVICE_QNAME + "\ngetServiceName() = " + sname));
            if (!sname.equals(this.SERVICE_QNAME)) {
                TestUtil.logErr((String)"getServiceName() returned wrong QName");
                TestUtil.logErr((String)("Expected " + this.SERVICE_QNAME + "\nGot " + sname));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
            throw new EETest.Fault("GetServiceNameTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetServiceNameTest1 failed");
        }
    }

    public void GetTypeMappingRegistryTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetTypeMappingRegistryTest1");
        boolean pass = false;
        TypeMappingRegistry tmrRegistry = null;
        Service service = null;
        try {
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with partial WSDL");
            service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_PARTIAL_WSDL);
            TestUtil.logMsg((String)"Call Service.getTypeMappingRegistry()");
            tmrRegistry = service.getTypeMappingRegistry();
            if (tmrRegistry == null) {
                TestUtil.logMsg((String)"No TypeMappingRegistry defined on Service object (returned null)");
            } else {
                TestUtil.logMsg((String)("TypeMappingRegistry defined on Service object (returned = " + tmrRegistry + ")"));
            }
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            pass = true;
        }
        catch (JAXRPCException e) {
            TestUtil.logErr((String)"Caught unexpected JAXRPCException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetTypeMappingRegistryTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetTypeMappingRegistryTest1 failed");
        }
    }

    public void GetHandlerRegistryTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetHandlerRegistryTest1");
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with partial WSDL");
            Service service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_PARTIAL_WSDL);
            TestUtil.logMsg((String)"Call Service.getHandlerRegistry()");
            HandlerRegistry hr = service.getHandlerRegistry();
            if (hr == null) {
                TestUtil.logMsg((String)"No HandlerRegistry defined on Service object (returned null)");
            } else {
                TestUtil.logMsg((String)("HandlerRegistry defined on Service object (returned = " + hr + ")"));
            }
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetHandlerRegistryTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetHandlerRegistryTest1 failed");
        }
    }

    public void GetWSDLDocumentTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetWSDLDocumentTest1");
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with partial WSDL");
            Service service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_PARTIAL_WSDL);
            TestUtil.logMsg((String)"Call Service.getWSDLDocumentLocation()");
            URL url = service.getWSDLDocumentLocation();
            if (url == null) {
                TestUtil.logMsg((String)"getWSDLDocumentLocation() returned NULL");
            } else {
                TestUtil.logMsg((String)("getWSDLDocumentLocation() returned " + url.toString()));
                pass = true;
            }
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught UnsupportedOperationException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetWSDLDocumentTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetWSDLDocumentTest1 failed");
        }
    }
}

