/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices.handlerEjb.HandlerSec;

import com.sun.ts.tests.jaxrpc.common.HandlerBase;
import com.sun.ts.tests.jaxrpc.common.HandlerTracker;
import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.handler.MessageContext;
import javax.xml.rpc.handler.soap.SOAPMessageContext;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.Text;

public class ServerHandler
extends HandlerBase {
    private boolean debug = true;

    @Override
    public boolean handleRequest(MessageContext context) {
        boolean result = false;
        try {
            this.preinvoke();
            HandlerTracker.put("HandlerClassLoader", this.getClass().getClassLoader());
            this.updateMessage(context, true);
            result = super.handleRequest(context);
        }
        finally {
            this.postinvoke();
        }
        return result;
    }

    @Override
    public boolean handleResponse(MessageContext context) {
        this.updateMessage(context, false);
        return super.handleResponse(context);
    }

    protected void printMsg(MessageContext context) {
        try {
            SOAPMessage msg = ((SOAPMessageContext)context).getMessage();
            SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
            SOAPBody body = env.getBody();
            Iterator it = body.getChildElements();
            while (it.hasNext()) {
                SOAPElement elem = (SOAPElement)it.next();
                this.printElem(elem, "  ");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void printElem(SOAPElement elem, String indent) {
        try {
            String elemName = elem.getElementName().getQualifiedName();
            System.out.println(indent + "<" + elemName + " ");
            Iterator it = elem.getAllAttributes();
            while (it.hasNext()) {
                Name attr = (Name)it.next();
                System.out.println(indent + "    " + attr.getQualifiedName() + "=" + elem.getAttributeValue(attr));
            }
            System.out.println(indent + ">");
            it = elem.getChildElements();
            while (it.hasNext()) {
                Node child = (Node)it.next();
                if (child instanceof SOAPElement) {
                    this.printElem((SOAPElement)child, indent + "  ");
                    continue;
                }
                if (!(child instanceof Text)) continue;
                System.out.println(indent + "  " + child.getValue());
            }
            System.out.println(indent + "</" + elemName + ">");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void updateMessage(MessageContext context, boolean forRequest) {
        try {
            SOAPMessage msg = ((SOAPMessageContext)context).getMessage();
            SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
            SOAPBody body = env.getBody();
            String value = this.getEchoStringValue(body);
            if (value != null) {
                if (forRequest && value.indexOf("request") >= 0) {
                    if (this.debug) {
                        System.out.println("-----------------------------");
                        System.out.println("Original SOAP Message Request");
                        System.out.println("-----------------------------");
                        msg.writeTo((OutputStream)System.out);
                        System.out.println("\n");
                    }
                    if (value.indexOf("change_value") >= 0) {
                        this.updateValue(body, value + "_PASS");
                    } else if (value.indexOf("add_element") >= 0) {
                        this.addElement(body);
                    } else if (value.indexOf("change_element") >= 0) {
                        this.changeElementName(body);
                    } else if (value.indexOf("change_message") >= 0) {
                        this.changeMessage(body);
                    }
                    if (this.debug) {
                        System.out.println("-----------------------------");
                        System.out.println("Modified SOAP Message Request");
                        System.out.println("-----------------------------");
                        msg.writeTo((OutputStream)System.out);
                        System.out.println("\n");
                    }
                } else if (!forRequest && value.indexOf("response") >= 0) {
                    if (this.debug) {
                        System.out.println("------------------------------");
                        System.out.println("Original SOAP Message Response");
                        System.out.println("------------------------------");
                        msg.writeTo((OutputStream)System.out);
                        System.out.println("\n");
                    }
                    if (value.indexOf("change_value") >= 0) {
                        this.updateValue(body, value + "_PASS");
                    } else if (value.indexOf("add_element") >= 0) {
                        this.addElement(body);
                    } else if (value.indexOf("change_element") >= 0) {
                        this.changeElementName(body);
                    } else if (value.indexOf("change_message") >= 0) {
                        this.changeMessage(body);
                    }
                    if (this.debug) {
                        System.out.println("------------------------------");
                        System.out.println("Modified SOAP Message Response");
                        System.out.println("------------------------------");
                        msg.writeTo((OutputStream)System.out);
                        System.out.println("\n");
                    }
                }
            }
            msg.saveChanges();
        }
        catch (Exception e) {
            throw new JAXRPCException("updateMessage() through exception: ", (Throwable)e);
        }
    }

    protected String getEchoStringValue(SOAPBody body) {
        String value = null;
        try {
            Iterator it = body.getChildElements();
            SOAPElement elem = (SOAPElement)it.next();
            if (elem.getElementName().getLocalName().indexOf("echoString") >= 0) {
                Iterator it2 = elem.getChildElements();
                SOAPElement arg = (SOAPElement)it2.next();
                value = arg.getValue();
            }
        }
        catch (Exception e) {
            throw new JAXRPCException("getEchoStringValue() through exception: ", (Throwable)e);
        }
        return value;
    }

    protected void updateValue(SOAPBody body, String newValue) {
        try {
            Iterator it = body.getChildElements();
            SOAPElement elem = (SOAPElement)it.next();
            if (elem.getElementName().getLocalName().indexOf("echoString") >= 0) {
                Iterator it2 = elem.getChildElements();
                SOAPElement arg = (SOAPElement)it2.next();
                Iterator it3 = arg.getChildElements();
                Text text = (Text)it3.next();
                text.detachNode();
                arg.addTextNode(newValue);
            }
        }
        catch (Exception e) {
            throw new JAXRPCException("updateValue() through exception: ", (Throwable)e);
        }
    }

    protected void addElement(SOAPBody body) {
        try {
            Iterator it = body.getChildElements();
            SOAPElement elem = (SOAPElement)it.next();
            if (elem.getElementName().getLocalName().indexOf("echoString") >= 0) {
                Iterator it2 = elem.getChildElements();
                SOAPElement arg = (SOAPElement)it2.next();
                Iterator it3 = arg.getChildElements();
                Text text = (Text)it3.next();
                String value = text.getValue();
                SOAPElement newArg = elem.addChildElement("badParm");
                newArg.addTextNode(value);
            }
        }
        catch (Exception e) {
            throw new JAXRPCException("addElement() through exception: ", (Throwable)e);
        }
    }

    protected void changeElementName(SOAPBody body) {
        try {
            Iterator it = body.getChildElements();
            SOAPElement elem = (SOAPElement)it.next();
            if (elem.getElementName().getLocalName().indexOf("echoString") >= 0) {
                Iterator it2 = elem.getChildElements();
                SOAPElement arg = (SOAPElement)it2.next();
                arg.detachNode();
                Iterator it3 = arg.getChildElements();
                Text text = (Text)it3.next();
                String value = text.getValue();
                SOAPElement newArg = elem.addChildElement("badParm");
                newArg.addTextNode(value);
            }
        }
        catch (Exception e) {
            throw new JAXRPCException("changeElementName() through exception: ", (Throwable)e);
        }
    }

    protected void changeMessage(SOAPBody body) {
        try {
            Iterator it = body.getChildElements();
            SOAPElement elem = (SOAPElement)it.next();
            if (elem.getElementName().getLocalName().indexOf("echoString") >= 0) {
                elem.detachNode();
                Iterator it2 = elem.getChildElements();
                SOAPElement arg = (SOAPElement)it2.next();
                arg.detachNode();
                String localName = "badEchoString";
                if (elem.getElementName().getLocalName().indexOf("Response") >= 0) {
                    localName = localName + "Response";
                }
                SOAPElement newElem = body.addChildElement(localName, elem.getElementName().getPrefix());
                newElem.addChildElement(arg);
            }
        }
        catch (Exception e) {
            throw new JAXRPCException("changeMessage() through exception: ", (Throwable)e);
        }
    }
}

