/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.persistenceUtilUtil;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.persistenceUtilUtil.Employee;
import java.util.Properties;
import javax.persistence.PersistenceUnitUtil;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void getPersistenceUtilUtilTest() throws EETest.Fault {
        boolean pass = false;
        PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
        if (puu != null) {
            pass = true;
        } else {
            TestUtil.logErr((String)"getPersistenceUtil() returned null");
        }
        if (!pass) {
            throw new EETest.Fault("getPersistenceUtilUtilTest failed");
        }
    }

    public void getIdentifierTest() throws EETest.Fault {
        Integer id;
        PersistenceUnitUtil puu;
        boolean pass = true;
        Employee emp = new Employee(1, "foo", "bar", this.getSQLDate("2000-02-14"), 35000.0f);
        TestUtil.logMsg((String)"Test entity not yet persisted");
        try {
            puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            id = (Integer)puu.getIdentifier((Object)emp);
            if (id == null || id != 1) {
                TestUtil.logErr((String)("expected a null or id: 1, actual id:" + id));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        TestUtil.logMsg((String)"Test entity persisted");
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().persist((Object)emp);
            puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            id = (Integer)puu.getIdentifier((Object)emp);
            if (id != 1) {
                TestUtil.logErr((String)("expected a null or id: 1, actual id:" + id));
                pass = false;
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        if (!pass) {
            throw new EETest.Fault("getIdentifierTest failed");
        }
    }

    public void getIdentifierIllegalArgumentExceptionTest() throws EETest.Fault {
        boolean pass = false;
        try {
            PersistenceUnitUtil puu = this.getEntityManager().getEntityManagerFactory().getPersistenceUnitUtil();
            puu.getIdentifier((Object)this);
            TestUtil.logErr((String)"IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException iae) {
            pass = true;
            TestUtil.logTrace((String)"Received expected IllegalArgumentException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("getIdentifierIllegalArgumentExceptionTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM EMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

