/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.api.annotation;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.api.model.SimpleAnnotatedAdaptedContainer;
import com.sun.ts.tests.jsonb.api.model.SimpleAnnotatedDateContainer;
import com.sun.ts.tests.jsonb.api.model.SimpleAnnotatedDoubleContainer;
import com.sun.ts.tests.jsonb.api.model.SimpleAnnotatedNillableContainer;
import com.sun.ts.tests.jsonb.api.model.SimpleAnnotatedNillablePropertyContainer;
import com.sun.ts.tests.jsonb.api.model.SimpleAnnotatedPropertyOrderContainer;
import com.sun.ts.tests.jsonb.api.model.SimpleAnnotatedPropertyVisibilityContainer;
import com.sun.ts.tests.jsonb.api.model.SimpleAnnotatedSerializedArrayContainer;
import com.sun.ts.tests.jsonb.api.model.SimpleAnnotatedSerializedContainer;
import com.sun.ts.tests.jsonb.api.model.SimpleContainer;
import com.sun.ts.tests.jsonb.api.model.SimplePartiallyAnnotatedPropertyOrderContainer;
import java.util.Properties;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

public class AnnotationTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        AnnotationTest t = new AnnotationTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testJsonbDateFormat() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedDateContainer());
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Do(\\.?), 01 Jan(\\.?) 1970\"\\s*}")) {
            throw new EETest.Fault("Failed to customize date format using JsonbDateFormat annotation.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonbNillable() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedNillableContainer());
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*null\\s*}")) {
            throw new EETest.Fault("Failed to enable serialization of null values using JsonbNillable annotation.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonbNumberFormat() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedDoubleContainer());
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"123.456,8\"\\s*}")) {
            throw new EETest.Fault("Failed to customize number format using JsonbNumberFormat annotation.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonbProperty() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedNillablePropertyContainer());
        if (!jsonString.matches("\\{\\s*\"nillableInstance\"\\s*:\\s*null\\s*}")) {
            throw new EETest.Fault("Failed to customize property name and enable serialization of null values using JsonbProperty annotation.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonbPropertyOrder() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedPropertyOrderContainer());
        if (!jsonString.matches("\\{\\s*\"secondInstance\"\\s*:\\s*\"Second String\"\\s*,\\s*\"firstInstance\"\\s*:\\s*\"First String\"\\s*}")) {
            throw new EETest.Fault("Failed to customize the order in which fields will be serialized using JsonbPropertyOrder annotation.");
        }
        return Status.passed((String)"OK");
    }

    public void testJsonbPropertyPartialOrder() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new SimplePartiallyAnnotatedPropertyOrderContainer());
        if (!jsonString.matches("\\{\\s*\"thirdInstance\"\\s*:\\s*\"Third String\"\\s*,\\s*\"fourthInstance\"\\s*:\\s*\"Fourth String\".*}")) {
            System.out.append("Got JSON: ").println(jsonString);
            throw new EETest.Fault("Failed to order the fields partially defined using JsonbPropertyOrder annotation.");
        }
    }

    public Status testJsonbTypeAdapter() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedAdaptedContainer(){
            {
                this.setInstance(new SimpleContainer(){
                    {
                        this.setInstance("Test String");
                    }
                });
            }
        });
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String Adapted\"\\s*}\\s*}")) {
            throw new EETest.Fault("Failed to configure a JsonbAdapter implementation to provide custom mapping using JsonbTypeAdapter annotation.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonbTypeSerializer() throws EETest.Fault {
        SimpleAnnotatedSerializedContainer container = new SimpleAnnotatedSerializedContainer();
        SimpleContainer instance = new SimpleContainer();
        instance.setInstance("Test String");
        container.setInstance(instance);
        String jsonString = this.jsonb.toJson((Object)container);
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String Serialized\"\\s*}\\s*}")) {
            throw new EETest.Fault("Failed to configure a JsonbSerializer implementation to provide custom mapping using JsonbTypeSerializer annotation.");
        }
        SimpleAnnotatedSerializedContainer unmarshalledObject = (SimpleAnnotatedSerializedContainer)this.jsonb.fromJson("{ \"instance\" : { \"instance\" : \"Test String\" } }", SimpleAnnotatedSerializedContainer.class);
        if (!"Test String Deserialized".equals(unmarshalledObject.getInstance().getInstance())) {
            throw new EETest.Fault("Failed to configure a JsonbDeserializer implementation to provide custom mapping using JsonbTypeDeserializer annotation.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonbArrayTypeSerializer() throws EETest.Fault {
        SimpleAnnotatedSerializedArrayContainer container = new SimpleAnnotatedSerializedArrayContainer();
        SimpleContainer instance1 = new SimpleContainer();
        instance1.setInstance("Test String 1");
        SimpleContainer instance2 = new SimpleContainer();
        instance2.setInstance("Test String 2");
        container.setInstance(new SimpleContainer[]{instance1, instance2});
        String jsonString = this.jsonb.toJson((Object)container);
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\\[\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String 1\"\\s*}\\s*,\\s*\\{\\s*\"instance\"\\s*:\\s*\"Test String 2\"\\s*}\\s*]\\s*}")) {
            throw new EETest.Fault("Failed to configure a JsonbSerializer implementation to provide custom mapping using JsonbTypeSerializer annotation.");
        }
        SimpleAnnotatedSerializedArrayContainer unmarshalledObject = (SimpleAnnotatedSerializedArrayContainer)this.jsonb.fromJson("{ \"instance\" : [ { \"instance\" : \"Test String 1\" }, { \"instance\" : \"Test String 2\" } ] }", SimpleAnnotatedSerializedArrayContainer.class);
        if (!"Test String 1".equals(unmarshalledObject.getInstance()[0].getInstance())) {
            throw new EETest.Fault("Failed to configure a JsonbDeserializer implementation to provide custom mapping using JsonbTypeDeserializer annotation.");
        }
        return Status.passed((String)"OK");
    }

    public Status testJsonbVisibility() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new SimpleAnnotatedPropertyVisibilityContainer());
        if (!jsonString.matches("\\{\\s*\"secondInstance\"\\s*:\\s*\"Second String\"\\s*}")) {
            throw new EETest.Fault("Failed to customize fields visibility using JsonbVisibility annotation.");
        }
        return Status.passed((String)"OK");
    }
}

