/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R2113;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jaxrpc.sharedclients.ClientFactory;
import com.sun.ts.tests.jaxrpc.wsi.requests.SOAPRequests;
import com.sun.ts.tests.jaxrpc.wsi.w2j.rpc.literal.R2113.W2JRLR2113Client;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class Client
extends ServiceEETest
implements SOAPRequests {
    private W2JRLR2113Client client;

    public static void main(String[] args) {
        Client tests = new Client();
        Status status = tests.run(args, System.out, System.err);
        status.exit();
    }

    public void setup(String[] args, Properties properties) throws EETest.Fault {
        this.client = (W2JRLR2113Client)ClientFactory.getClient(W2JRLR2113Client.class, properties);
        this.logMsg("setup ok");
    }

    public void cleanup() {
        this.logMsg("cleanup");
    }

    public void testNoArrayTypeInResponse() throws EETest.Fault {
        SOAPMessage response = null;
        try {
            response = this.client.makeSaajRequest("<?xml version='1.0' encoding='UTF-8'?><!-- Copyright (c) 2003 Oracle Corporation.  All rights reserved. --><env:Envelope xmlns:env='http://schemas.xmlsoap.org/soap/envelope/' xmlns:xsd='http://www.w3.org/2001/XMLSchema' xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance' xmlns:enc='http://schemas.xmlsoap.org/soap/encoding/' xmlns:ns0='http://simpletestservice.org/wsdl' xmlns:ns1='http://simpletestservice.org/types'><env:Body><ns0:arrayOperation/></env:Body></env:Envelope>");
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        try {
            this.validateNoArrayType(response);
        }
        catch (SOAPException se) {
            throw new EETest.Fault("Error creating response object", se);
        }
        this.client.logMessageInHarness(response);
    }

    public void testNoArrayTypeInRequest() throws EETest.Fault {
        String response = "";
        try {
            response = this.client.arrayOperationFromClient(new String[]{"one", "two", "three"});
        }
        catch (Exception e) {
            throw new EETest.Fault("Test didn't complete properly: ", e);
        }
        if (response.startsWith("failed")) {
            throw new EETest.Fault(response);
        }
    }

    private void validateNoArrayType(SOAPMessage response) throws EETest.Fault, SOAPException {
        String prefix = this.getSOAPEncodingNamespacePrefix((SOAPElement)response.getSOAPPart().getEnvelope().getBody());
        if (prefix == null) {
            prefix = this.getSOAPEncodingNamespacePrefix((SOAPElement)response.getSOAPPart().getEnvelope());
        }
        if (prefix != null) {
            Name soapEncArrayType = response.getSOAPPart().getEnvelope().createName("arrayType", prefix, "http://schemas.xmlsoap.org/soap/encoding/");
            String soapEncArrayTypeValue = response.getSOAPPart().getEnvelope().getBody().getAttributeValue(soapEncArrayType);
            if (soapEncArrayTypeValue == null || soapEncArrayTypeValue.equals("")) {
                soapEncArrayTypeValue = response.getSOAPPart().getEnvelope().getAttributeValue(soapEncArrayType);
            }
            if (soapEncArrayTypeValue != null && !soapEncArrayTypeValue.equals("")) {
                this.client.logMessageInHarness(response);
                throw new EETest.Fault("Invalid element: messages may not use a soapEnc:arrayType attribute (BP-R2113)");
            }
        }
    }

    private String getSOAPEncodingNamespacePrefix(SOAPElement element) {
        Iterator attributes = element.getNamespacePrefixes();
        String prefix = null;
        boolean done = false;
        while (attributes.hasNext() && !done) {
            prefix = (String)attributes.next();
            if (!element.getNamespaceURI(prefix).equals("http://schemas.xmlsoap.org/soap/encoding/")) continue;
            done = true;
        }
        return prefix;
    }
}

