/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.appclient.deploy.ejblink.single;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.assembly.util.shared.ejbref.single.TestCode;
import com.sun.ts.tests.common.dao.DAOFactory;
import java.util.Properties;

public class Client
extends EETest {
    private TSNamingContext nctx = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties props) throws EETest.Fault {
        try {
            this.props = props;
            this.logTrace("[Client] Getting naming context...");
            this.nctx = new TSNamingContext();
            this.logTrace("[Client] Initializing BMP table...");
            DAOFactory.getInstance().getCoffeeDAO().cleanup();
            this.logMsg("[Client] Setup succeed (got naming context).");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void testStateless() throws EETest.Fault {
        try {
            boolean pass = TestCode.testStatelessExternal(this.nctx, this.props);
            if (!pass) {
                throw new EETest.Fault("ejb-link test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ejb-link test failed: " + e, e);
        }
    }

    public void testStateful() throws EETest.Fault {
        try {
            boolean pass = TestCode.testStatefulExternal(this.nctx, this.props);
            if (!pass) {
                throw new EETest.Fault("ejb-link test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ejb-link test failed: " + e, e);
        }
        finally {
            try {
                TestCode.cleanUpStatefulBean();
            }
            catch (Exception e) {
                TestUtil.logTrace((String)"Exception caught removing Stateful Session Bean");
            }
        }
    }

    public void testBMP() throws EETest.Fault {
        try {
            boolean pass = TestCode.testBMPExternal(this.nctx, this.props);
            if (!pass) {
                throw new EETest.Fault("ejb-link test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ejb-link test failed: " + e, e);
        }
    }

    public void testCMP11() throws EETest.Fault {
        try {
            boolean pass = TestCode.testCMP11External(this.nctx, this.props);
            if (!pass) {
                throw new EETest.Fault("ejb-link test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ejb-link test failed: " + e, e);
        }
    }

    public void testCMP20() throws EETest.Fault {
        try {
            boolean pass = TestCode.testCMP20External(this.nctx, this.props);
            if (!pass) {
                throw new EETest.Fault("ejb-link test failed!");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("ejb-link test failed: " + e, e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("[Client] cleanup()");
    }
}

