/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxrpc.api.javax_xml_rpc.Service;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.api.javax_xml_rpc.Service.Hello;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Data;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.Service;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private static final String MODEPROP = "platform.mode";
    String modeProperty = null;
    private static final String PKG_NAME = "com.sun.ts.tests.jaxrpc.api.javax_xml_rpc.Service.";
    private final String NAMESPACEURI = "http://helloservice.org/wsdl";
    private QName SERVICE_QNAME;
    private QName PORT_QNAME;
    private QName BAD_PORT_QNAME;
    private QName QNAME_TYPE_STRING;
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private static final String ENDPOINT_URL = "helloservice.endpoint.1";
    private static final String WSDLLOC_URL = "helloservice.wsdlloc.1";
    private String url = null;
    private URL wsdlurl = null;
    private String SERVICE_NAME_WITH_WSDL = "service";
    private String SERVICE_NAME_NO_WSDL = "service_no_wsdl";

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        file = JAXRPC_Util.getURLFromProp(WSDLLOC_URL);
        this.wsdlurl = this.ctsurl.getURL(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
        TestUtil.logMsg((String)("WSDL Location URL:    " + this.wsdlurl));
    }

    private void getTestDIIURLs() throws Exception {
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        this.SERVICE_QNAME = new QName("http://helloservice.org/wsdl", "HelloService");
        this.PORT_QNAME = new QName("http://helloservice.org/wsdl", "HelloPort");
        this.BAD_PORT_QNAME = new QName("http://helloservice.org/wsdl", "BadPort");
        this.QNAME_TYPE_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string");
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            this.modeProperty = p.getProperty(MODEPROP);
            if (this.modeProperty.equals("standalone")) {
                this.getTestURLs();
            } else {
                this.getTestDIIURLs();
            }
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void CreateCallConstructor1Test1NoWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor1Test1NoWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_NO_WSDL);
            }
            TestUtil.logMsg((String)"Create Call object via Service.createCall()");
            Call call = service.createCall();
            if (call == null) {
                TestUtil.logErr((String)"createCall() returned null");
                pass = false;
            } else if (!(call instanceof Call)) {
                TestUtil.logErr((String)"createCall() did not return instance of Call object");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Call object successfully created");
                TestUtil.logMsg((String)"Fillin rest of Call object and invoke RPC method");
                call = JAXRPC_Util.setCallProperties(call, " ");
                call.setTargetEndpointAddress(this.url);
                TestUtil.logMsg((String)"Set operation name to invokeTest2");
                call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeTest2"));
                boolean b = call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest2"));
                if (b) {
                    call.setReturnType(this.QNAME_TYPE_STRING);
                    call.addParameter("BigInteger_1", new QName("http://www.w3.org/2001/XMLSchema", "integer"), ParameterMode.IN);
                    call.addParameter("BigDecimal_2", new QName("http://www.w3.org/2001/XMLSchema", "decimal"), ParameterMode.IN);
                    call.addParameter("QName_3", new QName("http://www.w3.org/2001/XMLSchema", "QName"), ParameterMode.IN);
                    call.addParameter("String_4", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
                }
                Object[] params = new Object[]{JAXRPC_Data.BigInteger_data[0], JAXRPC_Data.BigDecimal_data[0], JAXRPC_Data.QName_data[0], JAXRPC_Data.String_data[0]};
                TestUtil.logMsg((String)"Attempt to invoke RPC method Tests(\"invokeTest2\")");
                String expected = "passed";
                String response = (String)call.invoke(params);
                if (!response.equals(expected)) {
                    TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor1Test1NoWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor1Test1NoWsdl failed");
        }
    }

    public void CreateCallConstructor1Test1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor1Test1WithWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
                return;
            }
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
            service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Create Call object via Service.createCall()");
            Call call = service.createCall();
            if (call == null) {
                TestUtil.logErr((String)"createCall() returned null");
                pass = false;
            } else if (!(call instanceof Call)) {
                TestUtil.logErr((String)"createCall() did not return instance of Call object");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Call object successfully created");
                TestUtil.logMsg((String)"Fillin rest of Call object and invoke RPC method");
                call = JAXRPC_Util.setCallProperties(call, " ");
                call.setTargetEndpointAddress(this.url);
                TestUtil.logMsg((String)"Set operation name to invokeTest2");
                call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeTest2"));
                boolean b = call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest2"));
                if (b) {
                    call.setReturnType(this.QNAME_TYPE_STRING);
                    call.addParameter("BigInteger_1", new QName("http://www.w3.org/2001/XMLSchema", "integer"), ParameterMode.IN);
                    call.addParameter("BigDecimal_2", new QName("http://www.w3.org/2001/XMLSchema", "decimal"), ParameterMode.IN);
                    call.addParameter("QName_3", new QName("http://www.w3.org/2001/XMLSchema", "QName"), ParameterMode.IN);
                    call.addParameter("String_4", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
                }
                Object[] params = new Object[]{JAXRPC_Data.BigInteger_data[0], JAXRPC_Data.BigDecimal_data[0], JAXRPC_Data.QName_data[0], JAXRPC_Data.String_data[0]};
                TestUtil.logMsg((String)"Attempt to invoke RPC method Tests(\"invokeTest2\")");
                String expected = "passed";
                String response = (String)call.invoke(params);
                if (!response.equals(expected)) {
                    TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor1Test1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor1Test1WithWsdl failed");
        }
    }

    public void CreateCallConstructor2Test1NoWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor2Test1NoWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_NO_WSDL);
            }
            TestUtil.logMsg((String)"Create Call object via Service.createCall(QName)");
            TestUtil.logMsg((String)("PORT_QNAME = " + this.PORT_QNAME));
            TestUtil.logMsg((String)"Expect an (UnsupportedOperationException)");
            try {
                Call call = service.createCall(this.PORT_QNAME);
                TestUtil.logErr((String)"Did not throw expected UnsupportedOperationException");
                pass = false;
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor2Test1NoWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor2Test1NoWsdl failed");
        }
    }

    public void CreateCallConstructor2Test1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor2Test1WithWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Create Call object via Service.createCall(QName)");
            TestUtil.logMsg((String)("PORT_QNAME = " + this.PORT_QNAME));
            Call call = service.createCall(this.PORT_QNAME);
            if (call == null) {
                TestUtil.logErr((String)"createCall() returned null");
                pass = false;
            } else if (!(call instanceof Call)) {
                TestUtil.logErr((String)"createCall() did not return instance of Call object");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Call object successfully created");
                TestUtil.logMsg((String)"Fillin rest of Call object and invoke RPC method");
                call = JAXRPC_Util.setCallProperties(call, " ");
                call.setTargetEndpointAddress(this.url);
                TestUtil.logMsg((String)"Set operation name to invokeTest2");
                call.setOperationName(new QName("http://helloservice.org/wsdl", "invokeTest2"));
                boolean b = call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest2"));
                if (b) {
                    call.setReturnType(this.QNAME_TYPE_STRING);
                    call.addParameter("BigInteger_1", new QName("http://www.w3.org/2001/XMLSchema", "integer"), ParameterMode.IN);
                    call.addParameter("BigDecimal_2", new QName("http://www.w3.org/2001/XMLSchema", "decimal"), ParameterMode.IN);
                    call.addParameter("QName_3", new QName("http://www.w3.org/2001/XMLSchema", "QName"), ParameterMode.IN);
                    call.addParameter("String_4", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
                }
                Object[] params = new Object[]{JAXRPC_Data.BigInteger_data[0], JAXRPC_Data.BigDecimal_data[0], JAXRPC_Data.QName_data[0], JAXRPC_Data.String_data[0]};
                TestUtil.logMsg((String)"Attempt to invoke RPC method Tests(\"invokeTest2\")");
                String expected = "passed";
                String response = (String)call.invoke(params);
                if (!response.equals(expected)) {
                    TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor2Test1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor2Test1WithWsdl failed");
        }
    }

    public void CreateCallConstructor3Test1NoWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor3Test1NoWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_NO_WSDL);
            }
            TestUtil.logMsg((String)"Create Call object via Service.createCall(QName, QName)");
            QName OPERATION_QNAME = new QName("http://helloservice.org/wsdl", "invokeTest2");
            TestUtil.logMsg((String)("PORT_QNAME = " + this.PORT_QNAME + ", Operation = " + OPERATION_QNAME));
            TestUtil.logMsg((String)"Expect an (UnsupportedOperationException)");
            try {
                Call call = service.createCall(this.PORT_QNAME, OPERATION_QNAME);
                TestUtil.logErr((String)"Did not throw expected UnsupportedOperationException");
                pass = false;
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor3Test1NoWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor3Test1NoWsdl failed");
        }
    }

    public void CreateCallConstructor3Test1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor3Test1WithWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Create Call object via Service.createCall(QName, QName)");
            QName OPERATION_QNAME = new QName("http://helloservice.org/wsdl", "invokeTest2");
            TestUtil.logMsg((String)("PORT_QNAME = " + this.PORT_QNAME + ", Operation = " + OPERATION_QNAME));
            Call call = service.createCall(this.PORT_QNAME, OPERATION_QNAME);
            if (call == null) {
                TestUtil.logErr((String)"createCall() returned null");
                pass = false;
            } else if (!(call instanceof Call)) {
                TestUtil.logErr((String)"createCall() did not return instance of Call object");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Call object successfully created");
                TestUtil.logMsg((String)"Fillin rest of Call object and invoke RPC method");
                call = JAXRPC_Util.setCallProperties(call, " ");
                call.setTargetEndpointAddress(this.url);
                TestUtil.logMsg((String)"Set operation name to invokeTest2");
                boolean b = call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest2"));
                if (b) {
                    call.setReturnType(this.QNAME_TYPE_STRING);
                    call.addParameter("BigInteger_1", new QName("http://www.w3.org/2001/XMLSchema", "integer"), ParameterMode.IN);
                    call.addParameter("BigDecimal_2", new QName("http://www.w3.org/2001/XMLSchema", "decimal"), ParameterMode.IN);
                    call.addParameter("QName_3", new QName("http://www.w3.org/2001/XMLSchema", "QName"), ParameterMode.IN);
                    call.addParameter("String_4", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
                }
                Object[] params = new Object[]{JAXRPC_Data.BigInteger_data[0], JAXRPC_Data.BigDecimal_data[0], JAXRPC_Data.QName_data[0], JAXRPC_Data.String_data[0]};
                TestUtil.logMsg((String)"Attempt to invoke RPC method Tests(\"invokeTest2\")");
                String expected = "passed";
                String response = (String)call.invoke(params);
                if (!response.equals(expected)) {
                    TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor3Test1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor3Test1WithWsdl failed");
        }
    }

    public void CreateCallConstructor4Test1NoWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor4Test1NoWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_NO_WSDL);
            }
            TestUtil.logMsg((String)"Create Call object via Service.createCall(QName, String)");
            String operation = "invokeTest2";
            TestUtil.logMsg((String)("PORT_QNAME = " + this.PORT_QNAME + ", Operation = " + operation));
            TestUtil.logMsg((String)"Expect an (UnsupportedOperationException)");
            try {
                Call call = service.createCall(this.PORT_QNAME, operation);
                TestUtil.logErr((String)"Did not throw expected UnsupportedOperationException");
                pass = false;
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor4Test1NoWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor4Test1NoWsdl failed");
        }
    }

    public void CreateCallConstructor4Test1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor4Test1WithWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Create Call object via Service.createCall(QName, String)");
            String operation = "invokeTest2";
            TestUtil.logMsg((String)("PORT_QNAME = " + this.PORT_QNAME + ", Operation = " + operation));
            Call call = service.createCall(this.PORT_QNAME, operation);
            if (call == null) {
                TestUtil.logErr((String)"createCall(QName, String) returned null");
                pass = false;
            } else if (!(call instanceof Call)) {
                TestUtil.logErr((String)"createCall(QName, String) did not return instance of Call object");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Call object successfully created");
                TestUtil.logMsg((String)"Fillin rest of Call object and invoke RPC method");
                call = JAXRPC_Util.setCallProperties(call, " ");
                call.setTargetEndpointAddress(this.url);
                boolean b = call.isParameterAndReturnSpecRequired(new QName("http://helloservice.org/wsdl", "invokeTest2"));
                if (b) {
                    call.setReturnType(this.QNAME_TYPE_STRING);
                    call.addParameter("BigInteger_1", new QName("http://www.w3.org/2001/XMLSchema", "integer"), ParameterMode.IN);
                    call.addParameter("BigDecimal_2", new QName("http://www.w3.org/2001/XMLSchema", "decimal"), ParameterMode.IN);
                    call.addParameter("QName_3", new QName("http://www.w3.org/2001/XMLSchema", "QName"), ParameterMode.IN);
                    call.addParameter("String_4", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
                }
                Object[] params = new Object[]{JAXRPC_Data.BigInteger_data[0], JAXRPC_Data.BigDecimal_data[0], JAXRPC_Data.QName_data[0], JAXRPC_Data.String_data[0]};
                TestUtil.logMsg((String)"Attempt to invoke RPC method Tests(\"invokeTest2\")");
                String expected = "passed";
                String response = (String)call.invoke(params);
                if (!response.equals(expected)) {
                    TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor4Test1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor4Test1WithWsdl failed");
        }
    }

    public void GetCallsPosTest1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetCallsPosTest1WithWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Test getCalls (valid port name/WSDL access) - positive test 1");
            TestUtil.logMsg((String)"Get an array of Call objects via Service.getCalls(PORT_QNAME)");
            Call[] calls = service.getCalls(this.PORT_QNAME);
            if (calls == null) {
                TestUtil.logErr((String)"getCalls() returned null");
                pass = false;
            } else if (!(calls instanceof Call[])) {
                TestUtil.logErr((String)"getCalls() did not return instance of Call[] objects");
                pass = false;
            } else {
                TestUtil.logMsg((String)"getCalls() successfully returned Call[] array");
                TestUtil.logMsg((String)("Array count = " + calls.length));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetCallsPosTest1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetCallsPosTest1WithWsdl failed");
        }
    }

    public void GetCallsNegTest1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetCallsNegTest1WithWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Test getCalls (invalid port name/WSDL acesss) - negative test 1");
            TestUtil.logMsg((String)"Get an array of Call objects via Service.getCalls()");
            TestUtil.logMsg((String)"Expecting a (ServiceException)");
            try {
                Call[] calls = service.getCalls(this.BAD_PORT_QNAME);
                TestUtil.logErr((String)"Did not throw expected ServiceException");
                pass = false;
            }
            catch (ServiceException e) {
                TestUtil.logMsg((String)"Caught expected ServiceException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetCallsNegTest1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetCallsNegTest1WithWsdl failed");
        }
    }

    public void GetCallsNegTest2WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetCallsNegTest2WithWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Test getCalls (null port name/WSDL access) - negative test 2");
            TestUtil.logMsg((String)"Get an array of Call objects via Service.getCalls()");
            TestUtil.logMsg((String)"Expecting a (ServiceException)");
            try {
                Call[] calls = service.getCalls(null);
                TestUtil.logErr((String)"Did not throw expected ServiceException");
                pass = false;
            }
            catch (ServiceException e) {
                TestUtil.logMsg((String)"Caught expected ServiceException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetCallsNegTest2WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetCallsNegTest2WithWsdl failed");
        }
    }

    public void GetCallsNegTest1NoWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetCallsNegTest1NoWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (!this.modeProperty.equals("standalone")) {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_NO_WSDL);
                return;
            }
            service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            TestUtil.logMsg((String)"Test getCalls (valid port name/no WSDL access) - negative test 1");
            TestUtil.logMsg((String)"Get an array of Call objects via Service.getCalls()");
            TestUtil.logMsg((String)"Expecting an (UnsupportedOperationException)");
            try {
                Call[] calls = service.getCalls(this.PORT_QNAME);
                TestUtil.logErr((String)"Did not throw expected UnsupportedOperationException");
                pass = false;
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
            }
            catch (ServiceException e) {
                TestUtil.logMsg((String)"Caught expected ServiceException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetCallsNegTest1NoWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetCallsNegTest1NoWsdl failed");
        }
    }

    public void GetPortConstructor1PosTest1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor1PosTest1WithWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Test getPort (valid port name/WSDL access) - positive test 1");
            TestUtil.logMsg((String)"Call Service.getPort(QName, Class)");
            TestUtil.logMsg((String)"Should find port");
            Hello tests = (Hello)service.getPort(this.PORT_QNAME, Hello.class);
            if (tests == null) {
                TestUtil.logErr((String)"getPort(QName, Class) returned null");
                pass = false;
            } else if (!(tests instanceof Hello)) {
                TestUtil.logErr((String)"getPort(QName, Class) did not return instance of Hello");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor1PosTest1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor1PosTest1WithWsdl failed");
        }
    }

    public void GetPortConstructor1NegTest1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor1NegTest1WithWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Test getPort (invalid port name/WSDL access) - negative test 1");
            TestUtil.logMsg((String)"Call Service.getPort(QName, Class)");
            TestUtil.logMsg((String)"Should not find port (expect ServiceException)");
            Hello tests = (Hello)service.getPort(this.BAD_PORT_QNAME, Hello.class);
            TestUtil.logErr((String)"Did not throw expected ServiceException");
            pass = false;
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught expected ServiceException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor1NegTest1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor1NegTest1WithWsdl failed");
        }
    }

    public void GetPortConstructor1NegTest1NoWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor1NegTest1NoWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (!this.modeProperty.equals("standalone")) {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_NO_WSDL);
                return;
            }
            service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            TestUtil.logMsg((String)"Test getPort (valid port name/no WSDL access) - negative test 1");
            TestUtil.logMsg((String)"Call Service.getPort(QName, Class)");
            TestUtil.logMsg((String)"Expect an (UnsupportedOperationException)");
            Hello tests = (Hello)service.getPort(this.PORT_QNAME, Hello.class);
            TestUtil.logErr((String)"Did not throw expected UnsupportedOperationException");
            pass = false;
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught expected ServiceException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor1NegTest1NoWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor1NegTest1NoWsdl failed");
        }
    }

    public void GetPortConstructor1NegTest2NoWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor1NegTest2NoWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (!this.modeProperty.equals("standalone")) {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_NO_WSDL);
                return;
            }
            service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            TestUtil.logMsg((String)"Test getPort (null port name/WSDL access) - negative test 2");
            TestUtil.logMsg((String)"Call Service.getPort(QName, Class)");
            TestUtil.logMsg((String)"Expect an (UnsupportedOperationException)");
            Hello tests = (Hello)service.getPort(this.PORT_QNAME, Hello.class);
            TestUtil.logErr((String)"Did not throw expected UnsupportedOperationException");
            pass = false;
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught expected ServiceException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor1NegTest2NoWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor1NegTest2NoWsdl failed");
        }
    }

    public void GetPortConstructor2PosTest1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor2PosTest1WithWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Test getPort (valid SEI class/WSDL access) - positive test 1");
            TestUtil.logMsg((String)"Call Service.getPort(Class)");
            TestUtil.logMsg((String)"Should find port");
            Hello tests = (Hello)service.getPort(Hello.class);
            if (tests == null) {
                TestUtil.logErr((String)"getPort(Class) returned null");
                pass = false;
            } else if (!(tests instanceof Hello)) {
                TestUtil.logErr((String)"getPort(Class) did not return instance of Hello");
                pass = false;
            }
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught expected ServiceException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor2PosTest1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor2PosTest1WithWsdl failed");
        }
    }

    public void GetPortConstructor2NegTest1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor2NegTest1WithWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Test getPort (invalid SEI class/WSDL access) - negative test 1");
            TestUtil.logMsg((String)"Call Service.getPort(Class)");
            TestUtil.logMsg((String)"Should not find port (expect ServiceException)");
            Hello tests = (Hello)service.getPort(Pattern.class);
            TestUtil.logErr((String)"Did not throw expected ServiceException");
            pass = false;
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught expected ServiceException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor2NegTest1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor2NegTest1WithWsdl failed");
        }
    }

    public void GetPortConstructor2NegTest1NoWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor2NegTest1NoWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (!this.modeProperty.equals("standalone")) {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_NO_WSDL);
                return;
            }
            service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            TestUtil.logMsg((String)"Test getPort (valid SEI class/no WSDL access) - negative test 1");
            TestUtil.logMsg((String)"Call Service.getPort(Class)");
            TestUtil.logMsg((String)"Expect an (UnsupportedOperationException)");
            Hello tests = (Hello)service.getPort(Hello.class);
            TestUtil.logErr((String)"Did not throw expected UnsupportedOperationException");
            pass = false;
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught expected ServiceException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor2NegTest1NoWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor2NegTest1NoWsdl failed");
        }
    }

    public void GetPortsTest1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortsTest1WithWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Test getPorts with (WSDL access) - positive test 1");
            TestUtil.logMsg((String)"Call Service.getPorts()");
            TestUtil.logMsg((String)"Expect a non empty iterator of ports");
            Iterator i = service.getPorts();
            if (!i.hasNext()) {
                TestUtil.logErr((String)"getPorts() returned empty iterator (unexpected)");
                pass = false;
            } else {
                int count = 0;
                while (i.hasNext()) {
                    i.next();
                    ++count;
                }
                if (count != 1) {
                    TestUtil.logErr((String)("getPorts() returned wrong iterator count, got " + count + ", expected 1"));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortsTest1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortsTest1WithWsdl failed");
        }
    }

    public void GetPortsTest1NoWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortsTest1NoWsdl");
        boolean pass = true;
        try {
            Service service = null;
            if (!this.modeProperty.equals("standalone")) {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_NO_WSDL);
                return;
            }
            service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            TestUtil.logMsg((String)"Test getPorts with (no WSDL access) - positive test 2");
            TestUtil.logMsg((String)"Call Service.getPorts()");
            TestUtil.logMsg((String)"Expect an (UnsupportedOperationException)");
            Iterator i = service.getPorts();
            TestUtil.logErr((String)"Did not throw expected UnsupportedOperationException");
            pass = false;
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught expected UnsupportedOperationException");
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught expected ServiceException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortsTest1NoWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortsTest1NoWsdl failed");
        }
    }

    public void GetServiceNameTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetServiceNameTest1");
        boolean pass = true;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Create Call object via Service.createCall()");
            Call call = service.createCall();
            TestUtil.logMsg((String)"Get service name via Service.getServiceName()");
            QName sname = service.getServiceName();
            TestUtil.logMsg((String)("ServiceName = " + this.SERVICE_QNAME + "\ngetServiceName() = " + sname));
            if (!sname.equals(this.SERVICE_QNAME)) {
                TestUtil.logErr((String)"getServiceName() returned wrong QName");
                TestUtil.logErr((String)("Expected " + this.SERVICE_QNAME + "\nGot " + sname));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetServiceNameTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetServiceNameTest1 failed");
        }
    }

    public void GetWSDLDocumentLocationTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetWSDLDocumentLocationTest1");
        boolean pass = false;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Call Service.getWSDLDocumentLocation() part1");
            URL url = service.getWSDLDocumentLocation();
            TestUtil.logMsg((String)("WSDLURL = " + url));
            if (url != null) {
                TestUtil.logErr((String)"WSDLURL is not null (expected)");
                pass = true;
            } else {
                TestUtil.logMsg((String)"WSDLURL is null (unexpected)");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetWSDLDocumentLocationTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetWSDLDocumentLocationTest1 failed");
        }
    }

    public void GetTypeMappingRegistryTest1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetTypeMappingRegistryTest1WithWsdl");
        boolean pass = false;
        TypeMappingRegistry tmrRegistry = null;
        Service service = null;
        try {
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Call Service.getTypeMappingRegistry()");
            tmrRegistry = service.getTypeMappingRegistry();
            if (tmrRegistry == null) {
                TestUtil.logMsg((String)"No TypeMappingRegistry defined on Service object (returned null)");
            } else {
                TestUtil.logMsg((String)("TypeMappingRegistry defined on Service object (returned = " + tmrRegistry + ")"));
            }
            if (this.modeProperty.equals("standalone")) {
                pass = true;
            }
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            pass = true;
        }
        catch (JAXRPCException e) {
            TestUtil.logErr((String)"Caught unexpected JAXRPCException", (Throwable)e);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetTypeMappingRegistryTest1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetTypeMappingRegistryTest1WithWsdl failed");
        }
    }

    public void GetTypeMappingRegistryTest1NoWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetTypeMappingRegistryTest1NoWsdl");
        boolean pass = false;
        TypeMappingRegistry tmrRegistry = null;
        Service service = null;
        try {
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_NO_WSDL);
            }
            TestUtil.logMsg((String)"Call Service.getTypeMappingRegistry()");
            tmrRegistry = service.getTypeMappingRegistry();
            if (tmrRegistry == null) {
                TestUtil.logMsg((String)"No TypeMappingRegistry defined on Service object (returned null)");
            } else {
                TestUtil.logMsg((String)("TypeMappingRegistry defined on Service object (returned = " + tmrRegistry + ")"));
            }
            if (this.modeProperty.equals("standalone")) {
                pass = true;
            }
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            pass = true;
        }
        catch (JAXRPCException e) {
            TestUtil.logErr((String)"Caught unexpected JAXRPCException", (Throwable)e);
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetTypeMappingRegistryTest1NoWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetTypeMappingRegistryTest1NoWsdl failed");
        }
    }

    public void GetHandlerRegistryTest1WithWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetHandlerRegistryTest1WithWsdl");
        boolean pass = false;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.wsdlurl, this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            }
            TestUtil.logMsg((String)"Call Service.getHandlerRegistry() - should throw UnsupportedOperationException");
            HandlerRegistry hr = service.getHandlerRegistry();
            TestUtil.logMsg((String)"service.getHandlerRegistry() did not throw UnsupportedOperationException");
            if (this.modeProperty.equals("standalone")) {
                pass = true;
            }
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetHandlerRegistryTest1WithWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetHandlerRegistryTest1WithWsdl failed");
        }
    }

    public void GetHandlerRegistryTest1NoWsdl() throws EETest.Fault {
        TestUtil.logTrace((String)"GetHandlerRegistryTest1NoWsdl");
        boolean pass = false;
        try {
            Service service = null;
            if (this.modeProperty.equals("standalone")) {
                service = JAXRPC_Util.getService(this.SERVICE_QNAME);
            } else {
                TestUtil.logMsg((String)"Get Initial Context");
                InitialContext ctx = new InitialContext();
                TestUtil.logMsg((String)"Get JAXRPC service instance without WSDL");
                service = (Service)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_NO_WSDL);
            }
            TestUtil.logMsg((String)"Call Service.getHandlerRegistry() - should throw UnsupportedOperationException");
            HandlerRegistry hr = service.getHandlerRegistry();
            TestUtil.logMsg((String)"service.getHandlerRegistry() did not throw UnsupportedOperationException");
            if (this.modeProperty.equals("standalone")) {
                pass = true;
            }
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetHandlerRegistryTest1NoWsdl failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetHandlerRegistryTest1NoWsdl failed");
        }
    }
}

