/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ee4j.jakartaeetck.tools.jtreportparser;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Properties;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.ee4j.jakartaeetck.tools.jtreportparser.TestCase;
import org.eclipse.ee4j.jakartaeetck.tools.jtreportparser.TestStatus;
import org.eclipse.ee4j.jakartaeetck.tools.jtreportparser.TestSuite;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class JTReportParser {
    private static final String DATE_PATTERN = "(\\w{3}\\s\\w{3}\\s\\d{2}\\s\\d{2}\\\\:\\d{2}\\\\:\\d{2}.*\\d{4}$)";
    private static final Pattern START_TIME_PATTERN = Pattern.compile("start=(\\w{3}\\s\\w{3}\\s\\d{2}\\s\\d{2}\\\\:\\d{2}\\\\:\\d{2}.*\\d{4}$)");
    private static final Pattern END_TIME_PATTERN = Pattern.compile("end=(\\w{3}\\s\\w{3}\\s\\d{2}\\s\\d{2}\\\\:\\d{2}\\\\:\\d{2}.*\\d{4}$)");

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static long getDuration(File sysoutFile, TestSuite suite) throws FileNotFoundException {
        long duration = 0L;
        if (!sysoutFile.exists()) {
            return duration;
        }
        String startTime = null;
        String endTime = null;
        try (Scanner in = new Scanner(sysoutFile);){
            while (in.hasNext()) {
                String line = in.nextLine();
                Matcher m = START_TIME_PATTERN.matcher(line);
                if (m.find()) {
                    startTime = m.group(1).replace("\\", "");
                }
                if ((m = END_TIME_PATTERN.matcher(line)).find()) {
                    endTime = m.group(1).replace("\\", "");
                }
                if (startTime == null || endTime == null) continue;
            }
            if (startTime == null || endTime == null) {
                long line = duration;
                return line;
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss z yyyy");
            LocalDateTime startDateTime = LocalDateTime.parse(startTime, formatter);
            LocalDateTime endDateTime = LocalDateTime.parse(endTime, formatter);
            suite.setStartDateTime(startDateTime);
            suite.setEndDateTime(endDateTime);
            duration = Duration.between(startDateTime, endDateTime).getSeconds();
            return duration;
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    private static String getLastLine(String sysoutFilePath) throws IOException {
        String lastLine;
        try (Stream<String> stream = Files.lines(Paths.get(sysoutFilePath, new String[0]));){
            lastLine = stream.reduce((a, b) -> b).orElse("");
        }
        catch (NoSuchFileException ex) {
            lastLine = "";
        }
        return lastLine;
    }

    public static File getHtmlDir(String reportDirPath, String componentName) throws FileNotFoundException {
        File reportDir = new File(reportDirPath, componentName);
        if (!reportDir.exists()) {
            throw new FileNotFoundException("The report base dir " + reportDir + " does not exist");
        }
        File htmlDir = new File(reportDir, "html");
        if (!htmlDir.exists()) {
            if (new File(reportDir, "report.html").exists()) {
                return reportDir;
            }
            throw new FileNotFoundException("The html dir " + htmlDir + " does not exist");
        }
        return htmlDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Set<TestCase> parseKnowFailures(String knownFailuresDirPath, String component) throws IOException {
        String componentFileName;
        HashSet<TestCase> hashSet = new HashSet<TestCase>();
        if (knownFailuresDirPath == null) {
            return hashSet;
        }
        File knownFailuresDir = new File(knownFailuresDirPath);
        String parentComponentName = null;
        String flattenedComponentName = null;
        if (component.contains("/")) {
            parentComponentName = component.split("/")[0];
            flattenedComponentName = component.replaceAll("/", "_");
        }
        if (!knownFailuresDir.exists()) {
            System.out.println("[warning] known failure directory does not exist." + knownFailuresDir);
            return hashSet;
        }
        if (!knownFailuresDir.isDirectory()) {
            System.out.println("[warning] known failure directory is not a directory. " + knownFailuresDir);
            return hashSet;
        }
        if (!knownFailuresDir.canRead()) {
            System.out.println("[warning] known failure directory is not readable. " + knownFailuresDir);
            return hashSet;
        }
        if (!new File(knownFailuresDir, component + ".txt").exists()) {
            if (new File(knownFailuresDir, parentComponentName + ".txt").exists()) {
                componentFileName = parentComponentName;
            } else {
                if (!new File(knownFailuresDir, flattenedComponentName + ".txt").exists()) {
                    System.out.println("[warning] known failure file does not exist in directory '" + knownFailuresDir + "' for component '" + component + "'");
                    return hashSet;
                }
                componentFileName = flattenedComponentName;
            }
        } else {
            componentFileName = component;
        }
        try (Stream<String> stream = Files.lines(Paths.get(knownFailuresDirPath, componentFileName + ".txt"));){
            Set<TestCase> set = stream.map(JTReportParser::createKnownFailureTestCase).filter(x -> x != null).collect(Collectors.toSet());
            return set;
        }
        catch (IOException ex) {
            ex.printStackTrace(System.err);
            throw ex;
        }
    }

    public static TestCase createKnownFailureTestCase(String text) {
        if (!text.startsWith("#") && text.contains("#")) {
            String testName = text.split("#")[1];
            String className = text.split("#")[0].replace(".java", "").replaceAll("/", ".");
            System.out.println("Adding known failure [class: " + className + ", method:" + testName + "]");
            return new TestCase(testName, className, 0L, TestStatus.FAILED, "");
        }
        System.out.println("[Warning] Ignoring commented/empty line '" + text + "' in known failures file ");
        return null;
    }

    public static Set<TestCase> parseTestCases(String reportDirPath, String component, TestSuite suite, TestStatus testType, Set<TestCase> knownFailures) throws IOException {
        HashSet<TestCase> testCases = new HashSet<TestCase>();
        File testCaseHtmlFile = new File(JTReportParser.getHtmlDir(reportDirPath, component), testType.getHtmlFileName());
        if (!testCaseHtmlFile.exists()) {
            return testCases;
        }
        Document doc = Jsoup.parse(testCaseHtmlFile, StandardCharsets.UTF_8.name());
        Elements links = doc.select("a[href]");
        long totalDuration = 0L;
        int knownTestFailureCount = 0;
        int newTestFailureCount = 0;
        for (int i = 0; i < links.size(); ++i) {
            String testName;
            String sysoutFilePath = ((Element)links.get(i)).attr("href");
            String text = ((Element)links.get(i)).text();
            String className = "";
            if (text.contains("#")) {
                testName = text.split("#")[1];
                className = text.split("#")[0].replace(".java", "").replaceAll("/", ".");
            } else {
                testName = text;
            }
            File sysoutFile = new File(sysoutFilePath);
            long duration = JTReportParser.getDuration(sysoutFile, suite);
            totalDuration += duration;
            TestCase test = new TestCase(testName, className, duration, testType, sysoutFilePath);
            String errorMsg = JTReportParser.getLastLine(sysoutFilePath);
            test.setErrorMsg(errorMsg);
            if (TestStatus.FAILED == testType) {
                if (!knownFailures.contains(test)) {
                    testCases.add(test);
                    System.out.println("Found a new failure:" + test);
                    ++newTestFailureCount;
                    continue;
                }
                test = new TestCase(testName, className, duration, TestStatus.EXCLUDED, sysoutFilePath);
                testCases.add(test);
                System.out.println("Found a known failure:" + test + ". So marking it as excluded in report");
                ++knownTestFailureCount;
                continue;
            }
            testCases.add(test);
        }
        switch (testType) {
            case PASSED: {
                suite.setPassedTestsDuration(totalDuration);
                suite.setPassedTestsCount(testCases.size());
                break;
            }
            case FAILED: {
                suite.setFailedTestsDuration(totalDuration);
                suite.setFailedTestsCount(newTestFailureCount);
                suite.setExcludedTestsCount(knownTestFailureCount);
                break;
            }
            case ERROR: {
                suite.setErrorTestsDuration(totalDuration);
                suite.setErrorTestsCount(testCases.size());
                break;
            }
            case EXCLUDED: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid test case type:" + (Object)((Object)testType));
            }
        }
        return testCases;
    }

    public static Set<TestCase> parseExcludedTests(String reportDirPath, String component, TestSuite suite) throws IOException {
        HashSet<TestCase> testCases = new HashSet<TestCase>();
        File excludedTestHtml = new File(JTReportParser.getHtmlDir(reportDirPath, component), TestStatus.EXCLUDED.getHtmlFileName());
        if (!excludedTestHtml.exists()) {
            return testCases;
        }
        Document doc = Jsoup.parse(excludedTestHtml, StandardCharsets.UTF_8.name());
        Elements allTables = doc.select("table");
        if (!allTables.isEmpty()) {
            Element excludedTestsTable = (Element)allTables.get(0);
            Elements rows = excludedTestsTable.select("tr");
            for (int i = 1; i < rows.size(); ++i) {
                Element row = (Element)rows.get(i);
                Elements cols = row.select("td");
                String text = ((Element)cols.get(0)).text();
                boolean isTestForCurrentComponent = "jbatch".equals(component) && text.startsWith("com/ibm/" + component + "/") ? true : text.startsWith("com/sun/ts/tests/" + component + "/");
                if (!isTestForCurrentComponent) continue;
                String[] textArray = new String[]{};
                if (text.contains("#")) {
                    textArray = text.split("#");
                }
                if (textArray.length < 2) {
                    System.out.println("[Warning] the test string does not contain class name and method name");
                    continue;
                }
                String testName = textArray[1];
                String className = textArray[0].replace(".java", "").replaceAll("/", ".");
                TestCase test = new TestCase(testName, className, 0L, TestStatus.EXCLUDED, "");
                testCases.add(test);
            }
        } else {
            System.out.println("[Warning]: There are no excluded tests to be processed.");
        }
        suite.setExcludedTestsCount(testCases.size());
        return testCases;
    }

    public static Properties parseProperties(String reportDirPath, String component) throws IOException {
        Properties properties = new Properties();
        Document doc = Jsoup.parse(new File(JTReportParser.getHtmlDir(reportDirPath, component), "env.html"), "utf-8");
        Elements allTables = doc.select("table");
        if (!allTables.isEmpty()) {
            Element envTable = (Element)allTables.get(0);
            Elements rows = envTable.select("tr");
            for (int i = 1; i < rows.size(); ++i) {
                Element row = (Element)rows.get(i);
                Elements cols = row.select("td");
                String value = ((Element)cols.get(1)).text();
                value = value.replaceAll("\"", "&#34;");
                value = value.replaceAll("&", "&#38;");
                value = value.replaceAll("'", "&#39;");
                value = value.replaceAll("<", "&lt;");
                value = value.replaceAll(">", "&gt;");
                properties.setProperty(((Element)cols.get(0)).text(), value);
            }
        } else {
            System.out.println("[Warning]: There are no environment properties to be processed.");
        }
        return properties;
    }

    public static void dumpPropertiesXML(Properties props, PrintWriter writer) {
        writer.println("<properties>");
        props.stringPropertyNames().stream().forEach(property -> writer.println("<property name=\"" + property + "\" value=\"" + props.getProperty((String)property) + "\" />"));
        writer.println("</properties>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        File argsFile;
        String baseJTReportDirPath = null;
        String junitReportDirPath = null;
        String knownFailuresDirPath = null;
        String reportAggregatorDirPath = null;
        if (args.length == 3) {
            argsFile = new File(args[0]);
            if (!argsFile.exists()) {
                throw new IllegalArgumentException("The args file '" + args[0] + "' does not exist");
            }
            knownFailuresDirPath = System.getProperty("cts.knownFailures.dir");
            reportAggregatorDirPath = System.getProperty("cts.report.aggregator.dir");
            baseJTReportDirPath = args[1];
            junitReportDirPath = args[2];
            if (!new File(baseJTReportDirPath).exists()) {
                throw new IllegalArgumentException("The JT report dir '" + baseJTReportDirPath + "' does not exist");
            }
            if (!new File(junitReportDirPath).exists()) {
                throw new IllegalArgumentException("The junit report dir '" + junitReportDirPath + "' does not exist");
            }
        } else {
            System.out.println("Specify the required arguments: argsFile baseReportDir junitReportDir");
            return;
        }
        try (Scanner in = new Scanner(argsFile);){
            while (in.hasNextLine()) {
                String hostname;
                String component;
                String id;
                block28: {
                    String line = in.nextLine();
                    System.out.println("Read line: " + line);
                    String[] splitLine = line.split("\\s+");
                    if (splitLine.length != 3) {
                        System.out.println("[WARN] Could not get the required arguments.processed line does not meet the requirements");
                        continue;
                    }
                    id = splitLine[0];
                    component = splitLine[1];
                    hostname = splitLine[2];
                    try {
                        if (!JTReportParser.getHtmlDir(baseJTReportDirPath, component).exists()) {
                            System.out.println("[WARN] Skipping JUnit report generation for component '" + component + "'");
                        }
                        break block28;
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace(System.err);
                    }
                    continue;
                }
                File junitReportXml = new File(junitReportDirPath, component.replaceAll("/", "-") + "-junit-report.xml");
                System.out.println("Creating report file:" + junitReportXml);
                PrintWriter junitReportWriter = new PrintWriter(junitReportXml);
                System.out.println("Creating test suite with id=" + id + ", component=" + component + ", hostname=" + hostname);
                TestSuite suite = new TestSuite(id, component, hostname);
                try {
                    HashSet<TestCase> knownFailures = new HashSet();
                    if (knownFailuresDirPath != null) {
                        knownFailures = JTReportParser.parseKnowFailures(knownFailuresDirPath, component);
                    }
                    Set<TestCase> passedTests = JTReportParser.parseTestCases(baseJTReportDirPath, component, suite, TestStatus.PASSED, knownFailures);
                    Set<TestCase> failedTests = JTReportParser.parseTestCases(baseJTReportDirPath, component, suite, TestStatus.FAILED, knownFailures);
                    Set<TestCase> errorTests = JTReportParser.parseTestCases(baseJTReportDirPath, component, suite, TestStatus.ERROR, knownFailures);
                    Properties props = JTReportParser.parseProperties(baseJTReportDirPath, component);
                    junitReportWriter.println(suite.getXMLStartElement());
                    JTReportParser.dumpPropertiesXML(props, junitReportWriter);
                    HashSet newFailures = new HashSet();
                    HashSet excludedFailures = new HashSet();
                    failedTests.stream().forEach(testCase -> {
                        if (TestStatus.EXCLUDED == testCase.getStatus()) {
                            excludedFailures.add(testCase);
                        } else {
                            newFailures.add(testCase);
                        }
                    });
                    newFailures.stream().sorted(Comparator.comparing(TestCase::getName)).forEach(x -> x.toXML(junitReportWriter));
                    excludedFailures.stream().sorted(Comparator.comparing(TestCase::getName)).forEach(x -> x.toXML(junitReportWriter));
                    errorTests.stream().sorted(Comparator.comparing(TestCase::getName)).forEach(x -> x.toXML(junitReportWriter));
                    passedTests.stream().sorted(Comparator.comparing(TestCase::getName)).forEach(x -> x.toXML(junitReportWriter));
                    junitReportWriter.println(suite.getXMLEndElement());
                    System.out.println("Successfully created JUnit report for component '" + component + "'");
                    if (reportAggregatorDirPath == null) continue;
                    JTReportParser.appendToReportAggregator(reportAggregatorDirPath, component, suite);
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                finally {
                    junitReportWriter.flush();
                    junitReportWriter.close();
                }
            }
        }
    }

    private static void appendToReportAggregator(String reportAggregatorDirPath, String component, TestSuite suite) throws IOException {
        File aggregatorFile = new File(reportAggregatorDirPath, component);
        if (!aggregatorFile.exists()) {
            aggregatorFile.createNewFile();
        }
        FileWriter writer = new FileWriter(aggregatorFile, true);
        String newLine = System.getProperty("line.separator");
        writer.append(newLine);
        writer.append(suite.asText());
        writer.append(newLine);
    }
}

