/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.ordercolumn;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.CleanupMethod;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.SetupMethod;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.ordercolumn.Course;
import com.sun.ts.tests.jpa.core.annotations.ordercolumn.Department;
import com.sun.ts.tests.jpa.core.annotations.ordercolumn.Department2;
import com.sun.ts.tests.jpa.core.annotations.ordercolumn.Employee;
import com.sun.ts.tests.jpa.core.annotations.ordercolumn.Employee2;
import com.sun.ts.tests.jpa.core.annotations.ordercolumn.Student;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import javax.persistence.TypedQuery;

public class Client
extends PMClientBase {
    private List<Student> expectedResults;
    private List<Employee> expectedEmployees;
    private List<Employee2> expectedEmployees2;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            this.createStudentTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void setupEmployee(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeEmployeeTestData();
            this.createEmployeeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void orderColumn() throws EETest.Fault {
        boolean pass = false;
        String expectedStudentName = "Joseph";
        int expectedListSize = 4;
        int courseNumber = 101;
        int numStudents = 0;
        try {
            this.getEntityTransaction().begin();
            Course course = (Course)this.getEntityManager().find(Course.class, (Object)101);
            if (course != null) {
                numStudents = course.getStudents().size();
            } else {
                TestUtil.logErr((String)"course from find() is NULL!");
            }
            if (numStudents == 4) {
                List students = course.getStudents();
                if (((Student)students.get(0)).equals((Object)this.expectedResults.get(0)) && ((Student)students.get(1)).equals((Object)this.expectedResults.get(1)) && ((Student)students.get(2)).equals((Object)this.expectedResults.get(2)) && ((Student)students.get(3)).equals((Object)this.expectedResults.get(3))) {
                    TestUtil.logTrace((String)"****Current order of students returned via getStudents()\nNow checking via JPQL");
                    Query q = this.getEntityManager().createQuery("SELECT s.studentName FROM Course c JOIN c.students s where c.courseName ='Physics' and INDEX(s) = 1");
                    String result = (String)q.getSingleResult();
                    if (result.equals("Joseph")) {
                        TestUtil.logTrace((String)"+++Received expected Name via Query:Joseph");
                        pass = true;
                    } else {
                        TestUtil.logErr((String)("Did NOT get expected name via Query: Joseph, received: " + result));
                    }
                } else {
                    TestUtil.logErr((String)"Failed to return the correct order of students via getStudents()");
                }
            } else {
                TestUtil.logErr((String)"course.getStudents() returned wrong number!");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("orderColumn test failed");
        }
    }

    @SetupMethod(name="setupEmployee")
    @CleanupMethod(name="cleanupEmployee")
    public void propertyAccessWithNameTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            Department d = (Department)this.getEntityManager().find(Department.class, (Object)50);
            TestUtil.logMsg((String)"Display find data");
            for (Employee e : d.getEmployees()) {
                TestUtil.logMsg((String)("Employee:" + e));
            }
            ArrayList<Employee> actual = new ArrayList<Employee>();
            TypedQuery q = this.getEntityManager().createQuery("SELECT e FROM Department d JOIN d.employees e WHERE d.id = 50 AND INDEX(e) = 0", Employee.class);
            Employee emp = (Employee)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                TestUtil.logErr((String)"Query of INDEX(0) returned null result");
            }
            q = this.getEntityManager().createQuery("SELECT e FROM Department d JOIN d.employees e WHERE d.id = 50 AND INDEX(e) = 1", Employee.class);
            emp = (Employee)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                TestUtil.logErr((String)"Query of INDEX(1) returned null result");
            }
            q = this.getEntityManager().createQuery("SELECT e FROM Department d JOIN d.employees e WHERE d.id = 50 AND INDEX(e) = 2", Employee.class);
            emp = (Employee)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                TestUtil.logErr((String)"Query of INDEX(2) returned null result");
            }
            if (actual.size() == this.expectedEmployees.size()) {
                int count = 0;
                for (int i = 0; i < this.expectedEmployees.size(); ++i) {
                    TestUtil.logTrace((String)("Testing - expected[" + this.expectedEmployees.get(i) + "], actual[" + actual.get(i) + "]"));
                    if (!this.expectedEmployees.get(i).equals(actual.get(i))) continue;
                    ++count;
                }
                if (count == this.expectedEmployees.size()) {
                    pass = true;
                } else {
                    TestUtil.logTrace((String)("count=" + count + ", expected size:" + this.expectedEmployees.size()));
                    for (Employee e : this.expectedEmployees) {
                        TestUtil.logErr((String)("expected:" + e));
                    }
                    TestUtil.logErr((String)"------------");
                    for (Employee e : actual) {
                        TestUtil.logErr((String)("actual:" + e));
                    }
                }
            } else {
                TestUtil.logErr((String)("Expected list size:" + this.expectedEmployees.size() + ", actual size:" + actual.size()));
                for (Employee e : this.expectedEmployees) {
                    TestUtil.logErr((String)("expected:" + e));
                }
                TestUtil.logErr((String)"------------");
                for (Employee e : actual) {
                    TestUtil.logErr((String)("actual:" + e));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("propertyAccessWithNameTest test failed");
        }
    }

    @SetupMethod(name="setupEmployee")
    @CleanupMethod(name="cleanupEmployee")
    public void fieldAccessWithNameTest() throws EETest.Fault {
        boolean pass = false;
        try {
            this.getEntityTransaction().begin();
            this.clearCache();
            Department2 d = (Department2)this.getEntityManager().find(Department2.class, (Object)55);
            TestUtil.logMsg((String)"Display find data");
            for (Employee2 e : d.getEmployees()) {
                TestUtil.logMsg((String)("Employee2:" + e));
            }
            ArrayList<Employee2> actual = new ArrayList<Employee2>();
            TypedQuery q = this.getEntityManager().createQuery("SELECT e FROM Department2 d JOIN d.employees e WHERE d.id = 55 AND INDEX(e) = 0", Employee2.class);
            Employee2 emp = (Employee2)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                TestUtil.logErr((String)"Query of INDEX(0) returned null result");
            }
            q = this.getEntityManager().createQuery("SELECT e FROM Department2 d JOIN d.employees e WHERE d.id = 55 AND INDEX(e) = 1", Employee2.class);
            emp = (Employee2)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                TestUtil.logErr((String)"Query of INDEX(1) returned null result");
            }
            q = this.getEntityManager().createQuery("SELECT e FROM Department2 d JOIN d.employees e WHERE d.id = 55 AND INDEX(e) = 2", Employee2.class);
            emp = (Employee2)q.getSingleResult();
            if (emp != null) {
                actual.add(emp);
            } else {
                TestUtil.logErr((String)"Query of INDEX(2) returned null result");
            }
            if (actual.size() == this.expectedEmployees2.size()) {
                int count = 0;
                for (int i = 0; i < this.expectedEmployees2.size(); ++i) {
                    TestUtil.logTrace((String)("Testing - expected[" + this.expectedEmployees2.get(i) + "], actual[" + actual.get(i) + "]"));
                    if (!this.expectedEmployees2.get(i).equals(actual.get(i))) continue;
                    ++count;
                }
                if (count == this.expectedEmployees.size()) {
                    pass = true;
                } else {
                    TestUtil.logTrace((String)("count=" + count + ", expected size:" + this.expectedEmployees2.size()));
                    for (Employee2 e : this.expectedEmployees2) {
                        TestUtil.logErr((String)("expected:" + e));
                    }
                    TestUtil.logErr((String)"------------");
                    for (Employee2 e : actual) {
                        TestUtil.logErr((String)("actual:" + e));
                    }
                }
            } else {
                TestUtil.logErr((String)("Expected list size:" + this.expectedEmployees2.size() + ", actual size:" + actual.size()));
                for (Employee2 e : this.expectedEmployees2) {
                    TestUtil.logErr((String)("expected:" + e));
                }
                TestUtil.logErr((String)"------------");
                for (Employee2 e : actual) {
                    TestUtil.logErr((String)("actual:" + e));
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
        }
        if (!pass) {
            throw new EETest.Fault("fieldAccessWithNameTest test failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createStudentTestData() {
        try {
            TestUtil.logTrace((String)"createTestData");
            this.getEntityTransaction().begin();
            Student student1 = new Student(1, "Neo");
            Student student2 = new Student(2, "Vivek");
            Student student3 = new Student(3, "Arun");
            Student student4 = new Student(4, "Ganesh");
            Student student5 = new Student(5, "Ram");
            Student student6 = new Student(6, "Rahim");
            Student student7 = new Student(7, "Joseph");
            Student student8 = new Student(8, "Krishna");
            Course appliedMath = new Course(101, "AppliedMathematics");
            Course physics = new Course(102, "Physics");
            Course operationResearch = new Course(103, "OperationResearch");
            Course statistics = new Course(201, "Statistics");
            Course operatingSystem = new Course(202, "OperatingSystem");
            ArrayList<Student> studentList1 = new ArrayList<Student>();
            studentList1.add(student1);
            studentList1.add(student7);
            studentList1.add(student2);
            studentList1.add(student8);
            this.expectedResults = new ArrayList<Student>();
            this.expectedResults.addAll(studentList1);
            ArrayList<Student> studentList2 = new ArrayList<Student>();
            studentList2.add(student3);
            studentList2.add(student4);
            ArrayList<Student> studentList3 = new ArrayList<Student>();
            studentList3.add(student5);
            studentList3.add(student6);
            ArrayList<Student> studentList4 = new ArrayList<Student>();
            studentList4.add(student7);
            studentList4.add(student8);
            appliedMath.setStudents(studentList1);
            physics.setStudents(studentList1);
            operationResearch.setStudents(studentList1);
            statistics.setStudents(studentList2);
            operatingSystem.setStudents(studentList2);
            ArrayList<Course> firstSemCourses = new ArrayList<Course>();
            firstSemCourses.add(appliedMath);
            firstSemCourses.add(physics);
            firstSemCourses.add(operationResearch);
            ArrayList<Course> secondSemCourses = new ArrayList<Course>();
            secondSemCourses.add(statistics);
            secondSemCourses.add(operatingSystem);
            student1.setCourses(firstSemCourses);
            student2.setCourses(firstSemCourses);
            student3.setCourses(secondSemCourses);
            student4.setCourses(secondSemCourses);
            student5.setCourses(secondSemCourses);
            student6.setCourses(secondSemCourses);
            student7.setCourses(firstSemCourses);
            student8.setCourses(firstSemCourses);
            EntityManager entityManager = this.getEntityManager();
            entityManager.persist((Object)student1);
            entityManager.persist((Object)student2);
            entityManager.persist((Object)student3);
            entityManager.persist((Object)student4);
            entityManager.persist((Object)student5);
            entityManager.persist((Object)student6);
            entityManager.persist((Object)student7);
            entityManager.persist((Object)student8);
            TestUtil.logTrace((String)"persisted 8 students");
            entityManager.persist((Object)appliedMath);
            entityManager.persist((Object)physics);
            entityManager.persist((Object)operationResearch);
            entityManager.persist((Object)statistics);
            entityManager.persist((Object)operatingSystem);
            TestUtil.logTrace((String)"persisted 5 Courses");
            TestUtil.logTrace((String)"persisted Entity Data");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEmployeeTestData() throws Exception {
        try {
            TestUtil.logTrace((String)"createEmployeeTestData");
            this.getEntityTransaction().begin();
            Department d1 = new Department(50, "Dept1");
            Department2 d2 = new Department2(55, "Dept2");
            this.getEntityManager().persist((Object)d1);
            Employee e1 = new Employee(20, "Jie", "Leng", 0.0f, d1);
            Employee e2 = new Employee(40, "Zoe", "Leng", 0.0f, d1);
            Employee e3 = new Employee(60, "John", "Smith", 0.0f, d1);
            Employee2 e4 = new Employee2(80, "Song", "Leng", 0.0f, d2);
            Employee2 e5 = new Employee2(100, "May", "Leng", 0.0f, d2);
            Employee2 e6 = new Employee2(120, "Donny", "Oz", 0.0f, d2);
            this.getEntityManager().persist((Object)e1);
            this.getEntityManager().persist((Object)e2);
            this.getEntityManager().persist((Object)e3);
            this.getEntityManager().persist((Object)e4);
            this.getEntityManager().persist((Object)e5);
            this.getEntityManager().persist((Object)e6);
            this.expectedEmployees = new ArrayList<Employee>();
            this.expectedEmployees.add(e3);
            this.expectedEmployees.add(e1);
            this.expectedEmployees.add(e2);
            d1.setEmployees(this.expectedEmployees);
            this.getEntityManager().merge((Object)d1);
            this.expectedEmployees2 = new ArrayList<Employee2>();
            this.expectedEmployees2.add(e6);
            this.expectedEmployees2.add(e4);
            this.expectedEmployees2.add(e5);
            d2.setEmployees(this.expectedEmployees2);
            this.getEntityManager().merge((Object)d2);
            TestUtil.logTrace((String)"persisted Entity Data");
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    public void cleanupEmployee() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanupEmployee");
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from COURSE_STUDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from STUDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from COURSE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }

    private void removeEmployeeTestData() {
        TestUtil.logTrace((String)"removeEmployeeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("Delete from EMPLOYEE").executeUpdate();
            this.getEntityManager().createNativeQuery("Delete from DEPARTMENT").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

