/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.annotations.entity;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.annotations.entity.Coffee;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    private static Coffee[] cRef = new Coffee[5];

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
            TestUtil.logTrace((String)"Create Test data");
            this.createTestData();
            TestUtil.logTrace((String)"Done creating test data");
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationEntityTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin annotationEntityTest1");
        boolean pass = true;
        List c = null;
        try {
            this.getEntityTransaction().begin();
            Object[] expectedBrands = new String[]{"vanilla creme", "mocha", "hazelnut", "decaf", "breakfast blend"};
            TestUtil.logTrace((String)"find coffees by brand name");
            c = this.getEntityManager().createQuery("Select c.brandName from cof c ORDER BY c.brandName DESC").setMaxResults(10).getResultList();
            Object[] result = c.toArray(new String[c.size()]);
            TestUtil.logTrace((String)"Compare results of Coffee Brand Names");
            pass = Arrays.equals(expectedBrands, result);
            if (!pass) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 5 Coffees : vanilla creme, mocha, hazelnut, decaf, breakfast blend.  Received: " + c.size()));
                Iterator it = c.iterator();
                while (it.hasNext()) {
                    TestUtil.logTrace((String)(" Coffee Brand Name: " + it.next()));
                }
            } else {
                TestUtil.logTrace((String)"Expected results received");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass) {
            throw new EETest.Fault("annotationEntityTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotationEntityTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"Begin annotationEntityTest2");
        boolean pass1 = true;
        boolean pass2 = false;
        List c = null;
        try {
            this.getEntityTransaction().begin();
            Integer[] expectedPKs = new Integer[]{21, 22, 23, 24, 25};
            TestUtil.logTrace((String)"find all coffees");
            c = this.getEntityManager().createQuery("Select c from cof c").setMaxResults(10).getResultList();
            if (c.size() != 5) {
                TestUtil.logErr((String)("Did not get expected results.  Expected 5 references, got: " + c.size()));
                pass1 = false;
            } else if (pass1) {
                TestUtil.logTrace((String)"Expected size received, verify contents . . . ");
                Iterator i = c.iterator();
                int foundCof = 0;
                block11: while (i.hasNext()) {
                    TestUtil.logTrace((String)"Check List for expected coffees");
                    Coffee o = (Coffee)i.next();
                    for (int l = 0; l < 5; ++l) {
                        if (!expectedPKs[l].equals(o.getId())) continue;
                        TestUtil.logTrace((String)("Found coffee with PK: " + o.getId()));
                        ++foundCof;
                        continue block11;
                    }
                }
                if (foundCof != 5) {
                    TestUtil.logErr((String)"anotationEntityTest2: Did not get expected results");
                    pass2 = false;
                } else {
                    TestUtil.logTrace((String)"Expected results received");
                    pass2 = true;
                }
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            pass2 = false;
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
        if (!pass1 || !pass2) {
            throw new EETest.Fault("annotationEntityTest1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestData() throws Exception {
        try {
            TestUtil.logTrace((String)"createTestData");
            this.getEntityTransaction().begin();
            TestUtil.logTrace((String)"Create 5 Coffees");
            Client.cRef[0] = new Coffee(Integer.valueOf(21), "hazelnut", 1.0f);
            Client.cRef[1] = new Coffee(Integer.valueOf(22), "vanilla creme", 2.0f);
            Client.cRef[2] = new Coffee(Integer.valueOf(23), "decaf", 3.0f);
            Client.cRef[3] = new Coffee(Integer.valueOf(24), "breakfast blend", 4.0f);
            Client.cRef[4] = new Coffee(Integer.valueOf(25), "mocha", 5.0f);
            TestUtil.logTrace((String)"Start to persist coffees ");
            for (Coffee coffee : cRef) {
                this.getEntityManager().persist((Object)coffee);
                TestUtil.logTrace((String)("persisted coffee " + coffee));
            }
            this.getEntityManager().flush();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected Exception creating test data:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in rollback:", (Throwable)re);
            }
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM COFFEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

