/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.deploy.entity.cmp20.single;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.tests.ejb.ee.deploy.entity.cmp20.single.Single;
import com.sun.ts.tests.ejb.ee.deploy.entity.cmp20.single.SingleHome;
import java.util.Properties;

public class Client
extends EETest {
    private static final String testLookup = "java:comp/env/ejb/TestBean";
    private static final String testName = "com.sun.ts.tests.ejb.ee.deploy.entity.cmp20.single.Single";
    private static final String refIdString = "Entity CMP 2.0 Single Remote";
    private TSNamingContext nctx = null;
    private SingleHome home = null;
    private Single bean = null;
    private Properties props = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Looking up up java:comp/env/ejb/TestBean...");
            this.nctx = new TSNamingContext();
            this.home = (SingleHome)this.nctx.lookup(testLookup, SingleHome.class);
            this.logMsg("Setup OK!");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void testIsSession() throws EETest.Fault {
        try {
            if (this.home.getEJBMetaData().isSession()) {
                throw new EETest.Fault("isSession() test failed [is true]");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("isSession() test failed: " + e, e);
        }
    }

    public void testIsStateless() throws EETest.Fault {
        try {
            boolean pass;
            boolean bl = pass = !this.home.getEJBMetaData().isStatelessSession();
            if (!pass) {
                this.logErr("[Client] isStatelessSession() reported '" + pass + "'");
                throw new EETest.Fault("isStatelessSession() test failed");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("isStatelessSession() test failed: " + e, e);
        }
    }

    public void testGetPrimaryKey() throws EETest.Fault {
        try {
            this.bean = this.home.create(this.props, 1, "coffee-1", 1.0f);
            Object pkey = this.bean.getPrimaryKey();
            this.bean.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("getPrimaryKey() test failed: " + e, e);
        }
    }

    public void testHomeInterface() throws EETest.Fault {
        Class runtimeHome = null;
        boolean pass = false;
        try {
            runtimeHome = this.home.getEJBMetaData().getHomeInterfaceClass();
            pass = runtimeHome.getName().equals("com.sun.ts.tests.ejb.ee.deploy.entity.cmp20.single.SingleHome");
            if (!pass) {
                throw new EETest.Fault("getHomeInterface() test failed ");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("getHomeInterface() test failed: " + e, e);
        }
    }

    public void testRemoteInterface() throws EETest.Fault {
        Class runtimeRemote = null;
        boolean pass = false;
        try {
            runtimeRemote = this.home.getEJBMetaData().getRemoteInterfaceClass();
            pass = runtimeRemote.getName().equals(testName);
            if (!pass) {
                throw new EETest.Fault("getRemoteInterface() test failed ");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("getRemoteInterface() test failed: " + e, e);
        }
    }

    public void testCreate() throws EETest.Fault {
        try {
            this.bean = this.home.create(this.props, 1, "coffee-1", 1.0f);
            this.bean.remove();
        }
        catch (Exception e) {
            throw new EETest.Fault("Test special create failed: ", e);
        }
    }

    public void testBusinessMethod() throws EETest.Fault {
        try {
            this.bean = this.home.create(this.props, 1, "coffee-1", 1.0f);
            String id = this.bean.getIdString();
            this.logTrace("[Client] got Identification string '" + id + "'");
            boolean pass = id.equals(refIdString);
            this.bean.remove();
            if (!pass) {
                this.logErr("[Client] home interface mismatch!");
                throw new EETest.Fault("Remote interface test failed, expected 'Entity CMP 2.0 Single Remote'");
            }
        }
        catch (Exception e) {
            throw new EETest.Fault("Remote interface test failed: " + e, e);
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("[Client] cleanup()");
    }
}

