/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaxws.wsa.common;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxws.common.JAXWS_Util;
import com.sun.ts.tests.jaxws.wsa.common.AddressingHeaderException;
import com.sun.ts.tests.jaxws.wsa.common.AddressingPropertyException;
import com.sun.ts.tests.jaxws.wsa.common.W3CAddressingConstants;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.Text;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsaBaseSOAPHandler
implements SOAPHandler<SOAPMessageContext> {
    public boolean handleMessage(SOAPMessageContext context) {
        boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
        if (outbound) {
            TestUtil.logMsg((String)"Direction=outbound");
            if (this.whichHandler().equals("ServerSOAPHandler")) {
                System.out.println("Direction=outbound");
            }
        } else {
            TestUtil.logMsg((String)"Direction=inbound");
            if (this.whichHandler().equals("ServerSOAPHandler")) {
                System.out.println("Direction=inbound");
            }
        }
        try {
            SOAPBody soapBody;
            SOAPMessage msg = context.getMessage();
            JAXWS_Util.dumpSOAPMessage(msg, true);
            if (this.whichHandler().equals("ServerSOAPHandler")) {
                JAXWS_Util.dumpSOAPMessage(msg, false);
            }
            if ((soapBody = this.getSOAPBody(context)) != null && soapBody.getFirstChild() != null) {
                String oper = this.getOperationName(soapBody);
                String testName = this.getTestName(soapBody);
                context.put((Object)"op.name", (Object)oper);
                context.put((Object)"test.name", (Object)testName);
                if (!outbound) {
                    this.checkInboundAction(context, oper, this.getAction(context));
                    this.checkInboundTo(context);
                    this.checkInboundReplyTo(context);
                    this.checkInboundMessageId(context);
                    this.checkInboundRelationship(context);
                    this.checkInboundRelatesTo(context);
                    this.processInboundMessage(context, oper, testName);
                } else {
                    this.processOutboundMessage(context, oper, testName);
                }
            }
        }
        catch (SOAPException e) {
            e.printStackTrace();
        }
        return true;
    }

    public boolean handleFault(SOAPMessageContext context) {
        block10: {
            boolean outbound = (Boolean)context.get((Object)"javax.xml.ws.handler.message.outbound");
            if (outbound) {
                TestUtil.logMsg((String)"Direction=outbound");
                if (this.whichHandler().equals("ServerSOAPHandler")) {
                    System.out.println("Direction=outbound");
                }
            } else {
                TestUtil.logMsg((String)"Direction=inbound");
                if (this.whichHandler().equals("ServerSOAPHandler")) {
                    System.out.println("Direction=inbound");
                }
            }
            if (!outbound) {
                try {
                    SOAPMessage msg = context.getMessage();
                    JAXWS_Util.dumpSOAPMessage(msg, true);
                    if (this.whichHandler().equals("ServerSOAPHandler")) {
                        JAXWS_Util.dumpSOAPMessage(msg, false);
                    }
                    if (context.getMessage().getSOAPBody().getFault() == null) break block10;
                    String detailName = null;
                    try {
                        detailName = context.getMessage().getSOAPBody().getFault().getDetail().getFirstChild().getLocalName();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.checkFaultActions((String)context.get((Object)"op.name"), detailName, this.getAction(context));
                }
                catch (SOAPException e) {
                    e.printStackTrace();
                }
            }
        }
        return true;
    }

    public Set<QName> getHeaders() {
        return null;
    }

    public void close(MessageContext messageContext) {
    }

    protected SOAPBody getSOAPBody(SOAPMessageContext context) throws SOAPException {
        SOAPBody soapBody = context.getMessage().getSOAPBody();
        return soapBody;
    }

    protected String getAction(SOAPMessageContext context) throws SOAPException {
        String action = null;
        try {
            SOAPMessage message = context.getMessage();
            SOAPHeader header = message.getSOAPHeader();
            Iterator iter = header.getChildElements(W3CAddressingConstants.WSA_ACTION_QNAME);
            if (!iter.hasNext()) {
                throw new AddressingHeaderException("WsaBaseSOAPHandler:getAction: Element not found:" + W3CAddressingConstants.WSA_ACTION_QNAME);
            }
            Node node = (Node)iter.next();
            action = node.getFirstChild().getNodeValue();
        }
        catch (SOAPException e) {
            throw new AddressingHeaderException("WsaBaseSOAPHandler:getAction: Element not found:" + W3CAddressingConstants.WSA_ACTION_QNAME);
        }
        return action;
    }

    protected String getTo(SOAPMessageContext context) throws SOAPException {
        String to = null;
        SOAPMessage message = context.getMessage();
        SOAPHeader header = message.getSOAPHeader();
        Iterator iter = header.getChildElements(W3CAddressingConstants.WSA_TO_QNAME);
        if (iter.hasNext()) {
            to = "invalid";
            int i = 0;
            NodeList nodes = ((Element)iter.next()).getChildNodes();
            if (i < nodes.getLength()) {
                Node node = nodes.item(i);
                return node.getNodeValue();
            }
        } else {
            throw new AddressingHeaderException("WsaBaseSOAPHandler:getTo: Element not found:" + W3CAddressingConstants.WSA_TO_QNAME);
        }
        return to;
    }

    protected String getReplyTo(SOAPMessageContext context) throws SOAPException {
        String replyTo = null;
        SOAPMessage message = context.getMessage();
        SOAPHeader header = message.getSOAPHeader();
        Iterator iter = header.getChildElements(W3CAddressingConstants.WSA_REPLYTO_QNAME);
        if (iter.hasNext()) {
            replyTo = "invalid";
            NodeList nodes = ((Element)iter.next()).getChildNodes();
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (node instanceof Text || !node.getLocalName().equals("Address") || !node.getNamespaceURI().equals("http://www.w3.org/2005/08/addressing")) continue;
                return node.getFirstChild().getNodeValue();
            }
        } else {
            throw new AddressingHeaderException("WsaBaseSOAPHandler:getReplyTo: Element not found:" + W3CAddressingConstants.WSA_REPLYTO_QNAME);
        }
        return replyTo;
    }

    protected String getMessageId(SOAPMessageContext context) throws SOAPException {
        SOAPMessage message = context.getMessage();
        SOAPHeader header = message.getSOAPHeader();
        Iterator iter = header.getChildElements(W3CAddressingConstants.WSA_MESSAGEID_QNAME);
        if (!iter.hasNext()) {
            throw new AddressingHeaderException("WsaBaseSOAPHandler:getMessageId: Element not found:" + W3CAddressingConstants.WSA_MESSAGEID_QNAME);
        }
        Node node = (Node)iter.next();
        String mid = node.getFirstChild().getNodeValue();
        return mid;
    }

    protected String getRelatesTo(SOAPMessageContext context) throws SOAPException {
        SOAPMessage message = context.getMessage();
        SOAPHeader header = message.getSOAPHeader();
        Iterator iter = header.getChildElements(W3CAddressingConstants.WSA_RELATESTO_QNAME);
        if (!iter.hasNext()) {
            throw new AddressingHeaderException("WsaBaseSOAPHandler:getRelatesTo: Element not found:" + W3CAddressingConstants.WSA_RELATESTO_QNAME);
        }
        Node node = (Node)iter.next();
        String relatesTo = node.getFirstChild().getNodeValue();
        return relatesTo;
    }

    protected String getActionDoesNotExist(SOAPMessageContext context) throws SOAPException {
        String action = null;
        try {
            SOAPMessage message = context.getMessage();
            SOAPHeader header = message.getSOAPHeader();
            Iterator iter = header.getChildElements(W3CAddressingConstants.WSA_ACTION_QNAME);
            if (iter.hasNext()) {
                Node node = (Node)iter.next();
                action = node.getFirstChild().getNodeValue();
            }
        }
        catch (SOAPException e) {
            action = null;
        }
        return action;
    }

    protected String getRelationship(SOAPMessageContext context) throws SOAPException {
        SOAPMessage message = context.getMessage();
        SOAPHeader header = message.getSOAPHeader();
        Iterator iter = header.getChildElements(W3CAddressingConstants.WSA_RELATIONSHIPTYPE_QNAME);
        if (!iter.hasNext()) {
            throw new AddressingHeaderException("WsaBaseSOAPHandler:getRelationship: Element not found:" + W3CAddressingConstants.WSA_RELATIONSHIPTYPE_QNAME);
        }
        Node node = (Node)iter.next();
        String relationship = node.getFirstChild().getNodeValue();
        return relationship;
    }

    protected String getOperationName(SOAPBody soapBody) throws SOAPException {
        return soapBody.getFirstChild().getLocalName();
    }

    protected String getTestName(SOAPBody soapbody) throws SOAPException {
        String testName = null;
        SOAPElement se = null;
        Iterator i = soapbody.getChildElements();
        if (i.hasNext()) {
            se = (SOAPElement)i.next();
            i = se.getChildElements();
            while (i.hasNext()) {
                se = (SOAPElement)i.next();
                String elementName = se.getElementName().getLocalName();
                SOAPElement node = se;
                String elementValue = node.getFirstChild().getNodeValue();
                if (!elementName.equals("testName")) continue;
                testName = elementValue;
                break;
            }
        }
        return testName;
    }

    protected void checkFaultActions(String requestName, String detailName, String action) {
    }

    protected void checkInboundAction(SOAPMessageContext context, String oper, String action) {
    }

    protected void checkInboundTo(SOAPMessageContext context) {
    }

    protected void checkInboundReplyTo(SOAPMessageContext context) {
    }

    protected void checkInboundMessageId(SOAPMessageContext context) {
    }

    protected void checkInboundRelationship(SOAPMessageContext context) {
    }

    protected void checkInboundRelatesTo(SOAPMessageContext context) {
    }

    protected void processOutboundMessage(SOAPMessageContext context, String oper, String testName) {
    }

    protected void processInboundMessage(SOAPMessageContext context, String oper, String testName) {
    }

    protected String whichHandler() {
        return "WsaBaseSOAPHandler";
    }

    protected void checkInboundToExist(SOAPMessageContext context) {
        String to = null;
        try {
            to = this.getTo(context);
            TestUtil.logMsg((String)(this.whichHandler() + ".checkInboundToExist: [To=" + to + "]"));
            if (this.whichHandler().equals("ServerSOAPHandler")) {
                System.out.println(this.whichHandler() + ".checkInboundToExist: [To=" + to + "]");
            }
        }
        catch (Exception e) {
            return;
        }
        if (to == null) {
            throw new AddressingPropertyException("wsa:To contains null");
        }
        if (to.equals("invalid")) {
            throw new AddressingPropertyException("wsa:To contains an invalid value");
        }
        if (to.equals("")) {
            throw new AddressingPropertyException("wsa:To contains an empty value");
        }
    }

    protected void checkInboundRelatesToExist(SOAPMessageContext context) {
        String relatesto = null;
        Object mid = null;
        try {
            relatesto = this.getRelatesTo(context);
            TestUtil.logMsg((String)(this.whichHandler() + ".checkInboundRelatesToExist: [RelatesTo=" + relatesto + "]"));
            if (this.whichHandler().equals("ServerSOAPHandler")) {
                System.out.println(this.whichHandler() + ".checkInboundRelatesToExist: [RelatesTo=" + relatesto + "]");
            }
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        if (relatesto == null) {
            throw new AddressingPropertyException("wsa:RelatesTo contains null");
        }
        if (relatesto.equals("")) {
            throw new AddressingPropertyException("wsa:RelatesTo contains an empty value");
        }
    }

    protected void checkInboundMessageIdExist(SOAPMessageContext context) {
        String mid = null;
        try {
            mid = this.getMessageId(context);
            TestUtil.logMsg((String)(this.whichHandler() + ".checkInboundMessageIdExist: [MessageId=" + mid + "]"));
            if (this.whichHandler().equals("ServerSOAPHandler")) {
                System.out.println(this.whichHandler() + ".checkInboundMessageIdExist: [MessageId=" + mid + "]");
            }
        }
        catch (Exception e) {
            throw new WebServiceException((Throwable)e);
        }
        if (mid == null) {
            throw new AddressingPropertyException("wsa:MessageId contains null");
        }
        if (mid.equals("")) {
            throw new AddressingPropertyException("wsa:MessageId contains an empty value");
        }
    }

    protected void checkInboundReplyToExist(SOAPMessageContext context) {
        String replyto = null;
        try {
            replyto = this.getReplyTo(context);
            TestUtil.logMsg((String)(this.whichHandler() + ".checkInboundReplyToExist: [ReplyTo=" + replyto + "]"));
            if (this.whichHandler().equals("ServerSOAPHandler")) {
                System.out.println(this.whichHandler() + ".checkInboundReplyToExist: [ReplyTo=" + replyto + "]");
            }
        }
        catch (Exception e) {
            return;
        }
        if (replyto == null) {
            throw new AddressingPropertyException("wsa:ReplyTo contains null");
        }
        if (replyto.equals("invalid")) {
            throw new AddressingPropertyException("wsa:ReplyTo contains an invalid value");
        }
        if (replyto.equals("")) {
            throw new AddressingPropertyException("wsa:ReplyTo contains an empty value");
        }
    }

    protected void checkActionDoesNotExist(String action) {
        TestUtil.logMsg((String)(this.whichHandler() + ".checkActionDoesNotExist"));
        if (this.whichHandler().equals("ServerSOAPHandler")) {
            System.out.println(this.whichHandler() + ".checkActionDoesNotExist");
        }
        if (action != null) {
            throw new AddressingPropertyException("wsa:Action header exists (unexpected)");
        }
    }

    protected void checkInboundToDoesNotExist(SOAPMessageContext context) {
        TestUtil.logMsg((String)(this.whichHandler() + ".checkInboundToDoesNotExist"));
        if (this.whichHandler().equals("ServerSOAPHandler")) {
            System.out.println(this.whichHandler() + ".checkInboundToDoesNotExist");
        }
        boolean pass = false;
        try {
            this.getTo(context);
        }
        catch (Exception e) {
            pass = true;
        }
        if (!pass) {
            throw new AddressingPropertyException("wsa:To header exists (unexpected)");
        }
    }

    protected void checkInboundRelatesToDoesNotExist(SOAPMessageContext context) {
        TestUtil.logMsg((String)(this.whichHandler() + ".checkInboundRelatesToDoesNotExist"));
        if (this.whichHandler().equals("ServerSOAPHandler")) {
            System.out.println(this.whichHandler() + ".checkInboundRelatesToDoesNotExist");
        }
        boolean pass = false;
        try {
            this.getRelatesTo(context);
        }
        catch (Exception e) {
            pass = true;
        }
        if (!pass) {
            throw new AddressingPropertyException("wsa:RelatesTo header exists (unexpected)");
        }
    }

    protected void checkInboundMessageIdDoesNotExist(SOAPMessageContext context) {
        TestUtil.logMsg((String)(this.whichHandler() + ".checkInboundMessageIdDoesNotExist"));
        if (this.whichHandler().equals("ServerSOAPHandler")) {
            System.out.println(this.whichHandler() + ".checkInboundMessageIdDoesNotExist");
        }
        boolean pass = false;
        try {
            this.getMessageId(context);
        }
        catch (Exception e) {
            pass = true;
        }
        if (!pass) {
            throw new AddressingPropertyException("wsa:MessageId header exists (unexpected)");
        }
    }

    protected void checkInboundReplyToDoesNotExist(SOAPMessageContext context) {
        TestUtil.logMsg((String)(this.whichHandler() + ".checkInboundReplyToDoesNotExist"));
        if (this.whichHandler().equals("ServerSOAPHandler")) {
            System.out.println(this.whichHandler() + ".checkInboundReplyToDoesNotExist");
        }
        boolean pass = false;
        try {
            this.getReplyTo(context);
        }
        catch (Exception e) {
            pass = true;
        }
        if (!pass) {
            throw new AddressingPropertyException("wsa:ReplyTo header exists (unexpected)");
        }
    }
}

