/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.bb.session.stateful.equals.annotated;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.tests.ejb30.common.equals.CartIF;
import com.sun.ts.tests.ejb30.common.equals.ClientBase;
import com.sun.ts.tests.ejb30.common.equals.Comparator;
import com.sun.ts.tests.ejb30.common.equals.ShoppingCartIF;
import com.sun.ts.tests.ejb30.common.helper.ServiceLocator;
import com.sun.ts.tests.ejb30.common.helper.TLogger;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import javax.ejb.EJB;
import javax.naming.NamingException;

public class Client
extends ClientBase {
    @EJB(name="cart", beanName="cart-bean")
    private static CartIF cart;
    @EJB(name="cartOther", beanName="cart-bean")
    private static CartIF cartOther;
    @EJB(name="shoppingCart", beanName="shopping-cart-bean")
    private static ShoppingCartIF shoppingCart;
    @EJB(name="shoppingCartOther", beanName="shopping-cart-bean")
    private static ShoppingCartIF shoppingCartOther;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void equalsNull() throws TestFailedException {
        TLogger.log("Comparing " + cart + " to " + null + ", expecting false.");
        Comparator.compare(cart, null, false, true);
        TLogger.log("Comparing " + cartOther + " to " + null + ", expecting false.");
        Comparator.compare(cartOther, null, false, true);
        TLogger.log("Comparing " + shoppingCart + " to " + null + ", expecting false.");
        Comparator.compare(shoppingCart, null, false, true);
        TLogger.log("Comparing " + shoppingCartOther + " to " + null + ", expecting false.");
        Comparator.compare(shoppingCartOther, null, false, true);
    }

    public void selfEquals() throws EETest.Fault {
        try {
            Comparator.compare(cart, cart, true, true);
            Comparator.compare(shoppingCart, shoppingCart, true, true);
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }

    public void selfEqualsLookup() throws EETest.Fault {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Comparator.compare(cart, cart, true, true);
            Comparator.compare(shoppingCart, shoppingCart, true, true);
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
        catch (NamingException e) {
            throw new EETest.Fault(e);
        }
    }

    public void otherNotEquals() throws EETest.Fault {
        try {
            Comparator.compare(cart, cartOther, false, true);
            Comparator.compare(shoppingCart, shoppingCartOther, false, true);
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }

    public void otherNotEqualsLookup() throws EETest.Fault {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object cartOther = ServiceLocator.lookupByShortName("cartOther");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Object shoppingCartOther = ServiceLocator.lookupByShortName("shoppingCartOther");
            Comparator.compare(cart, cartOther, cart, false, true);
            Comparator.compare(shoppingCart, shoppingCartOther, shoppingCart, false, true);
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
        catch (NamingException e) {
            throw new EETest.Fault(e);
        }
    }

    public void differentInterfaceNotEqual() throws EETest.Fault {
        try {
            Comparator.compare(cart, shoppingCart, false, true);
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
    }

    public void differentInterfaceNotEqualLookup() throws EETest.Fault {
        try {
            Object cart = ServiceLocator.lookupByShortName("cart");
            Object shoppingCart = ServiceLocator.lookupByShortName("shoppingCart");
            Comparator.compare(cart, shoppingCart, false, true);
        }
        catch (TestFailedException e) {
            throw new EETest.Fault(e);
        }
        catch (NamingException e) {
            throw new EETest.Fault(e);
        }
    }
}

