/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.concurrency.api.LastExecution;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.concurrency.api.LastExecution.LogicDrivenTrigger;
import com.sun.ts.tests.concurrency.api.common.Util;
import com.sun.ts.tests.concurrency.common.counter.CounterCallableTask;
import com.sun.ts.tests.concurrency.common.counter.CounterRunnableTask;
import com.sun.ts.tests.concurrency.common.counter.StaticCounter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledFuture;
import javax.enterprise.concurrent.ManagedExecutors;
import javax.enterprise.concurrent.ManagedScheduledExecutorService;
import javax.enterprise.concurrent.Trigger;
import javax.naming.InitialContext;

public class Client
extends ServiceEETest
implements Serializable {
    InitialContext context;
    ManagedScheduledExecutorService executorService;
    public static final String IDENTITY_NAME_TEST_ID = "lastExecutionGetIdentityNameTest";

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            this.context = new InitialContext();
            this.executorService = (ManagedScheduledExecutorService)this.context.lookup("java:comp/DefaultManagedScheduledExecutorService");
            StaticCounter.reset();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
    }

    public void lastExecutionGetIdentityNameTest() throws EETest.Fault {
        HashMap<String, String> executionProperties = new HashMap<String, String>();
        executionProperties.put("javax.enterprise.concurrent.IDENTITY_NAME", IDENTITY_NAME_TEST_ID);
        ScheduledFuture sf = this.executorService.schedule(ManagedExecutors.managedTask((Runnable)new CounterRunnableTask(), executionProperties, null), (Trigger)new LogicDrivenTrigger(5000L, IDENTITY_NAME_TEST_ID));
        Util.waitTillFutureIsDone(sf);
        if (StaticCounter.getCount() != 2) {
            throw new EETest.Fault("Got wrong identity name. See server log for more details.");
        }
    }

    public void lastExecutionGetResultTest() throws EETest.Fault {
        ScheduledFuture sf = this.executorService.schedule(ManagedExecutors.managedTask((Runnable)new CounterRunnableTask(), null, null), (Trigger)new LogicDrivenTrigger(5000L, "lastExecutionGetResultTest_runnable"));
        Util.waitTillFutureIsDone(sf);
        if (StaticCounter.getCount() != 2) {
            throw new EETest.Fault("Got wrong last execution result. See server log for more details.");
        }
        StaticCounter.reset();
        sf = this.executorService.schedule(ManagedExecutors.managedTask((Callable)new CounterCallableTask(), null, null), (Trigger)new LogicDrivenTrigger(5000L, "lastExecutionGetResultTest_callable"));
        Util.waitTillFutureIsDone(sf);
        if (StaticCounter.getCount() != 2) {
            throw new EETest.Fault("Got wrong last execution result. See server log for more details.");
        }
    }

    public void lastExecutionGetRunningTimeTest() throws EETest.Fault {
        ScheduledFuture sf = this.executorService.schedule(ManagedExecutors.managedTask((Runnable)new CounterRunnableTask(5000L), null, null), (Trigger)new LogicDrivenTrigger(5000L, "lastExecutionGetRunningTimeTest"));
        Util.waitTillFutureIsDone(sf);
        if (StaticCounter.getCount() != 2) {
            throw new EETest.Fault("Got wrong last execution result.");
        }
    }
}

