/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices.deploy.GenSvc;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Data;
import com.sun.ts.tests.jaxrpc.common.JAXRPC_Util;
import com.sun.ts.tests.webservices.deploy.GenSvc.Tests;
import com.sun.ts.tests.webservices.deploy.GenSvc.TestsGenSvc;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.naming.InitialContext;
import javax.xml.namespace.QName;
import javax.xml.rpc.Call;
import javax.xml.rpc.JAXRPCException;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import javax.xml.rpc.encoding.TypeMappingRegistry;
import javax.xml.rpc.handler.HandlerRegistry;

public class Client
extends ServiceEETest {
    private static final String PROTOCOL = "http";
    private static final String HOSTNAME = "localhost";
    private static final int PORTNUM = 8000;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private final String NAMESPACEURI = "http://testsgensvc.org/wsdl";
    private QName SERVICE_QNAME;
    private QName PORT_QNAME;
    private QName BAD_PORT_QNAME;
    private QName QNAME_TYPE_STRING;
    private String SERVICE_NAME_WITH_WSDL = "service";
    private String SERVICE_NAME_WITH_WSDL_NO_PCREF = "service_no_pcref";
    private TSURL ctsurl = new TSURL();
    private Properties props = null;
    private String hostname = "localhost";
    private int portnum = 8000;
    private static final String ENDPOINT_URL = "gensvc.endpoint.1";
    private String url = null;

    private void getTestURLs() throws Exception {
        TestUtil.logMsg((String)"Get JAXRPC porting instance");
        TestUtil.logMsg((String)"Get URL's used by the test");
        String file = JAXRPC_Util.getURLFromProp(ENDPOINT_URL);
        this.url = this.ctsurl.getURLString(PROTOCOL, this.hostname, this.portnum, file);
        TestUtil.logMsg((String)("Service Endpoint URL: " + this.url));
    }

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        boolean pass = true;
        this.SERVICE_QNAME = new QName("http://testsgensvc.org/wsdl", "TestsGenSvc");
        this.PORT_QNAME = new QName("http://testsgensvc.org/wsdl", "TestsPort");
        this.BAD_PORT_QNAME = new QName("http://testsgensvc.org/wsdl", "BadPort");
        this.QNAME_TYPE_STRING = new QName("http://www.w3.org/2001/XMLSchema", "string");
        try {
            this.hostname = p.getProperty(WEBSERVERHOSTPROP);
            if (this.hostname == null) {
                pass = false;
            } else if (this.hostname.equals("")) {
                pass = false;
            }
            try {
                this.portnum = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                pass = false;
            }
            this.getTestURLs();
        }
        catch (Exception e) {
            throw new EETest.Fault("setup failed:", e);
        }
        if (!pass) {
            TestUtil.logErr((String)"Please specify host & port of web server in config properties: webServerHost, webServerPort");
            throw new EETest.Fault("setup failed:");
        }
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public void CreateCallConstructor1Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor1Test1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Create Call object via TestsGenSvc.createCall()");
            Call call = genService.createCall();
            if (call == null) {
                TestUtil.logErr((String)"createCall() returned null");
                pass = false;
            } else if (!(call instanceof Call)) {
                TestUtil.logErr((String)"createCall() did not return instance of Call object");
                pass = false;
            } else {
                TestUtil.logMsg((String)"Call object successfully created");
                TestUtil.logMsg((String)"Fillin rest of Call object and invoke RPC method");
                call = JAXRPC_Util.setCallProperties(call, " ");
                call.setTargetEndpointAddress(this.url);
                TestUtil.logMsg((String)"Set operation name to InvokeTest2");
                call.setOperationName(new QName("http://testsgensvc.org/wsdl", "invokeTest2"));
                boolean b = call.isParameterAndReturnSpecRequired(new QName("http://testsgensvc.org/wsdl", "invokeTest2"));
                if (b) {
                    call.setReturnType(this.QNAME_TYPE_STRING);
                    call.addParameter("BigInteger_1", new QName("http://www.w3.org/2001/XMLSchema", "integer"), ParameterMode.IN);
                    call.addParameter("BigDecimal_2", new QName("http://www.w3.org/2001/XMLSchema", "decimal"), ParameterMode.IN);
                    call.addParameter("QName_3", new QName("http://www.w3.org/2001/XMLSchema", "QName"), ParameterMode.IN);
                    call.addParameter("String_4", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
                }
                Object[] params = new Object[]{JAXRPC_Data.BigInteger_data[0], JAXRPC_Data.BigDecimal_data[0], JAXRPC_Data.QName_data[0], JAXRPC_Data.String_data[0]};
                TestUtil.logMsg((String)"Attempt to invoke RPC method Tests(\"InvokeTest2\")");
                String expected = "passed";
                String response = (String)call.invoke(params);
                if (!response.equals(expected)) {
                    TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor1Test1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor1Test1 failed");
        }
    }

    public void CreateCallConstructor2Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor2Test1");
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Create Call object via TestsGenSvc.createCall(QName)");
            try {
                Call call = genService.createCall(this.PORT_QNAME);
                pass = true;
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor2Test1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor2Test1 failed");
        }
    }

    public void CreateCallConstructor3Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor3Test1");
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Create Call object via TestsGenSvc.createCall(QName, QName)");
            QName OPERATION_QNAME = new QName("http://testsgensvc.org/wsdl", "invokeTest2");
            TestUtil.logMsg((String)("QName = " + this.PORT_QNAME + ", Operation = " + OPERATION_QNAME));
            try {
                Call call = genService.createCall(this.PORT_QNAME, OPERATION_QNAME);
                pass = true;
            }
            catch (UnsupportedOperationException e) {
                TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor3Test1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor3Test1 failed");
        }
    }

    public void CreateCallConstructor4Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"CreateCallConstructor4Test1");
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Create Call object via TestsGenSvce.createCall(QName, String)");
            String operation = "invokeTest2";
            TestUtil.logMsg((String)("QName = " + this.PORT_QNAME + ", Operation = " + operation));
            Call call = genService.createCall(this.PORT_QNAME, operation);
            if (call == null) {
                TestUtil.logErr((String)"createCall(QName, String) returned null");
            } else if (!(call instanceof Call)) {
                TestUtil.logErr((String)"createCall(QName, String) did not return instance of Call object");
            } else {
                TestUtil.logMsg((String)"Call object successfully created");
                TestUtil.logMsg((String)"Fillin rest of Call object and invoke RPC method");
                call = JAXRPC_Util.setCallProperties(call, " ");
                call.setTargetEndpointAddress(this.url);
                boolean b = call.isParameterAndReturnSpecRequired(new QName("http://testsgensvc.org/wsdl", "invokeTest2"));
                if (b) {
                    call.setReturnType(this.QNAME_TYPE_STRING);
                    call.addParameter("BigInteger_1", new QName("http://www.w3.org/2001/XMLSchema", "integer"), ParameterMode.IN);
                    call.addParameter("BigDecimal_2", new QName("http://www.w3.org/2001/XMLSchema", "decimal"), ParameterMode.IN);
                    call.addParameter("QName_3", new QName("http://www.w3.org/2001/XMLSchema", "QName"), ParameterMode.IN);
                    call.addParameter("String_4", new QName("http://www.w3.org/2001/XMLSchema", "string"), ParameterMode.IN);
                }
                Object[] params = new Object[]{JAXRPC_Data.BigInteger_data[0], JAXRPC_Data.BigDecimal_data[0], JAXRPC_Data.QName_data[0], JAXRPC_Data.String_data[0]};
                TestUtil.logMsg((String)"Attempt to invoke RPC method Tests(\"InvokeTest2\")");
                String expected = "passed";
                String response = (String)call.invoke(params);
                if (!response.equals(expected)) {
                    TestUtil.logErr((String)("RPC failed - expected \"" + expected + "\", received: " + response));
                    pass = false;
                } else {
                    TestUtil.logMsg((String)("RPC passed - received expected response: " + response));
                    pass = true;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("CreateCallConstructor4Test1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("CreateCallConstructor4Test1 failed");
        }
    }

    public void GetCallsPosTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetCallsPosTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test getCalls (valid port name/WSDL access) - positive test 1");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Get an array of Call objects via TestsGenSvc.getCalls(PORT_QNAME)");
            Call[] calls = genService.getCalls(this.PORT_QNAME);
            if (calls == null) {
                TestUtil.logErr((String)"getCalls() returned null");
                pass = false;
            } else if (!(calls instanceof Call[])) {
                TestUtil.logErr((String)"getCalls() did not return instance of Call[] objects");
                pass = false;
            } else {
                TestUtil.logMsg((String)"getCalls() successfully returned Call[] array");
                TestUtil.logMsg((String)("Array count = " + calls.length));
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetCallsPosTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetCallsPosTest1 failed");
        }
    }

    public void GetCallsNegTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"GetCallsNegTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test getCalls (invalid port name/WSDL acesss) - negative test 2");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Get an array of Call objects via TestsGenSvc.getCalls()");
            TestUtil.logMsg((String)"Expecting a (ServiceException)");
            try {
                Call[] calls = genService.getCalls(this.BAD_PORT_QNAME);
                TestUtil.logErr((String)"Did not throw expected ServiceException");
                pass = false;
            }
            catch (ServiceException e) {
                TestUtil.logMsg((String)"Caught expected ServiceException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetCallsNegTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetCallsNegTest2 failed");
        }
    }

    public void GetCallsNegTest3() throws EETest.Fault {
        TestUtil.logTrace((String)"GetCallsNegTest3");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test getCalls (null port name/WSDL access) - negative test 3");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Get an array of Call objects via TestsGenSvc.getCalls()");
            TestUtil.logMsg((String)"Expecting a (ServiceException)");
            try {
                Call[] calls = genService.getCalls(null);
                TestUtil.logErr((String)"Did not throw expected ServiceException");
                pass = false;
            }
            catch (ServiceException e) {
                TestUtil.logMsg((String)"Caught expected ServiceException");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetCallsNegTest3 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetCallsNegTest3 failed");
        }
    }

    public void GetGeneratedPort1Test1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetGeneratedPort1Test1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test get<port>");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Call TestsGenSvc.get<port>");
            TestUtil.logMsg((String)"Should find port");
            Tests tests = genService.getTestsPort();
            if (tests == null) {
                TestUtil.logErr((String)"get<port> returned null");
                pass = false;
            } else if (!(tests instanceof Tests)) {
                TestUtil.logErr((String)"get<port> did not return instance of Tests");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetGeneratedPort1Test1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetGeneratedPort1Test1 failed");
        }
    }

    public void GetGeneratedPort1Test2() throws EETest.Fault {
        TestUtil.logTrace((String)"GetGeneratedPort1Test2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test get<port>");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance without port component ref");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL_NO_PCREF);
            TestUtil.logMsg((String)"Call TestsGenSvc.get<port>");
            TestUtil.logMsg((String)"Should find port");
            Tests tests = genService.getTestsPort();
            if (tests == null) {
                TestUtil.logErr((String)"get<port> returned null");
                pass = false;
            } else if (!(tests instanceof Tests)) {
                TestUtil.logErr((String)"get<port> did not return instance of Tests");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetGeneratedPort1Test2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetGeneratedPort1Test2 failed");
        }
    }

    public void GetPortConstructor1PosTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor1PosTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test getPort (valid port name/WSDL access) - positive test 1");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Call TestsGenSvc.getPort(QName, Class)");
            TestUtil.logMsg((String)"Should find port");
            Tests tests = (Tests)genService.getPort(this.PORT_QNAME, Tests.class);
            if (tests == null) {
                TestUtil.logErr((String)"getPort(QName, Class) returned null");
                pass = false;
            } else if (!(tests instanceof Tests)) {
                TestUtil.logErr((String)"getPort(QName, Class) did not return instance of Tests");
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor1PosTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor1PosTest1 failed");
        }
    }

    public void GetPortConstructor1NegTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor1NegTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test getPort (invalid port name/WSDL access) - negative test 2");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Call TestsGenSvc.getPort(QName, Class)");
            TestUtil.logMsg((String)"Should not find port (expect ServiceException)");
            Tests tests = (Tests)genService.getPort(this.BAD_PORT_QNAME, Tests.class);
            TestUtil.logErr((String)"Did not throw expected ServiceException");
            pass = false;
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught expected ServiceException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor1NegTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor1NegTest2 failed");
        }
    }

    public void GetPortConstructor2PosTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor2PosTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test getPort (valid SDI class/WSDL access) - positive test 1");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Call Service.getPort(Class)");
            TestUtil.logMsg((String)"Should find port");
            Tests tests = (Tests)genService.getPort(Tests.class);
            if (tests == null) {
                TestUtil.logErr((String)"getPort(Class) returned null");
                pass = false;
            } else if (!(tests instanceof Tests)) {
                TestUtil.logErr((String)"getPort(Class) did not return instance of Tests");
                pass = false;
            }
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught ServiceException");
            pass = false;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor2PosTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor2PosTest1 failed");
        }
    }

    public void GetPortConstructor2PosTest2() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor2PosTest2");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test getPort (valid SDI class/WSDL access) - positive test 1");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance without port-component-ref");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL_NO_PCREF);
            TestUtil.logMsg((String)"Call Service.getPort(Class)");
            TestUtil.logMsg((String)"Should find port");
            Tests tests = (Tests)genService.getPort(Tests.class);
            if (tests == null) {
                TestUtil.logErr((String)"getPort(Class) returned null");
                pass = false;
            } else if (!(tests instanceof Tests)) {
                TestUtil.logErr((String)"getPort(Class) did not return instance of Tests");
                pass = false;
            }
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught expected ServiceException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
            throw new EETest.Fault("GetPortConstructor2PosTest2 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor2PosTest2 failed");
        }
    }

    public void GetPortConstructor2NegTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortConstructor2NegTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test getPort (invalid SDI class/WSDL access) - negative test 1");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Call Service.getPort(Class)");
            TestUtil.logMsg((String)"Should not find port (expect ServiceException)");
            Tests tests = (Tests)genService.getPort(Pattern.class);
            TestUtil.logErr((String)"Did not throw expected ServiceException");
            pass = false;
        }
        catch (ServiceException e) {
            TestUtil.logMsg((String)"Caught expected ServiceException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortConstructor2NegTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortConstructor2NegTest1 failed");
        }
    }

    public void GetPortsPosTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetPortsPosTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Test getPorts with (WSDL access) - positive test 1");
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Call Service.getPorts()");
            TestUtil.logMsg((String)"Expect a non empty iterator of ports");
            Iterator i = genService.getPorts();
            if (!i.hasNext()) {
                TestUtil.logErr((String)"getPorts() returned empty iterator (unexpected)");
                pass = false;
            } else {
                int count = 0;
                while (i.hasNext()) {
                    i.next();
                    ++count;
                }
                if (count != 1) {
                    TestUtil.logErr((String)("getPorts() returned wrong iterator count, got " + count + ", expected 1"));
                    pass = false;
                }
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetPortsPosTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetPortsPosTest1 failed");
        }
    }

    public void GetServiceNameTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetServiceNameTest1");
        boolean pass = true;
        try {
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Create Call object via Service.createCall()");
            Call call = genService.createCall();
            TestUtil.logMsg((String)"Get service name via Service.getServiceName()");
            QName sname = genService.getServiceName();
            if (!sname.equals(this.SERVICE_QNAME)) {
                TestUtil.logErr((String)"getServiceName() returned wrong QName");
                TestUtil.logErr((String)("Expected " + this.SERVICE_QNAME + "\nGot " + sname));
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
            throw new EETest.Fault("GetServiceNameTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetServiceNameTest1 failed");
        }
    }

    public void GetTypeMappingRegistryTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetTypeMappingRegistryTest1");
        boolean pass = false;
        TypeMappingRegistry tmrRegistry = null;
        TestsGenSvc genService = null;
        try {
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Call Service.getTypeMappingRegistry()");
            tmrRegistry = genService.getTypeMappingRegistry();
            if (tmrRegistry == null) {
                TestUtil.logMsg((String)"No TypeMappingRegistry defined on Service object (returned null)");
            } else {
                TestUtil.logMsg((String)("TypeMappingRegistry defined on Service object (returned = " + tmrRegistry + ")"));
            }
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            pass = true;
        }
        catch (JAXRPCException e) {
            TestUtil.logErr((String)"Caught unexpected JAXRPCException");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetTypeMappingRegistryTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetTypeMappingRegistryTest1 failed");
        }
    }

    public void GetHandlerRegistryTest1() throws EETest.Fault {
        TestUtil.logTrace((String)"GetHandlerRegistryTest1");
        boolean pass = false;
        try {
            TestUtil.logMsg((String)"Get Initial Context");
            InitialContext ctx = new InitialContext();
            TestUtil.logMsg((String)"Get JAXRPC service instance with WSDL");
            TestsGenSvc genService = (TestsGenSvc)ctx.lookup("java:comp/env/service/" + this.SERVICE_NAME_WITH_WSDL);
            TestUtil.logMsg((String)"Call Service.getHandlerRegistry()");
            HandlerRegistry hr = genService.getHandlerRegistry();
            if (hr == null) {
                TestUtil.logMsg((String)"No HandlerRegistry defined on Service object (returned null)");
            } else {
                TestUtil.logMsg((String)("HandlerRegistry defined on Service object (returned = " + hr + ")"));
            }
        }
        catch (UnsupportedOperationException e) {
            TestUtil.logMsg((String)"Caught UnsupportedOperationException");
            pass = true;
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("GetHandlerRegistryTest1 failed", e);
        }
        if (!pass) {
            throw new EETest.Fault("GetHandlerRegistryTest1 failed");
        }
    }
}

