/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.cdi.customizedmapping.adapters.model.adapter;

import com.sun.ts.tests.jsonb.customizedmapping.adapters.model.Animal;
import com.sun.ts.tests.jsonb.customizedmapping.adapters.model.Cat;
import com.sun.ts.tests.jsonb.customizedmapping.adapters.model.Dog;
import com.sun.ts.tests.jsonb.customizedmapping.adapters.model.adapter.AnimalIdentifier;
import com.sun.ts.tests.jsonb.customizedmapping.adapters.model.adapter.AnimalJson;
import javax.inject.Inject;
import javax.json.bind.adapter.JsonbAdapter;

public class InjectedAdapter
implements JsonbAdapter<Animal, AnimalJson> {
    @Inject
    private AnimalIdentifier animalIdentifier;

    public AnimalJson adaptToJson(Animal animal) throws Exception {
        AnimalJson adapted = new AnimalJson();
        switch (this.animalIdentifier.getType(animal)) {
            case CAT: {
                adapted.setType(AnimalJson.TYPE.CAT);
                adapted.setCuddly(((Cat)animal).isCuddly());
                break;
            }
            case DOG: {
                adapted.setType(AnimalJson.TYPE.DOG);
                adapted.setBarking(((Dog)animal).isBarking());
                break;
            }
            default: {
                adapted.setType(AnimalJson.TYPE.GENERIC);
            }
        }
        adapted.setName(animal.getName());
        adapted.setAge(animal.getAge());
        adapted.setFurry(animal.isFurry());
        adapted.setWeight(animal.getWeight());
        return adapted;
    }

    public Animal adaptFromJson(AnimalJson adapted) throws Exception {
        Animal animal;
        switch (adapted.getType()) {
            case CAT: {
                animal = new Cat();
                ((Cat)animal).setCuddly(adapted.isCuddly());
                break;
            }
            case DOG: {
                animal = new Dog();
                ((Dog)animal).setBarking(adapted.isBarking());
                break;
            }
            default: {
                animal = new Animal();
            }
        }
        animal.setName(adapted.getName());
        animal.setAge(adapted.getAge());
        animal.setFurry(adapted.isFurry());
        animal.setWeight(adapted.getWeight());
        return animal;
    }
}

