/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.common.parser;

import com.sun.ts.tests.interop.csiv2.common.parser.Entry;
import com.sun.ts.tests.interop.csiv2.common.parser.ParseException;
import com.sun.ts.tests.interop.csiv2.common.parser.ReplyServiceContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.RequestServiceContextEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.ServerEntry;
import com.sun.ts.tests.interop.csiv2.common.parser.TransportClientPrincipalsEntry;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ServerInterceptorEntry
extends Entry {
    private String operation;
    private boolean sslUsed;
    private TransportClientPrincipalsEntry transportClientPrincipals;
    private ServerEntry server;
    private RequestServiceContextEntry requestServiceContext;
    private ReplyServiceContextEntry replyServiceContext;

    public ServerInterceptorEntry(Element element) throws ParseException {
        if (!element.getTagName().equals("server-interceptor")) {
            throw new ParseException("Unexpected tag: " + element.getTagName());
        }
        NodeList nodes = element.getChildNodes();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (node.getNodeName().equals("operation")) {
                this.operation = this.getText(node);
                continue;
            }
            if (node.getNodeName().equals("req-svc-context")) {
                this.requestServiceContext = new RequestServiceContextEntry((Element)node);
                continue;
            }
            if (node.getNodeName().equals("ssl-used")) {
                this.sslUsed = this.getText(node).equals("true");
                continue;
            }
            if (node.getNodeName().equals("server")) {
                this.server = new ServerEntry((Element)node);
                continue;
            }
            if (node.getNodeName().equals("reply-svc-context")) {
                this.replyServiceContext = new ReplyServiceContextEntry((Element)node);
                continue;
            }
            if (!node.getNodeName().equals("transport-client-principals")) continue;
            this.transportClientPrincipals = new TransportClientPrincipalsEntry((Element)node);
        }
    }

    public String getOperation() {
        return this.operation;
    }

    public RequestServiceContextEntry getRequestServiceContext() {
        return this.requestServiceContext;
    }

    public boolean isSslUsed() {
        return this.sslUsed;
    }

    public ReplyServiceContextEntry getReplyServiceContext() {
        return this.replyServiceContext;
    }

    public TransportClientPrincipalsEntry getTransportClientPrincipals() {
        return this.transportClientPrincipals;
    }

    public ServerEntry getServer() {
        return this.server;
    }

    public String toString() {
        String result = "<server-interceptor>\n";
        result = result + "<operation>" + this.operation + "</operation>\n";
        result = result + this.requestServiceContext.toString();
        result = result + "<ssl-used>" + this.sslUsed + "</ssl-used>\n";
        if (this.transportClientPrincipals != null) {
            result = result + this.transportClientPrincipals.toString();
        }
        if (this.server != null) {
            result = result + this.server.toString();
        }
        if (this.server != null) {
            result = result + this.replyServiceContext.toString();
        }
        result = result + "</server-interceptor>\n";
        return result;
    }
}

