/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.signaturetest;

import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.signaturetest.SigTestData;
import com.sun.ts.tests.signaturetest.SigTestResult;
import com.sun.ts.tests.signaturetest.SignatureTestDriver;
import com.sun.ts.tests.signaturetest.SignatureTestDriverFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Properties;

public abstract class SigTestEE
extends ServiceEETest {
    protected SignatureTestDriver driver;
    protected SigTestData testInfo;

    protected SignatureTestDriver getSigTestDriver() {
        if (this.driver == null) {
            this.driver = SignatureTestDriverFactory.getInstance("sigtest");
        }
        return this.driver;
    }

    protected String getPackageFile() {
        return this.getSigTestDriver().getPackageFileImpl(this.testInfo.getBinDir());
    }

    protected String getMapFile() {
        return this.getSigTestDriver().getMapFileImpl(this.testInfo.getBinDir());
    }

    protected String getRepositoryDir() {
        return this.getSigTestDriver().getRepositoryDirImpl(this.testInfo.getTSHome());
    }

    protected ArrayList<String> getUnlistedOptionalPackages() {
        return null;
    }

    protected abstract String[] getPackages(String var1);

    protected String[] getClasses(String vehicleName) {
        return new String[0];
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        try {
            TestUtil.logMsg((String)"$$$ SigTestEE.setup() called");
            this.testInfo = new SigTestData(p);
            TestUtil.logMsg((String)"$$$ SigTestEE.setup() complete");
        }
        catch (Exception e) {
            this.logErr("Unexpected exception " + e.getMessage());
            throw new EETest.Fault("setup failed!", e);
        }
    }

    public void signatureTest() throws EETest.Fault {
        TestUtil.logMsg((String)"$$$ SigTestEE.signatureTest() called");
        SigTestResult results = null;
        String mapFile = this.getMapFile();
        String repositoryDir = this.getRepositoryDir();
        String[] packages = this.getPackages(this.testInfo.getVehicle());
        String[] classes = this.getClasses(this.testInfo.getVehicle());
        String packageFile = this.getPackageFile();
        String testClasspath = this.testInfo.getTestClasspath();
        String optionalPkgToIgnore = this.testInfo.getOptionalTechPackagesToIgnore();
        ArrayList<String> unlistedTechnologyPkgs = this.getUnlistedOptionalPackages();
        Properties sysProps = System.getProperties();
        String version = (String)sysProps.get("java.version");
        if (!version.startsWith("1.")) {
            String jimageDir = this.testInfo.getJImageDir();
            File f = new File(jimageDir);
            f.mkdirs();
            String javaHome = (String)sysProps.get("java.home");
            TestUtil.logMsg((String)"Executing JImage");
            try {
                ProcessBuilder pb = new ProcessBuilder(javaHome + "/bin/jimage", "extract", "--dir=" + jimageDir, javaHome + "/lib/modules");
                TestUtil.logMsg((String)(javaHome + "/bin/jimage extract --dir=" + jimageDir + " " + javaHome + "/lib/modules"));
                pb.redirectErrorStream(true);
                Process proc = pb.start();
                BufferedReader out = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                String line = null;
                while ((line = out.readLine()) != null) {
                    TestUtil.logMsg((String)line);
                }
                int rc = proc.waitFor();
                TestUtil.logMsg((String)("JImage RC = " + rc));
                out.close();
            }
            catch (Exception e) {
                TestUtil.logMsg((String)"Exception while executing JImage!  Some tests may fail.");
                e.printStackTrace();
            }
        }
        try {
            results = this.getSigTestDriver().executeSigTest(packageFile, mapFile, repositoryDir, packages, classes, testClasspath, unlistedTechnologyPkgs, optionalPkgToIgnore);
            TestUtil.logMsg((String)results.toString());
            if (!results.passed()) {
                TestUtil.logErr((String)"results.passed() returned false");
                throw new Exception();
            }
            if ("standalone".equalsIgnoreCase(this.testInfo.getVehicle())) {
                Properties mapFileAsProps = this.getSigTestDriver().loadMapFile(mapFile);
                if (mapFileAsProps == null || mapFileAsProps.size() == 0) {
                    TestUtil.logMsg((String)"SigTestEE.signatureTest() returning, as signature map file is empty.");
                    return;
                }
                boolean isJTASigTest = false;
                String jtaVersion = mapFileAsProps.getProperty("javax.transaction");
                if (jtaVersion == null || "".equals(jtaVersion.trim())) {
                    TestUtil.logMsg((String)"SigTestEE.signatureTest() returning, as this is neither JTA TCK run, not Java EE CTS run.");
                    return;
                }
                TestUtil.logMsg((String)("jtaVersion " + jtaVersion));
                if (mapFileAsProps.size() == 1) {
                    isJTASigTest = true;
                }
                if (isJTASigTest || !jtaVersion.startsWith("1.2")) {
                    this.verifyJtaJarTest();
                }
            }
            TestUtil.logMsg((String)"$$$ SigTestEE.signatureTest() returning");
        }
        catch (Exception e) {
            if (results != null && !results.passed()) {
                throw new EETest.Fault("SigTestEE.signatureTest() failed!, diffs found");
            }
            TestUtil.logErr((String)("Unexpected exception " + e.getMessage()));
            throw new EETest.Fault("signatureTest failed with an unexpected exception", e);
        }
    }

    public void verifyJtaJarTest() throws Exception {
        TestUtil.logMsg((String)"SigTestEE#verifyJtaJarTest - Starting:");
        String repositoryDir = this.getRepositoryDir();
        String jtaJarClasspath = this.testInfo.getJtaJarClasspath();
        boolean result = this.getSigTestDriver().verifyJTAJarForNoXA(this.testInfo.getJtaJarClasspath(), repositoryDir);
        if (!result) {
            TestUtil.logErr((String)"FAIL: javax.transaction.xa found in API jar");
            throw new EETest.Fault("javax.transaction.xa validation failed");
        }
        TestUtil.logMsg((String)"PASS: javax.transaction.xa not found in API jar");
        TestUtil.logMsg((String)"SigTestEE#verifyJtaJarTest returning");
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"$$$ SigTestEE.cleanup() called");
        try {
            this.getSigTestDriver().cleanupImpl();
            TestUtil.logMsg((String)"$$$ SigTestEE.cleanup() returning");
        }
        catch (Exception e) {
            throw new EETest.Fault("Cleanup failed!", e);
        }
    }
}

