/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.dao.coffee.variants;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.common.dao.DAOException;
import com.sun.ts.tests.common.dao.DataSourceDAO;
import com.sun.ts.tests.common.dao.coffee.variants.FloatPKCoffeeDAO;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.ejb.CreateException;

public class FloatPKDSCoffeeDAO
extends DataSourceDAO
implements FloatPKCoffeeDAO {
    public static final String DEFAULT_TABLE_PREFIX = "COFFEE_FLOAT_PK";
    protected static final String SQL_EXISTS = "select";
    protected static final String SQL_CREATE = "insert";
    protected static final String SQL_LOAD_PRICE = "select_price";
    protected static final String SQL_STORE_PRICE = "update_price";
    protected static final String SQL_DELETE = "delete";
    protected static final String SQL_DELETE_ALL = "delete_all";

    public FloatPKDSCoffeeDAO(String sqlTablePrefix) throws DAOException {
        super(sqlTablePrefix);
    }

    public FloatPKDSCoffeeDAO(String sqlTablePrefix, String user, String password) throws DAOException {
        super(sqlTablePrefix, user, password);
    }

    @Override
    public boolean exists(float pkey) throws DAOException {
        boolean bl;
        PreparedStatement pStmt = null;
        ResultSet result = null;
        try {
            TestUtil.logTrace((String)("[FloatPKDSCoffeeDAO] exists(" + pkey + ")"));
            pStmt = this.getStmt(SQL_EXISTS);
            pStmt.setFloat(1, pkey);
            result = pStmt.executeQuery();
            bl = result.next();
        }
        catch (SQLException e) {
            try {
                throw new DAOException("SQLException in keyExists: ", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, result);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, result);
        return bl;
    }

    @Override
    public void create(float id, String name, float price) throws CreateException, DAOException {
        PreparedStatement pStmt = null;
        try {
            TestUtil.logTrace((String)("[FloatPKDSCoffeeDAO] create {" + id + ", " + name + ", " + price + "}"));
            pStmt = this.getStmt(SQL_CREATE);
            pStmt.setFloat(1, id);
            pStmt.setString(2, name);
            pStmt.setFloat(3, price);
            TestUtil.logTrace((String)("[FloatPKDSCoffeeDAO] Execute stmt" + pStmt));
            if (1 != pStmt.executeUpdate()) {
                throw new CreateException("DB INSERT failed");
            }
        }
        catch (SQLException e) {
            try {
                TestUtil.printStackTrace((Throwable)e);
                throw new DAOException("SQLException in createNewRow", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, null);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, null);
        TestUtil.logTrace((String)"[FloatPKDSCoffeeDAO] New row created !");
    }

    @Override
    public float loadPrice(float id) throws DAOException {
        float f;
        PreparedStatement pStmt = null;
        ResultSet result = null;
        try {
            TestUtil.logTrace((String)("[FloatPKDSCoffeeDAO] loadPrice(" + id + ")"));
            pStmt = this.getStmt(SQL_LOAD_PRICE);
            pStmt.setFloat(1, id);
            result = pStmt.executeQuery();
            if (!result.next()) {
                throw new SQLException("No record for PK = " + id);
            }
            f = result.getFloat(1);
        }
        catch (SQLException e) {
            try {
                throw new DAOException("SQLException in loadPrice(): ", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, result);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, result);
        return f;
    }

    @Override
    public void storePrice(float id, float price) throws DAOException {
        PreparedStatement pStmt = null;
        try {
            TestUtil.logTrace((String)("[FloatPKDSCoffeeDAO] storePrice {id=" + id + ", price=" + price + "}"));
            pStmt = this.getStmt(SQL_STORE_PRICE);
            pStmt.setFloat(1, price);
            pStmt.setFloat(2, id);
            if (1 != pStmt.executeUpdate()) {
                throw new SQLException("UPDATE failed in storePrice");
            }
        }
        catch (SQLException e) {
            try {
                throw new DAOException("SQLException in storePrice(): ", e);
            }
            catch (Throwable throwable) {
                this.closeStmt(pStmt, null);
                throw throwable;
            }
        }
        this.closeStmt(pStmt, null);
    }

    @Override
    public void delete(float id) throws DAOException {
        PreparedStatement pStmt = null;
        try {
            TestUtil.logTrace((String)"[FloatPKDSCoffeeDAO] delete()");
            pStmt = this.getStmt(SQL_DELETE);
            pStmt.setFloat(1, id);
            if (1 != pStmt.executeUpdate()) {
                throw new SQLException("DELETE failed in remove()");
            }
        }
        catch (SQLException e) {
            throw new DAOException("SQLException in remove(): ", e);
        }
        finally {
            this.closeStmt(pStmt, null);
        }
    }
}

