/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jpa.core.derivedid.ex3b;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jpa.common.PMClientBase;
import com.sun.ts.tests.jpa.core.derivedid.ex3b.DID3bDependent;
import com.sun.ts.tests.jpa.core.derivedid.ex3b.DID3bDependentId;
import com.sun.ts.tests.jpa.core.derivedid.ex3b.DID3bEmployee;
import com.sun.ts.tests.jpa.core.derivedid.ex3b.DID3bEmployeeId;
import java.util.List;
import java.util.Properties;

public class Client
extends PMClientBase {
    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    @Override
    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logTrace((String)"setup");
        try {
            super.setup(args, p);
            this.removeTestData();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception: ", (Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void DIDTest() throws EETest.Fault {
        boolean pass = false;
        boolean pass1 = false;
        boolean pass2 = false;
        try {
            DID3bDependent newDependent2;
            this.getEntityTransaction().begin();
            DID3bEmployeeId eId1 = new DID3bEmployeeId("Java", "Duke");
            DID3bEmployeeId eId2 = new DID3bEmployeeId("C", "foo");
            DID3bEmployee employee1 = new DID3bEmployee(eId1);
            DID3bEmployee employee2 = new DID3bEmployee(eId2);
            DID3bDependentId depId1 = new DID3bDependentId("Obama", eId1);
            DID3bDependentId depId2 = new DID3bDependentId("Michelle", eId1);
            DID3bDependentId depId3 = new DID3bDependentId("John", eId2);
            DID3bDependent dep1 = new DID3bDependent(depId1, employee1);
            DID3bDependent dep2 = new DID3bDependent(depId2, employee1);
            DID3bDependent dep3 = new DID3bDependent(depId3, employee2);
            this.getEntityManager().persist((Object)dep1);
            this.getEntityManager().persist((Object)dep2);
            this.getEntityManager().persist((Object)dep3);
            this.getEntityManager().persist((Object)employee1);
            this.getEntityManager().persist((Object)employee2);
            TestUtil.logTrace((String)"persisted Employees and Dependents");
            this.getEntityManager().flush();
            DID3bDependent newDependent = (DID3bDependent)this.getEntityManager().find(DID3bDependent.class, (Object)depId1);
            if (newDependent != null) {
                this.getEntityManager().refresh((Object)newDependent);
            }
            if ((newDependent2 = (DID3bDependent)this.getEntityManager().find(DID3bDependent.class, (Object)depId2)) != null) {
                this.getEntityManager().refresh((Object)newDependent2);
            }
            List depList = this.getEntityManager().createQuery("Select d from DID3bDependent d where d.id.name='Obama' and d.emp.empId.firstName='Java'").getResultList();
            newDependent = null;
            if (depList.size() > 0) {
                newDependent = (DID3bDependent)depList.get(0);
                if (newDependent == dep1) {
                    pass1 = true;
                    TestUtil.logTrace((String)"Received Expected Dependent");
                } else {
                    TestUtil.logErr((String)"Searched Dependent not found");
                }
            } else {
                TestUtil.logErr((String)"getEntityManager().createQuery returned null entry");
            }
            List depList2 = this.getEntityManager().createQuery("Select d from DID3bDependent d where d.id.name='Obama' and d.id.empPK.firstName='Java'").getResultList();
            newDependent2 = null;
            if (depList2.size() > 0) {
                newDependent2 = (DID3bDependent)depList.get(0);
                if (newDependent2 == dep1) {
                    pass2 = true;
                    TestUtil.logTrace((String)"Received Expected Dependent");
                } else {
                    TestUtil.logErr((String)"Searched Dependent not found");
                }
            } else {
                TestUtil.logErr((String)"getEntityManager().createQuery returned null entry");
            }
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Unexpected exception occurred", (Throwable)e);
            this.getEntityTransaction().rollback();
        }
        if (pass1 && pass2) {
            pass = true;
        }
        if (!pass) {
            throw new EETest.Fault("DIDTest failed");
        }
    }

    @Override
    public void cleanup() throws EETest.Fault {
        TestUtil.logTrace((String)"cleanup");
        this.removeTestData();
        TestUtil.logTrace((String)"cleanup complete, calling super.cleanup");
        super.cleanup();
    }

    private void removeTestData() {
        TestUtil.logTrace((String)"removeTestData");
        if (this.getEntityTransaction().isActive()) {
            this.getEntityTransaction().rollback();
        }
        try {
            this.getEntityTransaction().begin();
            this.getEntityManager().createNativeQuery("DELETE FROM DID3BDEPENDENT").executeUpdate();
            this.getEntityManager().createNativeQuery("DELETE FROM DID3BEMPLOYEE").executeUpdate();
            this.getEntityTransaction().commit();
        }
        catch (Exception e) {
            TestUtil.logErr((String)"Exception encountered while removing entities:", (Throwable)e);
        }
        finally {
            try {
                if (this.getEntityTransaction().isActive()) {
                    this.getEntityTransaction().rollback();
                }
            }
            catch (Exception re) {
                TestUtil.logErr((String)"Unexpected Exception in removeTestData:", (Throwable)re);
            }
        }
    }
}

