/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb32.lite.timer.schedule.expression.annotated;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.timer.common.ScheduleAttributeType;
import com.sun.ts.tests.ejb30.timer.common.ScheduleValues;
import com.sun.ts.tests.ejb30.timer.common.TimerBeanBaseWithoutTimeOutMethod;
import com.sun.ts.tests.ejb30.timer.common.TimerInfo;
import com.sun.ts.tests.ejb30.timer.common.TimerUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import javax.ejb.ScheduleExpression;
import javax.ejb.Stateless;
import javax.ejb.Timeout;
import javax.ejb.Timer;
import javax.ejb.TimerConfig;
import javax.ejb.TransactionAttribute;
import javax.ejb.TransactionAttributeType;

@Stateless
public class ScheduleBean
extends TimerBeanBaseWithoutTimeOutMethod {
    @Override
    @Timeout
    @TransactionAttribute(value=TransactionAttributeType.REQUIRES_NEW)
    protected void timeout(Timer timer) {
        super.timeout(timer);
        TimerInfo info = (TimerInfo)timer.getInfo();
        String testName = info.getTestName();
        if ("dayOfMonthAndDayOfWeek".equals(testName)) {
            long expectedNext = 86400000L;
            long actualNext = timer.getTimeRemaining();
            String s = "Expecting approximate timeRemaining " + expectedNext + ", actual timeRemaining " + actualNext;
            this.statusSingleton.addRecord(testName, s);
            if (Math.abs(actualNext - expectedNext) < 60000L) {
                this.statusSingleton.setStatus(testName, true);
            } else {
                this.statusSingleton.setStatus(testName, false);
            }
        }
    }

    public String validSecondValuesInt() {
        return this.validValuesInt(ScheduleValues.validSecondValuesInt(), ScheduleAttributeType.SECOND);
    }

    public String validMinuteValuesInt() {
        return this.validValuesInt(ScheduleValues.validMinuteValuesInt(), ScheduleAttributeType.MINUTE);
    }

    public String validHourValuesInt() {
        return this.validValuesInt(ScheduleValues.validHourValuesInt(), ScheduleAttributeType.HOUR);
    }

    public String validMonthValuesInt() {
        return this.validValuesInt(ScheduleValues.validMonthValuesInt(), ScheduleAttributeType.MONTH);
    }

    public String validYearValuesInt() {
        return this.validValuesInt(ScheduleValues.validYearValuesInt(), ScheduleAttributeType.YEAR);
    }

    public String validDayOfMonthValuesInt() {
        return this.validValuesInt(ScheduleValues.validDayOfMonthValuesInt(), ScheduleAttributeType.DAY_OF_MONTH);
    }

    public String validDayOfWeekValuesInt() {
        return this.validValuesInt(ScheduleValues.validDayOfWeekValuesInt(), ScheduleAttributeType.DAY_OF_WEEK);
    }

    public String invalidSecondValuesInt() {
        return this.invalidValuesInt(ScheduleValues.invalidSecondValuesInt(), ScheduleAttributeType.SECOND);
    }

    public String invalidMinuteValuesInt() {
        return this.invalidValuesInt(ScheduleValues.invalidMinuteValuesInt(), ScheduleAttributeType.MINUTE);
    }

    public String invalidHourValuesInt() {
        return this.invalidValuesInt(ScheduleValues.invalidHourValuesInt(), ScheduleAttributeType.HOUR);
    }

    public String invalidMonthValuesInt() {
        return this.invalidValuesInt(ScheduleValues.invalidMonthValuesInt(), ScheduleAttributeType.MONTH);
    }

    public String invalidYearValuesInt() {
        return this.invalidValuesInt(ScheduleValues.invalidYearValuesInt(), ScheduleAttributeType.YEAR);
    }

    public String invalidDayOfMonthValuesInt() {
        return this.invalidValuesInt(ScheduleValues.invalidDayOfMonthValuesInt(), ScheduleAttributeType.DAY_OF_MONTH);
    }

    public String invalidDayOfWeekValuesInt() {
        return this.invalidValuesInt(ScheduleValues.invalidDayOfWeekValuesInt(), ScheduleAttributeType.DAY_OF_WEEK);
    }

    public String validSecondValuesString() {
        return this.validValuesString(ScheduleValues.validSecondValuesString(), ScheduleAttributeType.SECOND);
    }

    public String validMinuteValuesString() {
        return this.validValuesString(ScheduleValues.validMinuteValuesString(), ScheduleAttributeType.MINUTE);
    }

    public String validHourValuesString() {
        return this.validValuesString(ScheduleValues.validHourValuesString(), ScheduleAttributeType.HOUR);
    }

    public String validMonthValuesString() {
        return this.validValuesString(ScheduleValues.validMonthValuesString(), ScheduleAttributeType.MONTH);
    }

    public String validYearValuesString() {
        return this.validValuesString(ScheduleValues.validYearValuesString(), ScheduleAttributeType.YEAR);
    }

    public String validDayOfMonthValuesString() {
        return this.validValuesString(ScheduleValues.validDayOfMonthValuesString(), ScheduleAttributeType.DAY_OF_MONTH);
    }

    public String validDayOfWeekValuesString() {
        return this.validValuesString(ScheduleValues.validDayOfWeekValuesString(), ScheduleAttributeType.DAY_OF_WEEK);
    }

    public String invalidSecondValuesString() {
        return this.invalidValuesString(ScheduleValues.invalidSecondValuesString(), ScheduleAttributeType.SECOND);
    }

    public String invalidMinuteValuesString() {
        return this.invalidValuesString(ScheduleValues.invalidMinuteValuesString(), ScheduleAttributeType.MINUTE);
    }

    public String invalidHourValuesString() {
        return this.invalidValuesString(ScheduleValues.invalidHourValuesString(), ScheduleAttributeType.HOUR);
    }

    public String invalidMonthValuesString() {
        return this.invalidValuesString(ScheduleValues.invalidMonthValuesString(), ScheduleAttributeType.MONTH);
    }

    public String invalidYearValuesString() {
        return this.invalidValuesString(ScheduleValues.invalidYearValuesString(), ScheduleAttributeType.YEAR);
    }

    public String invalidDayOfMonthValuesString() {
        return this.invalidValuesString(ScheduleValues.invalidDayOfMonthValuesString(), ScheduleAttributeType.DAY_OF_MONTH);
    }

    public String invalidDayOfWeekValuesString() {
        return this.invalidValuesString(ScheduleValues.invalidDayOfWeekValuesString(), ScheduleAttributeType.DAY_OF_WEEK);
    }

    public String leapYear() {
        ScheduleExpression exp = new ScheduleExpression();
        exp.month(ScheduleValues.VALID_FEB_29_4000[0]);
        exp.dayOfMonth(ScheduleValues.VALID_FEB_29_4000[1]);
        exp.year(ScheduleValues.VALID_FEB_29_4000[2]);
        Timer timer = this.timerService.createCalendarTimer(exp, new TimerConfig(null, false));
        timer.cancel();
        return "Scheduled and canceled a timer with " + Arrays.toString(ScheduleValues.VALID_FEB_29_4000);
    }

    public String attributeDefaults() {
        StringBuilder sb = new StringBuilder();
        Timer t = this.timerService.createCalendarTimer(new ScheduleExpression(), new TimerConfig(null, false));
        ScheduleExpression exp = t.getSchedule();
        TimerUtil.checkScheduleDefaults(exp, sb);
        return sb.toString();
    }

    public String dayOfWeekOverDayOfMonth() {
        TimerInfo info = new TimerInfo("dayOfWeekOverDayOfMonth");
        Calendar cal = Calendar.getInstance();
        cal.add(7, 1);
        int nextDayOfWeek = TimerUtil.getForSchedule(7, cal);
        ScheduleExpression exp = new ScheduleExpression().year("*").month("*").dayOfMonth("*").dayOfWeek(nextDayOfWeek).second("*").minute("*").hour("*");
        Timer timer = this.timerService.createCalendarTimer(exp, new TimerConfig((Serializable)info, false));
        return "Created timer: " + TimerUtil.toString(timer);
    }

    public String dayOfMonthOverDayOfWeek() {
        TimerInfo info = new TimerInfo("dayOfMonthOverDayOfWeek");
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        int nextDayOfMonth = TimerUtil.getForSchedule(5, cal);
        ScheduleExpression exp = new ScheduleExpression().year("*").month("*").dayOfWeek("*").dayOfMonth(nextDayOfMonth).second("*").minute("*").hour("*");
        Timer timer = this.timerService.createCalendarTimer(exp, new TimerConfig((Serializable)info, false));
        return "Created timer: " + TimerUtil.toString(timer);
    }

    public String dayOfMonthAndDayOfWeek() {
        TimerInfo info = new TimerInfo("dayOfMonthAndDayOfWeek");
        int currentDayOfWeek = TimerUtil.getForSchedule(7, new Calendar[0]);
        Calendar cal = Calendar.getInstance();
        cal.add(5, 1);
        int nextDayOfMonth = TimerUtil.getForSchedule(5, cal);
        Calendar cal2 = Calendar.getInstance();
        cal2.add(13, 1);
        ScheduleExpression exp = new ScheduleExpression().year("*").month("*").dayOfWeek(currentDayOfWeek).dayOfMonth(nextDayOfMonth).second(TimerUtil.getForSchedule(13, cal2)).minute(TimerUtil.getForSchedule(12, cal2)).hour(TimerUtil.getForSchedule(11, cal2));
        Timer timer = this.timerService.createCalendarTimer(exp, new TimerConfig((Serializable)info, false));
        return "Created timer: " + TimerUtil.toString(timer);
    }

    public void validStart(StringBuilder sb) {
        Date[] starts;
        ScheduleExpression exp = new ScheduleExpression();
        Date start = null;
        for (int i = 1; i < 10; ++i) {
            start = TimerUtil.getCurrentDatePlus(1, i);
            exp.start(start);
            Helper.assertEquals("Check getStart()", start, exp.getStart(), sb);
        }
        for (Date aStart : starts = new Date[]{start, null}) {
            Timer timer = this.timerService.createCalendarTimer(exp.start(aStart), new TimerConfig(null, false));
            Helper.assertEquals("Check getStart()", aStart, timer.getSchedule().getStart(), sb);
            timer.cancel();
        }
    }

    public void validEnd(StringBuilder sb) {
        Date[] dates;
        ScheduleExpression exp = new ScheduleExpression();
        Date end = null;
        for (int i = 1; i < 10; ++i) {
            end = TimerUtil.getCurrentDatePlus(1, i);
            exp.end(end);
            Helper.assertEquals("Check getEnd()", end, exp.getEnd(), sb);
        }
        for (Date d : dates = new Date[]{end, null}) {
            exp = exp.hour("*").minute("*").second("*").start(d).end(d);
            Timer timer = this.timerService.createCalendarTimer(exp, new TimerConfig(null, false));
            Helper.assertEquals("Check getStart()", d, timer.getSchedule().getStart(), sb);
            Helper.assertEquals("  Check getEnd()", d, timer.getSchedule().getEnd(), sb);
            timer.cancel();
        }
    }

    public void validStartEnd(StringBuilder sb) {
        ScheduleExpression exp = new ScheduleExpression();
        Date dateStarts = new Date();
        Date dateEnds = TimerUtil.getCurrentDatePlus(6, 1);
        exp.start(dateStarts).end(dateEnds);
        Timer timer = this.timerService.createCalendarTimer(exp, new TimerConfig(null, false));
        sb.append(" Created a timer with schedule ").append(TimerUtil.toString(exp)).append(TestUtil.NEW_LINE);
    }

    public void validTimeZone(StringBuilder sb) {
        ScheduleExpression exp = new ScheduleExpression();
        exp.timezone("GMT");
        Date dateStarts = new Date();
        Date dateEnds = TimerUtil.getCurrentDatePlus(6, 1);
        exp.start(dateStarts).end(dateEnds);
        Timer timer = this.timerService.createCalendarTimer(exp, new TimerConfig(null, false));
        sb.append(" Created a timer with timezone ").append(TimerUtil.toString(exp)).append(TestUtil.NEW_LINE);
    }

    private String validValuesInt(int[] values, ScheduleAttributeType attributeType) {
        try {
            for (int i : values) {
                this.dispatch(i, attributeType);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        String result = "Succeeded in creating ScheduleExpression and Timer with all valid int values for " + (Object)((Object)attributeType) + ": " + Arrays.toString(values);
        TimerUtil.cancelAllTimers(this.timerService, false);
        return result;
    }

    private String validValuesString(String[] values, ScheduleAttributeType attributeType) {
        try {
            for (String i : values) {
                this.dispatch(i, attributeType);
            }
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException(e);
        }
        String result = "Succeeded in creating ScheduleExpression and Timer with all valid String values for " + (Object)((Object)attributeType) + ": " + Arrays.toString(values);
        TimerUtil.cancelAllTimers(this.timerService, false);
        return result;
    }

    private String invalidValuesInt(int[] values, ScheduleAttributeType attributeType) {
        String result = null;
        for (int i : values) {
            try {
                this.dispatch(i, attributeType);
                result = "Expecting IllegalArgumentException, but got none, attributeType=" + (Object)((Object)attributeType) + ", value=" + i;
                throw new RuntimeException(result);
            }
            catch (IllegalArgumentException expected) {
                Helper.getLogger().fine("Got expected IllegalArgumentException when creating timer with " + (Object)((Object)attributeType) + ":" + i);
            }
        }
        if (result == null) {
            result = "Got expected IllegalArgumentException when creating ScheduleExpression and Timer with all invalid int values for " + (Object)((Object)attributeType) + ": " + Arrays.toString(values);
        }
        return result;
    }

    private String invalidValuesString(String[] values, ScheduleAttributeType attributeType) {
        String result = null;
        for (String i : values) {
            try {
                this.dispatch(i, attributeType);
                result = "Expecting IllegalArgumentException, but got none, attributeType=" + (Object)((Object)attributeType) + ", value=" + i;
                throw new RuntimeException(result);
            }
            catch (IllegalArgumentException expected) {
                Helper.getLogger().fine("Got expected IllegalArgumentException when creating timer with " + (Object)((Object)attributeType) + ":" + i);
            }
        }
        if (result == null) {
            result = "Got expected IllegalArgumentException when creating ScheduleExpression and Timer with all invalid int values for " + (Object)((Object)attributeType) + ": " + Arrays.toString(values);
        }
        return result;
    }

    private void dispatch(int i, ScheduleAttributeType attributeType) {
        ScheduleExpression exp = new ScheduleExpression();
        if (attributeType.equals((Object)ScheduleAttributeType.SECOND)) {
            exp = exp.second(i);
        } else if (attributeType.equals((Object)ScheduleAttributeType.MINUTE)) {
            exp = exp.minute(i);
        } else if (attributeType.equals((Object)ScheduleAttributeType.HOUR)) {
            exp = exp.hour(i);
        } else if (attributeType.equals((Object)ScheduleAttributeType.MONTH)) {
            exp = exp.month(i);
        } else if (attributeType.equals((Object)ScheduleAttributeType.DAY_OF_MONTH)) {
            exp = exp.dayOfMonth(i);
        } else if (attributeType.equals((Object)ScheduleAttributeType.DAY_OF_WEEK)) {
            exp = exp.dayOfWeek(i);
        } else if (attributeType.equals((Object)ScheduleAttributeType.YEAR)) {
            exp = exp.year(i);
        } else {
            throw new IllegalStateException("Invalid ScheduleAttributeType:" + (Object)((Object)attributeType));
        }
        Helper.getLogger().fine("About to create timer with " + (Object)((Object)attributeType) + ": " + i);
        this.timerService.createCalendarTimer(exp, new TimerConfig(null, false));
        Helper.getLogger().fine("Created timer with attributeType=" + (Object)((Object)attributeType) + " and value=" + i);
    }

    private void dispatch(String i, ScheduleAttributeType attributeType) {
        ScheduleExpression exp = new ScheduleExpression();
        if (attributeType.equals((Object)ScheduleAttributeType.SECOND)) {
            exp = exp.second(i);
        } else if (attributeType.equals((Object)ScheduleAttributeType.MINUTE)) {
            exp = exp.minute(i);
        } else if (attributeType.equals((Object)ScheduleAttributeType.HOUR)) {
            exp = exp.hour(i);
        } else if (attributeType.equals((Object)ScheduleAttributeType.MONTH)) {
            exp = exp.month(i);
        } else if (attributeType.equals((Object)ScheduleAttributeType.DAY_OF_MONTH)) {
            exp = exp.dayOfMonth(i);
        } else if (attributeType.equals((Object)ScheduleAttributeType.DAY_OF_WEEK)) {
            exp = exp.dayOfWeek(i);
        } else if (attributeType.equals((Object)ScheduleAttributeType.YEAR)) {
            exp = exp.year(i);
        } else {
            throw new IllegalStateException("Invalid ScheduleAttributeType:" + (Object)((Object)attributeType));
        }
        Helper.getLogger().fine("About to create timer with " + (Object)((Object)attributeType) + ": " + i);
        this.timerService.createCalendarTimer(exp, new TimerConfig(null, false));
        Helper.getLogger().fine("Created timer with attributeType=" + (Object)((Object)attributeType) + " and value=" + i);
    }
}

