/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonb.defaultmapping.polymorphictypes;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.harness.ServiceEETest;
import com.sun.ts.tests.jsonb.defaultmapping.polymorphictypes.model.StringContainer;
import com.sun.ts.tests.jsonb.defaultmapping.polymorphictypes.model.StringContainerSubClass;
import java.util.Properties;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

public class PolymorphicMappingTest
extends ServiceEETest {
    private static final long serialVersionUID = 10L;
    private final Jsonb jsonb = JsonbBuilder.create();

    public static void main(String[] args) {
        PolymorphicMappingTest t = new PolymorphicMappingTest();
        Status s = t.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.logMsg("setup ok");
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    public Status testPolymorphicTypes() throws EETest.Fault {
        String jsonString = this.jsonb.toJson((Object)new StringContainerSubClass());
        if (!jsonString.matches("\\{\\s*\"instance\"\\s*:\\s*\"Test String\"\\s*,\\s*\"newInstance\"\\s*:\\s*\"SubClass Test String\"\\s*\\}")) {
            throw new EETest.Fault("Failed to get attribute value from subclass.");
        }
        StringContainer unmarshalledObject = (StringContainer)this.jsonb.fromJson("{ \"instance\" : \"New Test String\", \"newInstance\" : \"New SubClass Test String\" }", StringContainer.class);
        if (StringContainerSubClass.class.isAssignableFrom(unmarshalledObject.getClass())) {
            throw new EETest.Fault("Polymorphic types support is not expected.");
        }
        return Status.passed((String)"OK");
    }
}

