/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.webservices.handler.uniqueness;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Tracker {
    private static Map handlerinfoMap = new HashMap();
    private static List configList = new ArrayList();
    private static Map instanceMap = new HashMap();

    public static synchronized void checkHandlerInfo(Object hi) {
        Object value = handlerinfoMap.get(hi);
        if (value != null) {
            System.out.println("DEBUG: checkHandlerInfo: SPEC Violation (HandlerInfo inst already in use) throwing RuntimeException");
            throw new RuntimeException("HandlerInfo inst already in use: " + hi);
        }
        handlerinfoMap.put(hi, "in-use");
    }

    public static synchronized void checkConfig(Object cfg) {
        for (Object o : configList) {
            if (cfg == null) {
                System.out.println("DEBUG: checkConfig: SPEC Violation (Config object is null) throwing RuntimeException");
                throw new RuntimeException("Config object is null");
            }
            if (o != cfg) continue;
            System.out.println("DEBUG: checkConfig: SPEC Violation (Config inst already in use) throwing RuntimeException");
            throw new RuntimeException("Config inst already in use: " + cfg);
        }
        configList.add(cfg);
    }

    public static synchronized void checkInstance(Object inst) {
        Object value = instanceMap.get(inst);
        if (value != null) {
            System.out.println("DEBUG: checkInstance: SPEC Violation (Handler inst already in use) throwing RuntimeException");
            throw new RuntimeException("Handler inst already in use: " + inst);
        }
        instanceMap.put(inst, "in-use");
    }

    public static synchronized void removeHandlerInfo(Object hi) {
        System.out.println("DEBUG: removeHandlerInfo:");
        Object value = handlerinfoMap.remove(hi);
    }

    public static synchronized void removeConfig(Object cfg) {
        System.out.println("DEBUG: removeConfig:");
        Iterator it = configList.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o != cfg) continue;
            it.remove();
        }
    }

    public static synchronized void removeInstance(Object inst) {
        System.out.println("DEBUG: removeInstance:");
        Object value = instanceMap.remove(inst);
    }
}

