/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.lite.tx.cm.stateful.rw;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.CoffeeEJBLite;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.CoffeeUtil;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.RWTestBeanBase;
import com.sun.ts.tests.ejb30.lite.tx.cm.common.RWTxBeanBase;
import com.sun.ts.tests.ejb30.lite.tx.cm.stateful.rw.TxBean;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.EJB;
import javax.ejb.Stateful;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;

@Stateful
@TransactionManagement(value=TransactionManagementType.BEAN)
public class TestBean
extends RWTestBeanBase {
    @EJB
    private TxBean statefulTxBean;

    @Override
    @EJB(beanInterface=TxBean.class)
    public void setTxBean(RWTxBeanBase b) {
        this.txBean = b;
    }

    @Override
    public String mandatory(boolean flush) {
        this.deleteTestCoffees();
        String result = super.mandatory(flush) + TestUtil.NEW_LINE;
        result = result + CoffeeUtil.verifyCoffee(1602, "afterBegin", this.em, false);
        result = result + TestUtil.NEW_LINE;
        result = result + CoffeeUtil.verifyCoffee(2503, "beforeCompletion", this.em, false);
        return result;
    }

    @Override
    public String required(boolean flush) {
        this.deleteTestCoffees();
        String result = super.required(flush) + TestUtil.NEW_LINE;
        result = result + CoffeeUtil.verifyCoffee(1602, "afterBegin", this.em, false);
        result = result + TestUtil.NEW_LINE;
        result = result + CoffeeUtil.verifyCoffee(2503, "beforeCompletion", this.em, false);
        return result;
    }

    @Override
    public String requiredNoExistingTransaction(boolean flush) {
        this.deleteTestCoffees();
        String result = super.requiredNoExistingTransaction(flush) + TestUtil.NEW_LINE;
        result = result + CoffeeUtil.verifyCoffee(1602, "afterBegin", this.em, true);
        result = result + TestUtil.NEW_LINE;
        result = result + CoffeeUtil.verifyCoffee(2503, "beforeCompletion", this.em, true);
        return result;
    }

    @Override
    public String requiresNew(boolean flush) {
        this.deleteTestCoffees();
        String result = super.requiresNew(flush) + TestUtil.NEW_LINE;
        result = result + CoffeeUtil.verifyCoffee(1602, "afterBegin", this.em, true);
        result = result + TestUtil.NEW_LINE;
        result = result + CoffeeUtil.verifyCoffee(2503, "beforeCompletion", this.em, true);
        return result;
    }

    public String invokeAsBusinessMethod() {
        this.deleteTestCoffees();
        this.statefulTxBean.afterBegin();
        String result = CoffeeUtil.verifyCoffee(1602, "afterBegin", this.em, true);
        result = result + TestUtil.NEW_LINE;
        this.statefulTxBean.afterCompletion(true);
        this.statefulTxBean.afterCompletion(false);
        return result;
    }

    private void deleteTestCoffees() {
        CoffeeUtil.deleteCoffeeInNewUserTransaction(1602, this.em, this.ut);
        CoffeeUtil.deleteCoffeeInNewUserTransaction(2503, this.em, this.ut);
    }

    @PostConstruct
    private void postConstruct() {
        int[] ids = new int[]{90206, 75600};
        String[] brandNames = new String[]{"postConstructCoffee1", "postConstructCoffee2"};
        try {
            this.ut.begin();
            for (int i = 0; i < ids.length; ++i) {
                this.postConstructCoffees[i] = CoffeeUtil.findDeletePersist(ids[i], brandNames[i], this.em);
            }
            this.ut.commit();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @PreDestroy
    private void preDestroy() {
        if (System.getProperty("ejbembed", null) == null) {
            this.em.getEntityManagerFactory().getCache().evictAll();
            for (CoffeeEJBLite postConstructCoffee : this.postConstructCoffees) {
                CoffeeUtil.deleteCoffeeInNewUserTransaction(postConstructCoffee.getId(), this.em, this.ut);
            }
        }
    }
}

