/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb.ee.bb.entity.cmp20.homemethodstest;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.util.TSNamingContext;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.homemethodstest.TestBean;
import com.sun.ts.tests.ejb.ee.bb.entity.cmp20.homemethodstest.TestBeanHome;
import java.util.Collection;
import java.util.Properties;
import javax.rmi.PortableRemoteObject;

public class Client
extends EETest {
    private static final String testName = "HomeTest";
    private static final String testBean = "java:comp/env/ejb/TestBean";
    private static final String testProps = "homemethodstest.properties";
    private TestBean beanRef = null;
    private TestBean beanRef2 = null;
    private TestBeanHome beanHome = null;
    private Properties props = null;
    private TSNamingContext nctx = null;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        this.props = p;
        try {
            this.logMsg("Obtain naming context");
            this.nctx = new TSNamingContext();
            this.logMsg("Looking up home interface for EJB: java:comp/env/ejb/TestBean");
            this.beanHome = (TestBeanHome)this.nctx.lookup(testBean, TestBeanHome.class);
            this.logTrace("Check for existing data before test run");
            this.prepareTestData();
            this.logMsg("Setup ok");
        }
        catch (Exception e) {
            TestUtil.printStackTrace((Throwable)e);
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void test1() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.create(1, "John", "Edward", "Brown", "100-200-300");
            this.beanRef.initLogging(this.props);
            this.logMsg("Look up Customer by Primary Key");
            this.beanRef2 = this.beanHome.findByPrimaryKey(new Integer(1));
            pass = true;
            this.logMsg("Customer Found by Primary Key ");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test1: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.beanRef != null) {
                    this.beanRef.remove();
                    TestUtil.logTrace((String)"Removing beanRef from test1");
                } else {
                    TestUtil.logTrace((String)"beanRef in test1 is null");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception test1: " + e));
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test1 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test2() throws EETest.Fault {
        TestBean beanRef = null;
        TestBean beanRef2 = null;
        boolean pass = true;
        try {
            this.logMsg("Create EJB instance");
            beanRef = this.beanHome.create(2, "100-200-300", "VISA", 1000.0, "3450678912348090", "1102");
            beanRef.initLogging(this.props);
            this.logMsg("Look up Payment by Primary Key");
            beanRef2 = this.beanHome.findByPrimaryKey(new Integer(2));
            pass = true;
            this.logMsg("Payment Found by Primary Key");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test2: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (beanRef != null) {
                    beanRef.remove();
                    TestUtil.logTrace((String)"Removing beanRef from test2");
                } else {
                    TestUtil.logTrace((String)"beanRef in test2 is null");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception test2: " + e));
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test2 failed");
        }
    }

    public void test3() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.createHomeAddress(3, "10 Spring Street", "Boston", "MA", 1101);
            this.beanRef.initLogging(this.props);
            this.logMsg("Look up Address by Primary Key");
            this.beanRef2 = this.beanHome.findByPrimaryKey(new Integer(3));
            pass = true;
            this.logMsg("Address Found by Primary Key ");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test3: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.beanRef != null) {
                    this.beanRef.remove();
                    TestUtil.logTrace((String)"Removing beanRef from test3");
                } else {
                    TestUtil.logTrace((String)"beanRef in test3 is null");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception test3: " + e));
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test3 failed");
        }
    }

    public void test4() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.createCountry(4, "United States", "USA");
            this.beanRef.initLogging(this.props);
            this.logMsg("Look up Country by Primary Key");
            this.beanRef2 = this.beanHome.findByPrimaryKey(new Integer(4));
            pass = true;
            this.logMsg("Country Found by Primary Key ");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test4: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.beanRef != null) {
                    this.beanRef.remove();
                    TestUtil.logTrace((String)"Removing beanRef from test4");
                } else {
                    TestUtil.logTrace((String)"beanRef in test4 is null");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception test4: " + e));
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test4 failed");
        }
    }

    public void test5() throws EETest.Fault {
        boolean pass = true;
        try {
            this.logMsg("Create EJB instance");
            this.beanRef = this.beanHome.createPhone(5, "617-225-9086", "781-288-9843");
            this.beanRef.initLogging(this.props);
            this.logMsg("Look up Phone by Primary Key");
            this.beanRef2 = this.beanHome.findByPrimaryKey(new Integer(5));
            pass = true;
            this.logMsg("Phone Found by Primary Key ");
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception test5: " + e));
            TestUtil.printStackTrace((Throwable)e);
            pass = false;
        }
        finally {
            try {
                if (this.beanRef != null) {
                    this.beanRef.remove();
                    TestUtil.logTrace((String)"Removing beanRef from test5");
                } else {
                    TestUtil.logTrace((String)"beanRef in test5 is null");
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception test5: " + e));
                TestUtil.printStackTrace((Throwable)e);
            }
        }
        if (!pass) {
            throw new EETest.Fault("test5 failed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test6() throws EETest.Fault {
        block23: {
            TestBean beanRef = null;
            TestBean beanRef2 = null;
            TestBean beanRef3 = null;
            boolean pass = true;
            double fee = 50.0;
            double minimumBal = 500.0;
            double expectedBal1 = 509.0;
            double expectedBal2 = 2025.0;
            double expectedBal3 = 350.0;
            Collection b1 = null;
            try {
                this.logMsg("Create EJB instance");
                beanRef = this.beanHome.create(3, "103-203-303", "MASTERCARD", 459.0, "4569543201237989", "0801");
                beanRef.initLogging(this.props);
                beanRef2 = this.beanHome.create(4, "104-204-304", "AMEX", 2025.0, "8365901745363321", "0502");
                this.logMsg("Initialize logging");
                beanRef2.initLogging(this.props);
                beanRef3 = this.beanHome.create(5, "105-205-305", "VISA", 300.0, "763839306103976", "0703");
                this.logMsg("Initialize logging");
                beanRef3.initLogging(this.props);
                TestUtil.logTrace((String)("Check card balances before fees:  MASTERCARD is: " + beanRef.getCardBalance() + " AMEX is: " + beanRef2.getCardBalance() + " VISA is: " + beanRef3.getCardBalance()));
                b1 = this.beanHome.findAllBeans();
                if (!b1.isEmpty()) {
                    TestUtil.logTrace((String)("Collection not empty.  Size is: " + b1.size()));
                    for (Object o : b1) {
                        TestBean bRef = (TestBean)PortableRemoteObject.narrow(o, TestBean.class);
                        if (bRef.getCardBalance() < minimumBal) {
                            Integer key = (Integer)bRef.getPrimaryKey();
                            this.beanHome.addCardFee(key, fee);
                            continue;
                        }
                        TestUtil.logTrace((String)"Account has minimum balance");
                    }
                } else {
                    TestUtil.logTrace((String)"Collection is empty");
                    pass = false;
                }
                double currentBalance1 = beanRef.getCardBalance();
                double currentBalance2 = beanRef2.getCardBalance();
                double currentBalance3 = beanRef3.getCardBalance();
                if (currentBalance1 == expectedBal1 && currentBalance2 == expectedBal2 && currentBalance3 == expectedBal3) {
                    pass = true;
                } else {
                    TestUtil.logErr((String)("Did not get expected results: Expected: " + expectedBal1 + " and " + expectedBal2 + " and " + expectedBal3 + ".  Got: " + currentBalance1 + " and " + currentBalance2 + currentBalance3));
                    pass = false;
                }
            }
            catch (Exception e) {
                TestUtil.logErr((String)("Caught exception test6: " + e));
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            finally {
                try {
                    if (beanRef != null) {
                        beanRef.remove();
                        TestUtil.logTrace((String)"Removing beanRef from test6");
                    } else {
                        TestUtil.logTrace((String)"beanRef in test6 is null");
                    }
                    if (beanRef2 != null) {
                        beanRef2.remove();
                        TestUtil.logTrace((String)"Removing beanRef2 from test6");
                    } else {
                        TestUtil.logTrace((String)"beanRef2 in test6 is null");
                    }
                    if (beanRef3 != null) {
                        beanRef3.remove();
                        TestUtil.logTrace((String)"Removing beanRef3 from test6");
                    } else {
                        TestUtil.logTrace((String)"beanRef3 in test6 is null");
                    }
                }
                catch (Exception e) {
                    TestUtil.logErr((String)("Caught exception test6: " + e));
                    TestUtil.printStackTrace((Throwable)e);
                }
                if (pass) break block23;
                throw new EETest.Fault("test6 failed");
            }
        }
    }

    public void cleanup() throws EETest.Fault {
        this.logMsg("cleanup ok");
    }

    private void prepareTestData() {
        TestUtil.logMsg((String)"Entering method prepareTestData");
        Collection c1 = null;
        try {
            c1 = this.beanHome.findAllBeans();
            if (!c1.isEmpty()) {
                TestUtil.logTrace((String)("Collection not empty.  Size is: " + c1.size()));
                for (Object o : c1) {
                    TestBean bRef = (TestBean)PortableRemoteObject.narrow(o, TestBean.class);
                    for (int l = 0; l < c1.size(); ++l) {
                        bRef.remove();
                    }
                }
            } else {
                TestUtil.logTrace((String)"No entity data to clean up");
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Exception caught preparing test data:" + e), (Throwable)e);
        }
        TestUtil.logTrace((String)"Exiting method prepareTestData");
    }
}

