/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.rmiiiop.ee.standalone;

import com.sun.ts.tests.rmiiiop.ee.standalone.PrintUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;

public class RMIIIOPHttpServer
extends Thread {
    private ServerSocket ssock = null;
    private String ior = null;
    private boolean verbose = false;

    public RMIIIOPHttpServer(String ior, int port, boolean verbose) throws Exception {
        this.ior = ior;
        this.ssock = new ServerSocket(port);
        this.verbose = verbose;
    }

    @Override
    public void run() {
        try {
            while (true) {
                if (this.verbose) {
                    PrintUtil.logMsg("RMIIIOPHttpServer ready and waiting....");
                }
                ProcessClientRequest p = new ProcessClientRequest(this.ssock.accept(), this.ior, this.verbose);
                p.start();
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    static class ProcessClientRequest
    extends Thread {
        private Socket csock = null;
        private String ior = null;
        private boolean verbose = false;

        public ProcessClientRequest(Socket s, String ior, boolean verbose) {
            this.csock = s;
            this.ior = ior;
            this.verbose = verbose;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                if (this.verbose) {
                    PrintUtil.logMsg("Processing http client request....");
                }
                InputStream is = this.csock.getInputStream();
                PrintWriter os = new PrintWriter(this.csock.getOutputStream(), true);
                if (this.verbose) {
                    PrintUtil.logMsg("Send HTTP_OK response and IOR string back to the client....");
                }
                os.print("HTTP/1.1 200 OK\r\nContent-Type: text/plain\r\n\r\n" + this.ior);
                os.flush();
                byte[] buffer = new byte[1024];
                is.read(buffer);
                os.close();
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    this.csock.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

