/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.ejb30.tx.common.session.cm;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.ejb30.common.helper.Helper;
import com.sun.ts.tests.ejb30.common.helper.TestFailedException;
import com.sun.ts.tests.ejb30.tx.common.session.cm.LocalTxIF;
import java.util.logging.Level;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.EJBContext;
import javax.ejb.EJBTransactionRequiredException;
import javax.ejb.EJBTransactionRolledbackException;
import javax.ejb.SessionContext;
import javax.transaction.NotSupportedException;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;

public abstract class LocalTestBeanBase {
    @EJB(name="localTxBean")
    protected LocalTxIF localTxBean;
    @Resource
    private SessionContext sctx;

    public EJBContext getEJBContext() {
        return this.sctx;
    }

    public String localMandatoryTest() throws TestFailedException {
        String reason = null;
        try {
            this.localTxBean.localMandatoryTest();
            reason = "Expecting javax.ejb.EJBTransactionRequiredException, but got none";
            throw new TestFailedException(reason);
        }
        catch (EJBTransactionRequiredException e) {
            reason = "Got expected EJBTransactionRequiredException";
            Helper.getLogger().info(reason);
            return reason;
        }
    }

    public String localSupportsTest() throws TestFailedException {
        UserTransaction ut = this.getEJBContext().getUserTransaction();
        try {
            ut.begin();
            String string = this.localTxBean.localSupportsTest();
            return string;
        }
        catch (NotSupportedException e) {
            throw new TestFailedException(e);
        }
        catch (SystemException e) {
            throw new TestFailedException(e);
        }
        finally {
            try {
                ut.rollback();
            }
            catch (Exception ignore) {
                throw new TestFailedException(ignore);
            }
        }
    }

    public String localIllegalGetSetRollbackOnlyNeverTest() throws TestFailedException {
        return this.localTxBean.localIllegalGetSetRollbackOnlyNeverTest();
    }

    public String localIllegalGetSetRollbackOnlyNotSupportedTest() throws TestFailedException {
        UserTransaction ut = this.getEJBContext().getUserTransaction();
        try {
            ut.begin();
            String string = this.localTxBean.localIllegalGetSetRollbackOnlyNotSupportedTest();
            return string;
        }
        catch (NotSupportedException e) {
            throw new TestFailedException(e);
        }
        catch (SystemException e) {
            throw new TestFailedException(e);
        }
        finally {
            try {
                ut.rollback();
            }
            catch (Exception ignore) {
                throw new TestFailedException(ignore);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public String localNeverTest() throws TestFailedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [7[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public String localRequiresNewTest() throws TestFailedException {
        String result = null;
        UserTransaction ut = this.getEJBContext().getUserTransaction();
        try {
            ut.begin();
            this.localTxBean.localRequiresNewTest();
            int status = ut.getStatus();
            result = Helper.assertEquals("Check tx status", TestUtil.getTransactionStatus((int)0), TestUtil.getTransactionStatus((int)status));
            Helper.getLogger().logp(Level.FINE, "LocalTestBeanBase", "localRequiresNewTest", "Checking tx status, result: " + result);
        }
        catch (Exception e) {
            throw new TestFailedException(e);
        }
        finally {
            try {
                ut.rollback();
            }
            catch (Exception exception) {}
        }
        return result;
    }

    public String localRequiresNewRemoveTest() throws TestFailedException {
        throw new IllegalStateException("This method should not be called for stateless beans");
    }

    public void remove() {
        throw new IllegalStateException("This method should not be called for stateless beans");
    }

    public String localSystemExceptionTest() throws TestFailedException {
        String result = null;
        UserTransaction ut = this.getEJBContext().getUserTransaction();
        try {
            try {
                ut.begin();
                String s = this.localTxBean.systemExceptionTest();
                throw new TestFailedException("Expecting EJBTransactionRolledbackException, but got no exception: " + s);
            }
            catch (NotSupportedException e) {
                throw new TestFailedException(e);
            }
            catch (SystemException e) {
                throw new TestFailedException(e);
            }
            catch (EJBTransactionRolledbackException e) {
                result = "Got expected EJBTransactionRolledbackException.";
                Integer status = null;
                try {
                    status = ut.getStatus();
                }
                catch (SystemException ex) {
                    throw new TestFailedException(result + " Failed to get tx status", ex);
                }
                if (status == 1) {
                    String string = result + " Got expected tx status " + status;
                    return string;
                }
                throw new TestFailedException(result + " but tx status is " + status);
            }
        }
        finally {
            try {
                ut.rollback();
            }
            catch (Exception ignore) {
                throw new TestFailedException(ignore);
            }
        }
    }
}

