/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jaspic.tssv.util;

import com.sun.ts.tests.jaspic.tssv.util.ProviderConfigurationEntry;
import com.sun.ts.tests.jaspic.tssv.util.ProviderConfigurationXMLFileProcessor;
import com.sun.ts.tests.jaspic.tssv.util.TSFileHandler;
import com.sun.ts.tests.jaspic.tssv.util.TSLogger;
import com.sun.ts.tests.jaspic.tssv.util.TSXMLFormatter;
import java.util.Collection;
import java.util.logging.Level;

public class IdUtil {
    private static ProviderConfigurationXMLFileProcessor configFileProcessor = null;
    private static TSLogger logger = null;

    public IdUtil() {
        IdUtil.initializeTSLogger();
    }

    public static String getAppContextId(String msgLayer) {
        String providerConfigFileLocation = System.getProperty("provider.configuration.file");
        try {
            configFileProcessor = new ProviderConfigurationXMLFileProcessor(providerConfigFileLocation);
            Collection<ProviderConfigurationEntry> providerConfigurationEntriesCollection = configFileProcessor.getProviderConfigurationEntriesCollection();
            ProviderConfigurationEntry pce2 = null;
            String appContextId = null;
            for (ProviderConfigurationEntry pce2 : providerConfigurationEntriesCollection) {
                if (pce2 == null) continue;
                appContextId = pce2.getApplicationContextId();
                String pceMsgLayer = pce2.getMessageLayer();
                if (!msgLayer.equalsIgnoreCase(pceMsgLayer) || appContextId.equalsIgnoreCase("null")) continue;
                return appContextId;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getMessage() != null && !e.getMessage().equals("")) {
                logger.log(Level.SEVERE, e.getMessage());
            }
            logger.log(Level.SEVERE, "Error in getAppContextId()");
        }
        return "";
    }

    private static void initializeTSLogger() {
        String logFileLocation = null;
        if (logger != null) {
            return;
        }
        try {
            logFileLocation = System.getProperty("log.file.location");
            System.out.println("logFileLocation = " + logFileLocation);
            if (logFileLocation == null) {
                throw new RuntimeException("log.file.location not set");
            }
            logger = TSLogger.getTSLogger("jsr196");
            boolean appendMode = true;
            TSFileHandler fileHandler = new TSFileHandler(logFileLocation + "/" + "TSSVLog.txt", appendMode);
            fileHandler.setFormatter(new TSXMLFormatter());
            logger.addHandler(fileHandler);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("TSLogger Initialization failed", e);
        }
    }
}

