/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.common.vehicle.stateless3;

import com.sun.ts.tests.common.vehicle.ejb3share.EJB3ShareBaseBean;
import com.sun.ts.tests.common.vehicle.ejb3share.UserTransactionWrapper;
import com.sun.ts.tests.common.vehicle.stateless3.Stateless3VehicleIF;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateless;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceUnit;

@Stateless(name="Stateless3VehicleBean")
@PersistenceContext(name="STATELESS3EM", unitName="CTS-EM")
@Remote(value={Stateless3VehicleIF.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
public class Stateless3VehicleBean
extends EJB3ShareBaseBean
implements Stateless3VehicleIF {
    @PersistenceUnit(name="STATELESS3EMF", unitName="CTS-EM")
    EntityManagerFactory emf;

    @Override
    protected String getVehicleType() {
        return "stateless3";
    }

    @Override
    @Resource
    public void setSessionContext(SessionContext sessionContext) {
        this.sessionContext = sessionContext;
    }

    @PostConstruct
    public void init() {
        try {
            System.out.println("In PostContruct");
            EntityManager entityManager = (EntityManager)this.sessionContext.lookup("STATELESS3EM");
            EntityManagerFactory emf = (EntityManagerFactory)this.sessionContext.lookup("STATELESS3EMF");
            this.setEntityManager(entityManager);
            this.setEntityManagerFactory(emf);
        }
        catch (Exception e) {
            System.out.println("ERROR:  In PostConstruct: Exception caught while setting EntityManager");
            e.printStackTrace();
        }
    }

    @Override
    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    @Override
    public void setEntityManagerFactory(EntityManagerFactory emf) {
        this.entityManagerFactory = emf;
    }

    @Override
    protected EntityTransaction getEntityTransaction() {
        return new UserTransactionWrapper(this.sessionContext.getUserTransaction());
    }
}

