/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.jsonp.api.patchtests;

import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.jsonp.api.common.JsonAssert;
import com.sun.ts.tests.jsonp.api.common.SimpleValues;
import com.sun.ts.tests.jsonp.api.common.TestResult;
import com.sun.ts.tests.jsonp.api.patchtests.CommonOperation;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonPatchBuilder;
import javax.json.JsonPointer;
import javax.json.JsonStructure;
import javax.json.JsonValue;

public class PatchOperationMove
extends CommonOperation {
    private final String OPERATION = "MOVE";

    PatchOperationMove() {
    }

    TestResult test() {
        TestResult result = new TestResult("RFC 6902 move operation");
        TestUtil.logMsg((String)"Testing RFC 6902 move operation:");
        this.testMoveStringOnSimpleObject(result);
        this.testMoveStringOnSimpleArray(result);
        this.testMoveStringOnSimpleArray2(result);
        this.testMoveIntOnSimpleObject(result);
        this.testMoveIntOnSimpleArray(result);
        this.testMoveIntOnSimpleArray2(result);
        this.testMoveBoolOnSimpleObject(result);
        this.testMoveBoolOnSimpleArray(result);
        this.testMoveBoolOnSimpleArray2(result);
        this.testMoveObjectOnSimpleObject(result);
        this.testMoveObjectOnSimpleArray(result);
        this.testMoveObjectOnSimpleArray2(result);
        this.testMoveStringOnCompoundObject(result);
        this.testMoveOfNonExistingLocationInObject(result);
        this.testMoveOfNonExistingLocationInArray(result);
        this.testMoveVsRemoveAddOnSelfContainedPath(result);
        return result;
    }

    private void testMoveStringOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectStr();
        JsonObject check = SimpleValues.createSimpleObjectMoveStr();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/address", "/name");
    }

    private void testMoveStringOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON array of size 2");
        JsonArray in = SimpleValues.createStringArray2();
        JsonArray check = SimpleValues.createStringArray2R();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)in, "/0", "/0");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/1", "/0");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", "/1");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", "/-");
    }

    private void testMoveStringOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for String on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleStringArray5();
        JsonArray check = SimpleValues.createSimpleStringArray5R();
        this.complexOperation(result, in, check, new String[]{"/3", "/0", "/3", "/4"}, new String[]{"/1", "/2", "/1", "/0"});
        this.complexOperation(result, in, check, new String[]{"/0", "/1", "/0", "/2"}, new String[]{"/-", "/2", "/3", "/0"});
    }

    private void testMoveIntOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectInt();
        JsonObject check = SimpleValues.createSimpleObjectMoveInt();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/age", "/name");
    }

    private void testMoveIntOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON array of size 2");
        JsonArray in = SimpleValues.createIntArray2();
        JsonArray check = SimpleValues.createIntArray2R();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)in, "/0", "/0");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/1", "/0");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", "/1");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", "/-");
    }

    private void testMoveIntOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for int on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleIntArray5();
        JsonArray check = SimpleValues.createSimpleIntArray5R();
        this.complexOperation(result, in, check, new String[]{"/3", "/0", "/3", "/4"}, new String[]{"/1", "/2", "/1", "/0"});
        this.complexOperation(result, in, check, new String[]{"/0", "/1", "/0", "/2"}, new String[]{"/-", "/2", "/3", "/0"});
    }

    private void testMoveBoolOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectBool();
        JsonObject check = SimpleValues.createSimpleObjectMoveBool();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/married", "/name");
    }

    private void testMoveBoolOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON array of size 2");
        JsonArray in = SimpleValues.createBoolArray2();
        JsonArray check = SimpleValues.createBoolArray2R();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)in, "/0", "/0");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/1", "/0");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", "/1");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", "/-");
    }

    private void testMoveBoolOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for boolean on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleBoolArray5();
        JsonArray check = SimpleValues.createSimpleBoolArray5R();
        this.complexOperation(result, in, check, new String[]{"/3", "/0", "/3", "/4"}, new String[]{"/1", "/2", "/1", "/0"});
        this.complexOperation(result, in, check, new String[]{"/0", "/1", "/0", "/2"}, new String[]{"/-", "/2", "/3", "/0"});
    }

    private void testMoveObjectOnSimpleObject(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON object");
        JsonObject in = SimpleValues.createSimpleObjectObject();
        JsonObject check = SimpleValues.createSimpleObjectMoveObject();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/wife", "/name");
    }

    private void testMoveObjectOnSimpleArray(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON array of size 2");
        JsonArray in = SimpleValues.createObjectArray2();
        JsonArray check = SimpleValues.createObjectArray2R();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)in, "/0", "/0");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/1", "/0");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", "/1");
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/0", "/-");
    }

    private void testMoveObjectOnSimpleArray2(TestResult result) {
        TestUtil.logMsg((String)" - for JsonObject on simple JSON array of size 5");
        JsonArray in = SimpleValues.createSimpleObjectArray5();
        JsonArray check = SimpleValues.createSimpleObjectArray5R();
        this.complexOperation(result, in, check, new String[]{"/3", "/0", "/3", "/4"}, new String[]{"/1", "/2", "/1", "/0"});
        this.complexOperation(result, in, check, new String[]{"/0", "/1", "/0", "/2"}, new String[]{"/-", "/2", "/3", "/0"});
    }

    private void testMoveStringOnCompoundObject(TestResult result) {
        TestUtil.logMsg((String)" - for String on compound JSON object");
        JsonObject in = SimpleValues.createCompoundObject();
        JsonObject check = SimpleValues.createCompoundObjectMoveValue();
        this.simpleOperation(result, (JsonValue)in, (JsonValue)check, "/name", "/child/name");
    }

    private void testMoveOfNonExistingLocationInObject(TestResult result) {
        TestUtil.logMsg((String)" - for non existing location in JsonObject");
        JsonObject[] objsIn = new JsonObject[]{SimpleValues.createEmptyObject(), SimpleValues.createSimpleObject(), SimpleValues.createCompoundObject()};
        String[] paths = new String[]{"/address", "/age", "/married", "/wife"};
        Object[] values = new Object[]{"/wife", "/married", "/age", "/address"};
        for (int i = 0; i < objsIn.length; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                this.simpleOperationFail(result, (JsonValue)objsIn[i], paths[j], values[i]);
            }
        }
    }

    private void testMoveOfNonExistingLocationInArray(TestResult result) {
        TestUtil.logMsg((String)" - for non existing location in JsonArray");
        JsonArray[] arraysIn = new JsonArray[]{SimpleValues.createEmptyArray(), SimpleValues.createStringArray1(), SimpleValues.createIntArray2(), SimpleValues.createSimpleBoolArray5(), SimpleValues.createObjectArray2()};
        String[] paths = new String[]{"/", "/-1", "/-", "/5", "/0a", "/42", "/address/0"};
        Object[] values = new Object[]{"/0", "/1", "/2", "/5", "/1"};
        for (int i = 0; i < arraysIn.length; ++i) {
            for (int j = 0; j < paths.length; ++j) {
                this.simpleOperationFail(result, (JsonValue)arraysIn[i], paths[j], values[i]);
            }
        }
    }

    private void testMoveVsRemoveAddOnSelfContainedPath(TestResult result) {
        JsonObject moveOut;
        JsonObject remAddOut;
        TestUtil.logMsg((String)" - for moving JsonObject under itself");
        JsonObject in = SimpleValues.createCompoundObject();
        String targetPath = "/child/name";
        JsonPointer ptr = Json.createPointer((String)"/child");
        JsonValue value = ptr.getValue((JsonStructure)in);
        JsonPatchBuilder moveBuilder = Json.createPatchBuilder().move("/child/name", "/child");
        JsonPatchBuilder remAddBuilder = Json.createPatchBuilder().remove("/child").add("/child/name", value);
        JsonPatch movePatch = moveBuilder.build();
        JsonPatch remAddPatch = remAddBuilder.build();
        try {
            remAddOut = (JsonObject)remAddPatch.apply((JsonStructure)in);
            TestUtil.logMsg((String)"   REMOVE and ADD passed");
        }
        catch (JsonException e) {
            remAddOut = null;
            TestUtil.logMsg((String)("   REMOVE and ADD failed: " + e.getMessage()));
        }
        try {
            moveOut = (JsonObject)movePatch.apply((JsonStructure)in);
            TestUtil.logMsg((String)"   MOVE passed");
        }
        catch (JsonException e) {
            moveOut = null;
            TestUtil.logMsg((String)("   MOVE failed: " + e.getMessage()));
        }
        if (remAddOut != null) {
            if (moveOut != null) {
                if (!JsonAssert.assertEquals((JsonValue)remAddOut, (JsonValue)moveOut)) {
                    result.fail("MOVE vs REMOVE and ADD", "Returned values are not equal");
                }
            } else {
                result.fail("MOVE vs REMOVE and ADD", "REMOVE and ADD failed but MOVE dit not");
            }
        } else if (moveOut != null) {
            result.fail("MOVE vs REMOVE and ADD", "MOVE failed but REMOVE and ADD dit not");
        }
    }

    @Override
    protected String operationName() {
        return "MOVE";
    }

    @Override
    protected JsonPatchBuilder createOperationBuilder(String path, Object value) {
        if (value instanceof String) {
            return Json.createPatchBuilder().move((String)value, path);
        }
        throw new IllegalArgumentException("Argument \"value\" is not an instance of String");
    }

    @Override
    protected JsonPatchBuilder updateOperationBuilder(JsonPatchBuilder builder, String path, Object value) {
        if (value instanceof String) {
            return builder.move((String)value, path);
        }
        throw new IllegalArgumentException("Argument \"value\" is not an instance of String");
    }
}

