/*
 * Decompiled with CFR 0.152.
 */
package com.sun.ts.tests.interop.csiv2.ew_ssln_ssln_upn_anonid.forward;

import com.sun.javatest.Status;
import com.sun.ts.lib.harness.EETest;
import com.sun.ts.lib.porting.TSURL;
import com.sun.ts.lib.util.TestUtil;
import com.sun.ts.tests.interop.csiv2.common.CSIv2AppClient;
import com.sun.ts.tests.interop.csiv2.common.CSIv2Log;
import com.sun.ts.tests.interop.csiv2.common.validation.CSIv2LogValidator;
import com.sun.ts.tests.interop.csiv2.common.validation.RequestValidationStrategy;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Properties;

public class Client
extends EETest {
    private Properties props = null;
    private TSURL ctsurl = new TSURL();
    private URL url = null;
    private URLConnection urlConn = null;
    private static final String WEBSERVERHOSTPROP = "webServerHost";
    private static final String WEBSERVERPORTPROP = "webServerPort";
    private String SERVLET = "/interop_csiv2_ew_ssln_ssln_upn_anonid_f_web/CSIv2ServletTest";
    private String webServerHost = "unknown";
    private int webServerPort = 8000;

    public static void main(String[] args) {
        Client theTests = new Client();
        Status s = theTests.run(args, System.out, System.err);
        s.exit();
    }

    public void setup(String[] args, Properties p) throws EETest.Fault {
        TestUtil.logMsg((String)"Setup");
        boolean pass = true;
        this.props = p;
        try {
            this.webServerHost = p.getProperty(WEBSERVERHOSTPROP);
            if (this.webServerHost == null) {
                pass = false;
            } else if (this.webServerHost.equals("")) {
                pass = false;
            }
            try {
                this.webServerPort = Integer.parseInt(p.getProperty(WEBSERVERPORTPROP));
            }
            catch (Exception e) {
                TestUtil.printStackTrace((Throwable)e);
                pass = false;
            }
            TestUtil.logMsg((String)("webServerHost = " + this.webServerHost));
            TestUtil.logMsg((String)("webServerPort = " + this.webServerPort));
            if (!pass) {
                TestUtil.logErr((String)"Please specify host & port of web server in ts.jte file: webServerHost, webServerPort");
                throw new EETest.Fault("Setup failed:");
            }
            TestUtil.logMsg((String)"Setup ok");
        }
        catch (Exception e) {
            throw new EETest.Fault("Setup failed:", e);
        }
    }

    public void ew_ssln_ssln_upn_anonid_sb_sb_testid4() throws EETest.Fault {
        boolean pass = true;
        String testName = "ew_ssln_ssln_upn_anonid_sb_sb_testid4";
        TestUtil.logMsg((String)testName);
        CSIv2Log log = CSIv2Log.getLog();
        log.purge();
        log.enableLoggingInterceptor(false, true);
        log.startLog();
        log.logStartAssertion(testName);
        ArrayList<String> chain = new ArrayList<String>();
        chain.add("java:comp/env/ejb/LocalSession");
        chain.add("java:comp/env/ejb/RemoteSession");
        TestUtil.logMsg((String)"Client initiated.");
        CSIv2AppClient appClient = new CSIv2AppClient();
        TestUtil.logMsg((String)"LocalSessionBean (VI) ====> RemoteSessionBean (RI).");
        appClient.invoke(chain, this.props);
        TestUtil.logMsg((String)"Client completed.");
        log.logEndAssertion();
        log.endLog();
        log.enableLoggingInterceptor(false, false);
        String logContents = log.getLogContents();
        TestUtil.logMsg((String)"Log contents:");
        TestUtil.logMsg((String)logContents);
        log.purge();
        pass = CSIv2LogValidator.validate(testName, logContents, null, new RequestValidationStrategy(false, true, false, 30), null);
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void ew_ssln_ssln_upn_anonid_wb_sb_testid4() throws EETest.Fault {
        boolean pass = true;
        String testName = "ew_ssln_ssln_upn_anonid_wb_sb_testid4";
        TestUtil.logMsg((String)testName);
        CSIv2Log log = CSIv2Log.getLog();
        log.purge();
        log.enableLoggingInterceptor(false, true);
        log.startLog();
        log.logStartAssertion(testName);
        TestUtil.logMsg((String)"Client initiated.");
        TestUtil.logMsg((String)"WebClient (VI) ====> RemoteSessionBean (RI).");
        try {
            this.url = this.ctsurl.getURL("http", this.webServerHost, this.webServerPort, this.SERVLET);
            this.props.setProperty("CHAIN", "java:comp/env/ejb/RemoteSession");
            TestUtil.logMsg((String)"Send http request to WebClient");
            this.urlConn = TestUtil.sendPostData((Properties)this.props, (URL)this.url);
            TestUtil.logMsg((String)"Get http response from WebClient");
            Properties p = TestUtil.getResponseProperties((URLConnection)this.urlConn);
            String passStr = p.getProperty("TESTRESULT");
            if (passStr.equals("false")) {
                pass = false;
            }
        }
        catch (Exception e) {
            TestUtil.logErr((String)("Caught exception: " + e.getMessage()));
            TestUtil.printStackTrace((Throwable)e);
        }
        TestUtil.logMsg((String)"Client completed.");
        log.logEndAssertion();
        log.endLog();
        log.enableLoggingInterceptor(false, false);
        String logContents = log.getLogContents();
        TestUtil.logMsg((String)"Log contents:");
        TestUtil.logMsg((String)logContents);
        log.purge();
        pass = CSIv2LogValidator.validate(testName, logContents, null, new RequestValidationStrategy(false, true, false, 30), null);
        if (!pass) {
            throw new EETest.Fault(testName + " failed");
        }
    }

    public void cleanup() throws EETest.Fault {
        TestUtil.logMsg((String)"Cleanup ok");
    }
}

